/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.DiagramFactory;
import jp.sourceforge.erep.model.diagram.Node;
import jp.sourceforge.erep.model.diagram.Point;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class CreateAddNodeCommand extends Command {

	private Node node;
	
	private Container container;
	
	private Container old;
	
	private Rectangle rectangle;
	
	private Point oldLocation;
	
	
	/**
	 * @param container
	 * @param node
	 * @param rectangle
	 */
	public CreateAddNodeCommand(Container container, Node node, Rectangle rectangle) {
		super();
		this.container = container;
		this.node = node;
		this.rectangle = rectangle;
	}

	@Override
	public void execute() {
		super.execute();
		old = node.getParent();
		oldLocation = node.getLocation();
		Point p = DiagramFactory.eINSTANCE.createPoint();
		p.setX(rectangle.x);
		p.setY(rectangle.y);
		node.setLocation(p);
		node.setParent(container);
	}
	
	@Override
	public void undo() {
		super.undo();
		node.setLocation(oldLocation);
		node.setParent(old);
	}
}
