/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class DeleteNodeCommand extends Command {

	private Node node;
	
	private Container parent;
	
	
	/**
	 * @param node
	 */
	public DeleteNodeCommand(Node node) {
		super();
		this.node = node;
		this.parent = node.getParent();
	}

	@Override
	public boolean canExecute() {
		return node != null && parent != null;
	}
	@Override
	public void execute() {
		super.execute();
		parent = node.getParent();
		parent.getContain().remove(node);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		super.undo();
		parent.getContain().add(node);
	}
}
