/**
 * 
 */
package jp.sourceforge.erep.gef.screen.command;

import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ReconnectSourceCommand extends Command {

	private Connector connector;
	
	private Node source;
	
	private Node old;
	
	
	/**
	 * @param connector
	 * @param source
	 */
	public ReconnectSourceCommand(Connector connector, Node source) {
		super();
		this.connector = connector;
		this.source = source;
	}

	@Override
	public void execute() {
		super.execute();
		old = connector.getSource();
		connector.setSource(source);
	}
	
	@Override
	public void undo() {
		super.undo();
		connector.setSource(old);
	}
}
