/**
 * 
 */
package jp.sourceforge.erep.gef.screen.factory;

import jp.sourceforge.erep.gef.screen.part.ConnectorEditPart;
import jp.sourceforge.erep.gef.screen.part.DecisionEditPart;
import jp.sourceforge.erep.gef.screen.part.DiagramEditPart;
import jp.sourceforge.erep.gef.screen.part.NodeEditPart;
import jp.sourceforge.erep.gef.screen.part.ScreenEditPart;
import jp.sourceforge.erep.gef.screen.part.TransitionEditPart;
import jp.sourceforge.erep.model.diagram.Diagram;
import jp.sourceforge.erep.model.screen.Decision;
import jp.sourceforge.erep.model.screen.Screen;
import jp.sourceforge.erep.model.screen.Transition;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

/**
 * @author shida
 *
 */
public class ScreenDiagramEditPartFactory implements EditPartFactory {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart rv = null;
		if (model instanceof Diagram) {
			rv = new DiagramEditPart();
			((DiagramEditPart) rv).addNotifier((Notifier) model);
		} else if (model instanceof Screen) {
			rv = new ScreenEditPart();
			((NodeEditPart) rv).addNotifier((Notifier) model);
		} else if (model instanceof Decision) {
			rv = new DecisionEditPart();
			((NodeEditPart) rv).addNotifier((Notifier) model);			
		} else if (model instanceof Transition) {
			rv = new TransitionEditPart();
			((ConnectorEditPart) rv).addNotifier((Notifier) model);			
		}
		if (rv != null) {
			rv.setModel(model);
		}
		return rv;
	}

}
