/**
 * 
 */
package jp.sourceforge.erep.gef.screen.factory;

import jp.sourceforge.erep.gef.screen.tree.part.DecisionTreeEditPart;
import jp.sourceforge.erep.gef.screen.tree.part.ScreenDiagramTreeEditPart;
import jp.sourceforge.erep.gef.screen.tree.part.ScreenTreeEditPart;
import jp.sourceforge.erep.gef.screen.tree.part.TransitionTreeEditPart;
import jp.sourceforge.erep.model.diagram.Diagram;
import jp.sourceforge.erep.model.screen.Decision;
import jp.sourceforge.erep.model.screen.Screen;
import jp.sourceforge.erep.model.screen.Transition;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

/**
 * @author shida
 *
 */
public class ScreenDiagramTreeEditPartFactory implements EditPartFactory {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart rv = null;
		if (model instanceof Diagram) {
			rv = new ScreenDiagramTreeEditPart();
			((ScreenDiagramTreeEditPart) rv).addNotifier((Notifier) model);
		} else if (model instanceof Screen) {
			rv = new ScreenTreeEditPart();
			((ScreenTreeEditPart) rv).addNotifier((Notifier) model);
		} else if (model instanceof Decision) {
			rv = new DecisionTreeEditPart();
			((DecisionTreeEditPart) rv).addNotifier((Notifier) model);			
		} else if (model instanceof Transition) {
			rv = new TransitionTreeEditPart();
			((TransitionTreeEditPart) rv).addNotifier((Notifier) model);			
		}
		if (rv != null) {
			rv.setModel(model);
		}
		return rv;
	}

}
