package jp.sourceforge.erep.gef.screen.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;

public class DecisionFigure extends Figure implements IModelFigure {

	public static final Dimension PREFERED_SIZE = new Dimension(30,20);
	
	public void update(EObject model) {
	}
	
	@Override
	public void paint(Graphics graphics) {
		graphics.setBackgroundColor(ColorConstants.white);
		graphics.setForegroundColor(ColorConstants.black);
		PointList list = new PointList();
		Rectangle r = getBounds();
		
		list.addPoint(1, r.height / 2);
		list.addPoint(r.width /2 , 1);
		list.addPoint(r.width -1 , r.height / 2);
		list.addPoint(r.width / 2, r.height - 1);
		list.translate(r.getLocation());
		
		graphics.fillPolygon(list);
		graphics.drawPolygon(list);
	}
	
}
