/**
 * 
 */
package jp.sourceforge.erep.gef.screen.figure;

import java.util.Iterator;

import jp.sourceforge.erep.gef.screen.ScreenPlugin;
import jp.sourceforge.erep.model.screen.Transition;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

/**
 * @author shida
 *
 */
public class TransitionFigure extends PolylineConnection implements
		IModelFigure {

	private RoundedRectangle rectangle = new RoundedRectangle();
	
	private static final Image ACTION_IMAGE = ImageDescriptor.createFromFile(ScreenPlugin.class, "icons/action16.gif").createImage(); 
	/**
	 * 
	 */
	public TransitionFigure() {
		super();
		setTargetDecoration(new PolygonDecoration());
		setForegroundColor(ColorConstants.black);
		add(rectangle, new MidpointLocator(this, 0));
		ToolbarLayout layout = new ToolbarLayout();
		layout.setMinorAlignment(ToolbarLayout.ALIGN_TOPLEFT);
		rectangle.setLayoutManager(new ToolbarLayout());
		rectangle.setLineStyle(SWT.LINE_DASH);
		rectangle.setFill(true);
		rectangle.setBackgroundColor(ColorConstants.white);
	}

	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.gef.screen.figure.IModelFigure#update(org.eclipse.emf.ecore.EObject)
	 */
	public void update(EObject model) {
		Transition transition = (Transition) model;
		rectangle.removeAll();
		int i = 0;
		for (Iterator iter = transition.getActions().iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			Label l = new Label(element, ACTION_IMAGE);
			l.setLabelAlignment(PositionConstants.LEFT);
			l.setBorder(new MarginBorder(2));
			rectangle.add(l);
			rectangle.setConstraint(l, new Integer(i));
			i ++ ;
		}
	}

	public Dimension getDefaultSize() {
		// TODO Auto-generated method stub
		return null;
	}
}
