/**
 * 
 */
package jp.sourceforge.erep.gef.screen.policy;

import jp.sourceforge.erep.gef.screen.command.CreateConnectorCommand;
import jp.sourceforge.erep.gef.screen.command.ReconnectSourceCommand;
import jp.sourceforge.erep.gef.screen.command.ReconnectTargetCommand;
import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

/**
 * @author shida
 *
 */
public class ConnectNodeEditPolicy extends GraphicalNodeEditPolicy {


	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getConnectionCompleteCommand(org.eclipse.gef.requests.CreateConnectionRequest)
	 */
	@Override
	protected Command getConnectionCompleteCommand(
			CreateConnectionRequest request) {
		CreateConnectorCommand command = (CreateConnectorCommand) request.getStartCommand();
		if (getHost().getModel() instanceof Node && command != null) {
			Node node = (Node) getHost().getModel();
			command.setTarget(node);
			return command;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getConnectionCreateCommand(org.eclipse.gef.requests.CreateConnectionRequest)
	 */
	@Override
	protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
		Connector connector = (Connector) request.getNewObject();
		if (getHost().getModel() instanceof Node) {
			Node node = (Node) getHost().getModel();
			Command command = new CreateConnectorCommand(connector, node);
			request.setStartCommand(command);
			return command;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getReconnectTargetCommand(org.eclipse.gef.requests.ReconnectRequest)
	 */
	@Override
	protected Command getReconnectTargetCommand(ReconnectRequest request) {
		Connector connector = (Connector) request.getConnectionEditPart().getModel();
		Node node = (Node) request.getTarget().getModel();
		return new ReconnectTargetCommand(connector, node);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getReconnectSourceCommand(org.eclipse.gef.requests.ReconnectRequest)
	 */
	@Override
	protected Command getReconnectSourceCommand(ReconnectRequest request) {
		Connector connector = (Connector) request.getConnectionEditPart().getModel();
		Node node = (Node) request.getTarget().getModel();		
		return new ReconnectSourceCommand(connector, node);
	}

}
