/**
 * 
 */
package jp.sourceforge.erep.gef.screen.policy;

import jp.sourceforge.erep.gef.screen.command.ChangeXYCommand;
import jp.sourceforge.erep.gef.screen.command.CreateAddNodeCommand;
import jp.sourceforge.erep.gef.screen.command.CreateNodeCommand;
import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.Node;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/**
 * @author shida
 *
 */
public class ContainerEditPolicy extends XYLayoutEditPolicy {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createAddCommand(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	@Override
	protected Command createAddCommand(EditPart child, Object constraint) {
		Container container = (Container) getHost().getModel();
		Node node = (Node) child.getModel();
		Rectangle rectangle = (Rectangle) constraint;
		return new CreateAddNodeCommand(container, node, rectangle);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy#createChangeConstraintCommand(org.eclipse.gef.EditPart, java.lang.Object)
	 */
	@Override
	protected Command createChangeConstraintCommand(EditPart child,
			Object constraint) {
		Node node = (Node) child.getModel();
		Rectangle rectangle = (Rectangle) constraint;
		return new ChangeXYCommand(node, rectangle);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getCreateCommand(org.eclipse.gef.requests.CreateRequest)
	 */
	@Override
	protected Command getCreateCommand(CreateRequest request) {
		Node node = (Node) request.getNewObject();
		Container container = (Container) getHost().getModel();
		return new CreateNodeCommand(container, node, request.getLocation(), request.getSize());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#getDeleteDependantCommand(org.eclipse.gef.Request)
	 */
	@Override
	protected Command getDeleteDependantCommand(Request request) {
		return null;
	}

}
