/**
 * 
 */
package jp.sourceforge.erep.gef.screen.tree.part;

import java.util.Iterator;

import jp.sourceforge.erep.gef.screen.ScreenPlugin;
import jp.sourceforge.erep.model.screen.Transition;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/**
 * @author shida
 *
 */
public class TransitionTreeEditPart extends BaseTreeEditPart {

	private static final Image IMAGE = ImageDescriptor.createFromFile(ScreenPlugin.class, "icons/connection_s16.gif").createImage();
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
	}
	
	private Transition getTransition() {
		return (Transition) getModel();
	}
	
	@Override
	protected String getText() {
		StringBuffer rv = new StringBuffer();
		for (Iterator iter = getTransition().getActions().iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			rv.append(element);
			if (iter.hasNext()) {
				rv.append(" | ");
			}
		}
		return rv.toString();
	}
	
	@Override
	protected Image getImage() {
		return IMAGE;
	}

}
