/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package jp.sourceforge.erep.model.diagram.impl;

import java.util.Collection;

import jp.sourceforge.erep.model.diagram.Connector;
import jp.sourceforge.erep.model.diagram.Container;
import jp.sourceforge.erep.model.diagram.DiagramPackage;
import jp.sourceforge.erep.model.diagram.Dimension;
import jp.sourceforge.erep.model.diagram.Node;
import jp.sourceforge.erep.model.diagram.Point;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link jp.sourceforge.erep.model.diagram.impl.NodeImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link jp.sourceforge.erep.model.diagram.impl.NodeImpl#getSize <em>Size</em>}</li>
 *   <li>{@link jp.sourceforge.erep.model.diagram.impl.NodeImpl#getIncoming <em>Incoming</em>}</li>
 *   <li>{@link jp.sourceforge.erep.model.diagram.impl.NodeImpl#getOutgoing <em>Outgoing</em>}</li>
 *   <li>{@link jp.sourceforge.erep.model.diagram.impl.NodeImpl#getParent <em>Parent</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NodeImpl extends ContainerImpl implements Node {
	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = null;

	/**
	 * The cached value of the '{@link #getIncoming() <em>Incoming</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncoming()
	 * @generated
	 * @ordered
	 */
	protected EList incoming = null;

	/**
	 * The cached value of the '{@link #getOutgoing() <em>Outgoing</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutgoing()
	 * @generated
	 * @ordered
	 */
	protected EList outgoing = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DiagramPackage.eINSTANCE.getNode();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLocation(Point newLocation, NotificationChain msgs) {
		Point oldLocation = location;
		location = newLocation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DiagramPackage.NODE__LOCATION, oldLocation, newLocation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(Point newLocation) {
		if (newLocation != location) {
			NotificationChain msgs = null;
			if (location != null)
				msgs = ((InternalEObject)location).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DiagramPackage.NODE__LOCATION, null, msgs);
			if (newLocation != null)
				msgs = ((InternalEObject)newLocation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DiagramPackage.NODE__LOCATION, null, msgs);
			msgs = basicSetLocation(newLocation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DiagramPackage.NODE__LOCATION, newLocation, newLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dimension getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSize(Dimension newSize, NotificationChain msgs) {
		Dimension oldSize = size;
		size = newSize;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DiagramPackage.NODE__SIZE, oldSize, newSize);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(Dimension newSize) {
		if (newSize != size) {
			NotificationChain msgs = null;
			if (size != null)
				msgs = ((InternalEObject)size).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DiagramPackage.NODE__SIZE, null, msgs);
			if (newSize != null)
				msgs = ((InternalEObject)newSize).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DiagramPackage.NODE__SIZE, null, msgs);
			msgs = basicSetSize(newSize, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DiagramPackage.NODE__SIZE, newSize, newSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getIncoming() {
		if (incoming == null) {
			incoming = new EObjectWithInverseResolvingEList(Connector.class, this, DiagramPackage.NODE__INCOMING, DiagramPackage.CONNECTOR__TARGET);
		}
		return incoming;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOutgoing() {
		if (outgoing == null) {
			outgoing = new EObjectContainmentWithInverseEList(Connector.class, this, DiagramPackage.NODE__OUTGOING, DiagramPackage.CONNECTOR__SOURCE);
		}
		return outgoing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Container getParent() {
		if (eContainerFeatureID != DiagramPackage.NODE__PARENT) return null;
		return (Container)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(Container newParent) {
		if (newParent != eContainer || (eContainerFeatureID != DiagramPackage.NODE__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, DiagramPackage.CONTAINER__CONTAIN, Container.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, DiagramPackage.NODE__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DiagramPackage.NODE__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Dimension getDefaultFigureSize() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DiagramPackage.NODE__CONTAIN:
					return ((InternalEList)getContain()).basicAdd(otherEnd, msgs);
				case DiagramPackage.NODE__INCOMING:
					return ((InternalEList)getIncoming()).basicAdd(otherEnd, msgs);
				case DiagramPackage.NODE__OUTGOING:
					return ((InternalEList)getOutgoing()).basicAdd(otherEnd, msgs);
				case DiagramPackage.NODE__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, DiagramPackage.NODE__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DiagramPackage.NODE__CONTAIN:
					return ((InternalEList)getContain()).basicRemove(otherEnd, msgs);
				case DiagramPackage.NODE__LOCATION:
					return basicSetLocation(null, msgs);
				case DiagramPackage.NODE__SIZE:
					return basicSetSize(null, msgs);
				case DiagramPackage.NODE__INCOMING:
					return ((InternalEList)getIncoming()).basicRemove(otherEnd, msgs);
				case DiagramPackage.NODE__OUTGOING:
					return ((InternalEList)getOutgoing()).basicRemove(otherEnd, msgs);
				case DiagramPackage.NODE__PARENT:
					return eBasicSetContainer(null, DiagramPackage.NODE__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case DiagramPackage.NODE__PARENT:
					return eContainer.eInverseRemove(this, DiagramPackage.CONTAINER__CONTAIN, Container.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DiagramPackage.NODE__CONTAIN:
				return getContain();
			case DiagramPackage.NODE__LOCATION:
				return getLocation();
			case DiagramPackage.NODE__SIZE:
				return getSize();
			case DiagramPackage.NODE__INCOMING:
				return getIncoming();
			case DiagramPackage.NODE__OUTGOING:
				return getOutgoing();
			case DiagramPackage.NODE__PARENT:
				return getParent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DiagramPackage.NODE__CONTAIN:
				getContain().clear();
				getContain().addAll((Collection)newValue);
				return;
			case DiagramPackage.NODE__LOCATION:
				setLocation((Point)newValue);
				return;
			case DiagramPackage.NODE__SIZE:
				setSize((Dimension)newValue);
				return;
			case DiagramPackage.NODE__INCOMING:
				getIncoming().clear();
				getIncoming().addAll((Collection)newValue);
				return;
			case DiagramPackage.NODE__OUTGOING:
				getOutgoing().clear();
				getOutgoing().addAll((Collection)newValue);
				return;
			case DiagramPackage.NODE__PARENT:
				setParent((Container)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DiagramPackage.NODE__CONTAIN:
				getContain().clear();
				return;
			case DiagramPackage.NODE__LOCATION:
				setLocation((Point)null);
				return;
			case DiagramPackage.NODE__SIZE:
				setSize((Dimension)null);
				return;
			case DiagramPackage.NODE__INCOMING:
				getIncoming().clear();
				return;
			case DiagramPackage.NODE__OUTGOING:
				getOutgoing().clear();
				return;
			case DiagramPackage.NODE__PARENT:
				setParent((Container)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DiagramPackage.NODE__CONTAIN:
				return contain != null && !contain.isEmpty();
			case DiagramPackage.NODE__LOCATION:
				return location != null;
			case DiagramPackage.NODE__SIZE:
				return size != null;
			case DiagramPackage.NODE__INCOMING:
				return incoming != null && !incoming.isEmpty();
			case DiagramPackage.NODE__OUTGOING:
				return outgoing != null && !outgoing.isEmpty();
			case DiagramPackage.NODE__PARENT:
				return getParent() != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //NodeImpl
