/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

void
eh_accesslog_init (eh_accesslog_t *ea, const struct sockaddr_in *client_addr)
{
  memset (ea, 0, sizeof (*ea));
  ea->addr = *client_addr;
}

static void
eh_accesslog_clear (eh_accesslog_t *ea)
{
  if (ea->request_line)
    x_free (ea->request_line);
  ea->request_line = NULL;
  if (ea->remote_user)
    x_free (ea->remote_user);
  ea->remote_user = NULL;
#if 0
  if (ea->agent)
    x_free (ea->agent);
  ea->agent = NULL;
  if (ea->referer)
    x_free (ea->referer);
  ea->referer = NULL;
  ea->accesslog_fp = NULL;
#endif
}

void
eh_accesslog_new_request (eh_accesslog_t *ea, const char *request_line)
{
  eh_accesslog_clear (ea);
  ea->request_line = request_line ? x_strdup (request_line) : NULL;
}

#if 0
void
eh_accesslog_set_logfile (eh_accesslog_t *ea, FILE *accesslog_fp, int combined)
{
  ea->accesslog_fp = accesslog_fp;
  ea->combined = combined;
}
#endif

void
eh_accesslog_set_remote_user (eh_accesslog_t *ea, const char *uname)
{
  if (ea->remote_user)
    x_free (ea->remote_user);
  ea->remote_user = x_strdup (uname);
}

void
eh_accesslog_set_response_status (eh_accesslog_t *ea, int status,
				  size_t bodylen)
{
  ea->response_status = status;
  ea->response_length = bodylen;
}

void
eh_accesslog_log (eh_accesslog_t *ea, FILE *fp, int combined,
		  eh_strhash_t *nolog_ht,
		  const char *user_agent,
		  const char *referer, const char *debugstr)
{
  unsigned long addr;
  char *reqline;
  if (!fp)
    return;
  if (nolog_ht->num_ent_total > 0) {
    char buf[32 + 1];
    snprintf (buf, 32, "%d", ea->response_status);
    buf[32] = '\0';
    if (eh_strhash_find (nolog_ht, buf, NULL))
      return;
  }
  addr = ntohl (ea->addr.sin_addr.s_addr);
  reqline = ea->request_line
    ? eh_strdup_escape_doublequotes (ea->request_line) : NULL;
  fprintf (fp, "%lu.%lu.%lu.%lu %s %s [%s] \"%s\" %d %lu",
	   (addr >> 24) & 0xff,
	   (addr >> 16) & 0xff,
	   (addr >>  8) & 0xff,
	   (addr >>  0) & 0xff,
	   debugstr ? debugstr : "-",
	   ea->remote_user ? ea->remote_user : "-",
	   eh_fd_get_time_string_logformat (),
	   reqline ? reqline : "",
	   ea->response_status,
	   (unsigned long)ea->response_length);
  if (reqline)
    x_free (reqline);
  if (combined) {
    char *ref, *agent;
    ref = referer ? eh_strdup_escape_doublequotes (referer) : NULL;
    agent = user_agent ? eh_strdup_escape_doublequotes (user_agent) : NULL;
    fprintf (fp, " \"%s\" \"%s\"\n",
	     ref ? ref : "-",
	     agent ? agent : "-");
    if (ref)
      x_free (ref);
    if (agent)
      x_free (agent);
  } else {
    fputc ('\n', fp);
  }
  eh_accesslog_clear (ea);
}

void
eh_accesslog_discard (eh_accesslog_t *ea)
{
  eh_accesslog_clear (ea);
}

