/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_CONF_H
#define EH_CONF_H

#define EH_ALLOWOVERRIDE_AUTHCONFIG   (1<<0)
#define EH_ALLOWOVERRIDE_OPTIONS      (1<<1)

typedef enum {
  eh_method_head           = (1<<0),
  eh_method_get            = (1<<1),
  eh_method_post           = (1<<2),
  eh_method_put            = (1<<3),
  eh_method_delete         = (1<<4),
  eh_method_options        = (1<<5),
  eh_method_trace          = (1<<6),
  eh_method_connect        = (1<<7),
  eh_method_unknown        = (1<<30),
  eh_method_allmask        = ((1<<30) - 1),
} eh_method_t;

typedef struct {
  int auth_required;
  char **require;
  eh_strhash_t *passwd_ht;      /* hash_map <char *, char *> */
  eh_method_t method_mask;
} eh_config_limit_t;

typedef struct {
  int num_limit;
  eh_config_limit_t **limit_arr;
  eh_config_limit_t *default_limit;
  char *pattern;
  regex_t re;
} eh_config_filesmatch_t;

struct eh_connection_s;
struct eh_request_s;
struct eh_rhandler_s;
typedef struct {
  int is_handler;
  char *name;       /* handler name or mime type */
  struct eh_rhandler_s *(*rhfunc) (struct eh_connection_s *ec,
				   const struct eh_request_s *er,
				   void *data);
  void *rhfunc_data;
  int nofilesystem : 1;
} eh_addhandler_t;

struct eh_config_global_s;

typedef struct {
  eh_config_filesmatch_t **filesmatch_arr;
  eh_config_filesmatch_t *default_filesmatch;
  struct eh_config_global_s *econf_global_ref;
  char **directoryindexes;
  char *defaulttype;
  char *authuserfile;
  char *authname;
  int authrequiressl;
  int option_indexes : 1;
  int option_nofilecache : 1;
  int ssl_verifyclient : 1;
  int sslverifydepth;
  int sslrequiressl;
  int num_filesmatch;
  eh_strhash_t *addhandler_ht;  /* hash_map <char *, eh_addhandler_t *> */
} eh_config_dir_t;

typedef struct {
  char *dirname;
  eh_config_dir_t *dir;         /* don't free */
  int nearest_prefix;
} eh_config_dirarr_ent_t;

typedef struct {
  char *src;
  char *dest;
  char *rhfunc_name;
  struct eh_rhandler_s *(*rhfunc) (struct eh_connection_s *ec,
				   const struct eh_request_s *er,
				   void *data);
  void *rhfunc_data;
  int nofilesystem : 1;
} eh_config_aliasarr_ent_t;

typedef struct {
  eh_strhash_t *dir_ht;		/* hash_map <char *, eh_config_dir_t *> */
  eh_config_dir_t *default_dir;
  int num_dir;
  eh_config_dirarr_ent_t *dir_arr;
  struct eh_config_global_s *econf_global_ref;
  struct sockaddr_in servaddr;
  char *accesslog_filename_per_worker;
  char *documentroot_fullpath;
  /////////////
  char **passenv;
  char *documentroot;
  char *servername;
  char *serveradmin;
  char *customlog;
  char *sslcertificatefile;
  char *sslcertificatekeyfile;
  char *sslcacertificatefile;
  char *ssldhparamfile;
  char *sslciphersuite;
  char *typesconfig;
  char *errordocumentdir;
  int port;
  int sslport;
  int keepalive;
  int timeout;
  int num_alias;
  int log_combined;
  eh_strhash_t *nolog_ht;       /* hash_map <char *, const char *> */
  eh_config_aliasarr_ent_t *alias_arr;
  FILE *access_log;
} eh_config_vhost_t;

typedef struct eh_config_global_s {
  eh_strhash_t *vhost_ht;	/* hash_map <char *, eh_config_vhost_t *> */
  eh_filespool_t *accesslog_spool;
  eh_config_vhost_t *default_vhost;
  char *change_root_fullpath;
  int num_vhosts;
  int fatal_error;
  char *error_string;
  int use_access_log;
  /////////////
  char *serverroot;
  char *user;
  char *group;
  char *bindaddress;
  char *changeroot;
  int maxfiles;
  int startservers;
  int listenbacklog;
  int filecachesize;
  int filecachethreshold;
  int sendbuffersize;
  int recvbuffersize;
  int requestheaderlimit;
  int requestbodylimit;
  int lingeringcloselimit;
  int forcelingeringclose;
  int sendcgierrors;
  int multipleaccept;
  int scriptevalmax;
} eh_config_global_t;

eh_config_global_t *eh_config_global_new (const char *path);
void eh_config_global_delete (eh_config_global_t *econf);
void eh_config_global_log_errors (eh_config_global_t *econf);
int eh_config_global_prepare_tables (eh_config_global_t *econf);
void eh_config_global_prepare_accesslog (eh_config_global_t *econf,
					 long worker_id);
void eh_config_global_set_worker_id (eh_config_global_t *econf,
				     long worker_id, long num_workers);
void eh_config_global_flush_accesslog (eh_config_global_t *econf);

eh_config_vhost_t *eh_config_vhost_new ();
void eh_config_vhost_delete (eh_config_vhost_t *ecv);

eh_addhandler_t *eh_addhandler_new (int is_handler, const char *name);
void eh_addhandler_delete (eh_addhandler_t *ah);

eh_config_dir_t *eh_config_dir_new ();
void eh_config_dir_delete (eh_config_dir_t *ecd);

int eh_config_global_read (eh_config_global_t *econf, const char *path);
eh_config_vhost_t *eh_config_global_find_create_vhost (eh_config_global_t *ecg,
						       const char *hostname);
eh_config_vhost_t *eh_config_global_find_vhost (eh_config_global_t *ecg,
						const char *hostname);
eh_config_dir_t *eh_config_vhost_find_create_dir (eh_config_vhost_t *ecv,
						  const char *dirname);
eh_config_dir_t *
eh_config_vhost_get_dir (eh_config_vhost_t *ecv, const char *dirname);
unsigned int eh_config_vhost_dir_get_allowoverride (eh_config_vhost_t *ecv,
						    const char *dirname);
int eh_config_vhost_check_alias (eh_config_vhost_t *ecv,
				 const char *url, const char **alias_dest_r,
				 struct eh_rhandler_s *(**rhfunc_r)
				 (struct eh_connection_s *ec,
				  const struct eh_request_s *er,
				  void *data),
				 void **rhfunc_data_r,
				 int *nofilesystem_r);
eh_config_filesmatch_t *eh_config_dir_create_filesmatch (eh_config_dir_t *ecd,
							 const char *pattern);
eh_config_limit_t *eh_config_filesmatch_create_limit (eh_config_filesmatch_t
						      *ecl,
						      const char *str);
eh_config_limit_t *eh_config_dir_get_limit (eh_config_dir_t *ecd,
					    const char *filename,
					    eh_method_t method);

eh_method_t eh_config_get_method (const char *str);
char *eh_config_get_method_mask_str (eh_method_t mask);
char *eh_config_get_fullpath (eh_config_global_t *ecg, const char *path,
			      const char *default_path);
void eh_config_global_write (eh_config_global_t *ecg, FILE *fp);

#endif


