/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

const char *
eh_html_get_doctype_decl (void)
{
  return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">";
}

char *
eh_html_strdup_server_address (const eh_request_t *er)
{
  if (er && er->econf_vhost_ref->servername)
    return x_strdup_printf ("<ADDRESS>ESE/2 HTTP Server at %s</ADDRESS>",
			    er->econf_vhost_ref->servername);
  return x_strdup ("<ADDRESS>ESE/2 HTTP Server</ADDRESS>");
}

char *
eh_html_strdup_escape (const char *str)
{
  char *r, *wp;
  int len, wlen;
  const char *rp;
  len = wlen = strlen (str);
  for (rp = str; *rp; rp++) {
    if (*rp == '&')
      wlen += 4;
    else if (*rp == '<' || *rp == '>')
      wlen += 3;
  }
  r = (char *)x_malloc (wlen + 1);
  for (rp = str, wp = r; *rp; rp++) {
    if (*rp == '&') {
      memcpy (wp, "&amp;", 5);
      wp += 5;
    } else if (*rp == '>') {
      memcpy (wp, "&gt;", 4);
      wp += 4;
    } else if (*rp == '<') {
      memcpy (wp, "&lt;", 4);
      wp += 4;
    } else {
      *wp++ = *rp;
    }
  }
  assert (wlen == (wp - r));
  *wp++ = '\0';
  return r;
}
