/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

void
eh_rhandler_on_read_request_body (eh_connection_t *ec, const char *buf,
				  size_t buflen)
{
  assert (ec->rhandler);
  if (*ec->rhandler->on_read_request_body == NULL) {
    eh_rhandler_t *eh;
    assert (ec->rhandler->body_length_left >= buflen);
    eh = ec->rhandler;
    eh->body_length_left -= buflen;
    if (eh->body_length_left == 0) {
      eh_debug ("finish");
      eh_connection_request_finish (ec);
    }
  } else {
    (*ec->rhandler->on_read_request_body)(ec->rhandler, buf, buflen);
  }
}

int eh_rhandler_do_timeout (eh_connection_t *ec)
{
  assert (ec->rhandler);
  if (*ec->rhandler->do_timeout)
    return (*ec->rhandler->do_timeout)(ec->rhandler);
  return 1;
}

void eh_rhandler_delete (eh_connection_t *ec)
{
  eh_rhandler_t *rhandler;
  assert (ec->rhandler);
  rhandler = ec->rhandler;
  ec->rhandler = NULL;
  if (rhandler->on_delete)
    (*rhandler->on_delete)(rhandler);
  else
    x_free (ec->rhandler);
  ec->rhandler = NULL;
}
