/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define EH_DONT_PROHIBIT_MALLOC
#include "esehttpd.h"

typedef struct {
  char *rhandler_name;
  eh_rhandler_new_func_t *rhfunc;
  void *rhfunc_data;
  int nofilesystem;
} eh_rhfunc_table_entry_t;

static eh_rhfunc_table_entry_t *eh_rhfunc_table = NULL;
size_t eh_rhfunc_table_entry_num = 0;

void
eh_register_rhandler (const char *rhandler_name, eh_rhandler_new_func_t *func,
		      void *rhfunc_data, int nofilesystem)
{
  size_t n = eh_rhfunc_table_entry_num;
  if (eh_rhfunc_table == NULL) {
    /* don't use x_malloc etc. eh_register_rhandler is called before main()
       is started. */
    eh_rhfunc_table = (eh_rhfunc_table_entry_t *)
      malloc (sizeof (*eh_rhfunc_table));
  } else {
    eh_rhfunc_table = (eh_rhfunc_table_entry_t *)
      realloc (eh_rhfunc_table, sizeof (*eh_rhfunc_table) * (n + 1));
  }
  assert (eh_rhfunc_table);
  eh_rhfunc_table[n].rhandler_name = strdup (rhandler_name);
  eh_rhfunc_table[n].rhfunc = func;
  eh_rhfunc_table[n].rhfunc_data = rhfunc_data;
  eh_rhfunc_table[n].nofilesystem = nofilesystem;
  eh_rhfunc_table_entry_num++;
  eh_debug ("register %s", rhandler_name);
}

eh_rhandler_new_func_t *
eh_get_rhandler (const char *rhandler_name, void **rhfunc_data_r,
		 int *nofilesystem_r)
{
  size_t i;
  for (i = 0; i < eh_rhfunc_table_entry_num; i++) {
    if (strcmp (rhandler_name, eh_rhfunc_table[i].rhandler_name) == 0) {
      *rhfunc_data_r = eh_rhfunc_table[i].rhfunc_data;
      *nofilesystem_r = eh_rhfunc_table[i].nofilesystem;
      return eh_rhfunc_table[i].rhfunc;
    }
  }
  return NULL;
}

