/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_STATUSCODE_H
#define EH_STATUSCODE_H

typedef struct {
  eh_strhash_t *ht;
} eh_statuscode_table_t;

void eh_statuscode_table_init (eh_statuscode_table_t *sc, const char *path);
void eh_statuscode_table_discard (eh_statuscode_table_t *sc);


void eh_connection_append_wvec_response (eh_connection_t *ec,
					 eh_method_t method,
					 const char *status_code,
					 const char *headers,
					 const char *body, size_t body_len);
void eh_connection_append_wvec_response_with_content_length
(eh_connection_t *ec, eh_method_t method, const char *status_code,
 const char *headers, const char *body, size_t body_len,
 size_t content_length);

#endif

