/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_STRBUF_H
#define EH_STRBUF_H

typedef struct {
  char *buffer;
  size_t buffer_len;
  size_t buffer_alloclen;
  size_t read_limit;
  size_t read_len;
  size_t write_len;
} eh_strbuf_t;

void eh_strbuf_init (eh_strbuf_t *bp_r, size_t read_limit);
void eh_strbuf_discard (eh_strbuf_t *bp);
void eh_strbuf_set_read_limit (eh_strbuf_t *bp, size_t read_limit);
void eh_strbuf_append (eh_strbuf_t *bp, const char *str, size_t len);
void eh_strbuf_remove (eh_strbuf_t *bp, size_t len);
int eh_strbuf_readok (eh_strbuf_t *bp);
int eh_strbuf_writeok (eh_strbuf_t *bp);
int eh_strbuf_read_append (eh_strbuf_t *bp, int fd);
int eh_strbuf_ssl_read_append (eh_strbuf_t *bp, SSL *sslcon);
int eh_strbuf_write_remove (eh_strbuf_t *bp, int fd);

#endif

