/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_STRHASH_H
#define EH_STRHASH_H

/* entry is a pair of key and value */
typedef struct {
  char *key;
  void *val;
} eh_strhash_entry_t;

/* bucket is an array of entries */
typedef struct {
  eh_strhash_entry_t *ent;
  size_t num_ent;
} eh_strhash_bucket_t;

/* hashtable is an array of buckets */
typedef struct {
  eh_strhash_bucket_t *bucket;
  size_t num_bucket;
  size_t num_ent_total;
  void (*on_destroy)(eh_strhash_entry_t *);
} eh_strhash_t;

typedef struct {
  size_t bucket_num;
  size_t ent_num;
} eh_strhash_iter_t;

eh_strhash_t *eh_strhash_new (size_t table_size,
			      void (*on_destroy)(eh_strhash_entry_t *));
void eh_strhash_delete (eh_strhash_t *sh);
unsigned int eh_strhash_hash (const char *key);
void *eh_strhash_find_fast (eh_strhash_t *sh, const char *key,
			    unsigned int hash_val,
			    void *notfound_val);
void *eh_strhash_find (eh_strhash_t *sh, const char *key,
		       void *notfound_val);
void eh_strhash_remove (eh_strhash_t *sh, const char *key);
/* returns an entry whose key is equivalent to 'key'. if not found,
   a new entry is created as ('key', NULL). don't forget to free 'key'
   when the returned entry is not a new one and 'key' is an allocated
   pointer. typical usage should look like:
	ent = eh_strhash_find_create (sh, key);
	if (ent->key != key) {
		free (key);
	}
   .
*/
eh_strhash_entry_t *eh_strhash_find_create (eh_strhash_t *sh, char *key);
eh_strhash_entry_t *eh_strhash_find_create_fast (eh_strhash_t *sh,
						 char *key,
						 unsigned int hash_val);
void eh_strhash_foreach (eh_strhash_t *sh,
			 void (*func)(eh_strhash_entry_t *ent, void *data),
			 void *data);
void eh_strhash_dump (eh_strhash_t *sh);

#endif
