/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "esehttpd.h"

eh_rhandler_t eh_vacuum_tmpl = {
  0, NULL,
  NULL, /* on_read_request_body */
  NULL, /* do_timeout */
  NULL, /* on_delete */
};

eh_rhandler_t *
eh_rhandler_vacuum_new (struct eh_connection_s *ec, const eh_request_t *er)
{
  eh_rhandler_t *eh;
  eh_debug ("");
  if (er->request_body_length == 0) {
    eh_connection_request_finish (ec);
    return NULL;
  }
  eh = (eh_rhandler_t *)x_malloc (sizeof (*eh));
  memcpy (eh, &eh_vacuum_tmpl, sizeof (*eh));
  eh->body_length_left = er->request_body_length;
  return eh;
}

