/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_VSERVER_H
#define EH_VSERVER_H

struct eh_app_s;

typedef struct eh_vserver_s {
  struct eh_app_s *app_backref;
  eh_config_vhost_t *default_vhost;
  char *primary_hostname;
  int namevirtualhost : 1;
  int sd, sd_ssl;
  eh_fd_t *ef_socket, *ef_socket_ssl;
  SSL_CTX *sslctx;
  int connection_timeout;
  eh_mimetype_t mt;
  eh_statuscode_table_t statuscode_table;
  struct sockaddr_in servaddr;
} eh_vserver_t;

void eh_vserver_init (eh_vserver_t *ev, struct eh_app_s *app,
		      eh_config_vhost_t *vhost, const char *hostname);
void eh_vserver_attach_namevhost (eh_vserver_t *ev, eh_config_vhost_t *vhost,
				  const char *hostname);
void eh_vserver_init_ssl (eh_vserver_t *ev);
void eh_vserver_start_servers (eh_vserver_t *ev);
void eh_vserver_set_manager (eh_vserver_t *ev, int handle_event);
void eh_vserver_set_worker (eh_vserver_t *ev);
void eh_vserver_discard (eh_vserver_t *ev);

#endif
