/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_LOG_H
#define EH_LOG_H

#define EH_LOG_DEBUG (1<<0)
#define EH_LOG_INFO (1<<1)
#define EH_LOG_WARNING (1<<2)
#define EH_LOG_FATAL (1<<3)
#define EH_LOG_CONF (1<<4)

int eh_log_open (const char *filename, int lock_logfile,
		 const char *log_pattern);
void eh_log_getpid (void);
int eh_log_close (void);
void eh_log_funcname (int level, const char *funcname,
		      const char *format, ...);
void eh_log_ssl_error (int level, const char *str);

#define eh_log(level, args...) \
  eh_log_funcname (level, __PRETTY_FUNCTION__, args)

#ifdef DEBUG
#define eh_debug(args...) \
  eh_log (EH_LOG_DEBUG, args)
#else
#define eh_debug(args...)
#endif

#define eh_conferr(args...) eh_log (EH_LOG_CONF, args)

#define eh_log_perror(level, mess) \
  eh_log_funcname (level, __PRETTY_FUNCTION__, "%s: %s", \
                   mess, strerror (errno))


#define Syscall_perror(x, y, z)      \
  if ((x) < 0) {                     \
  eh_log_perror (EH_LOG_FATAL, y);   \
  (z);                               \
  }

#endif

