/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include <map>

using namespace std;

class eh_modbase {
  friend void eh_modbase_run (const char *buf, const char *bufend, void *data);
public:
  eh_modbase();
  virtual ~eh_modbase ();
  virtual void run ();
protected:
  struct {
    int status;
    string headers;
    string body;
  } response;
  string query_string, request_method, server_name, server_protocol;
  string remote_addr, remote_user, request_uri, script_filename;
  map <string, string> headers;
  const char *body_begin, *body_end;
protected:
  map <string, string> decode_form_data (const char *begin = NULL,
					 const char *end = NULL);
  string escape_html (const string& str);
};

void eh_register_hmod (const char *name, eh_modbase *(*mod_new_func)(void),
		       int nofs);

#define REGISTER_HMOD(name, klass, nofs)                  \
  static eh_modbase *klass##_dummyfunc (void) {           \
    return new klass ();                                  \
  };                                                      \
  struct klass##_dummyclass {                             \
    klass##_dummyclass ()                                 \
    { eh_register_hmod (name, klass##_dummyfunc, nofs); } \
  };                                                      \
  static klass##_dummyclass klass##_dummyobj;
