/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "modbase.h"

class eh_modheaders : public eh_modbase {
  void run () {
    response.status = 200;
    response.headers = "Content-Type: text/plain\r\n";
    response.body = "HEADERS-------------\r\n";
    map<string, string>::const_iterator i;
    for (i = headers.begin (); i != headers.end (); i++) {
      response.body += i->first + ": " + i->second + "\r\n";
    }
    response.body += "ENV-----------------\r\n";
    response.body += "query_string = " + query_string + "\r\n";
    response.body += "request_method = " + request_method + "\r\n";
    response.body += "server_name = " + server_name + "\r\n";
    response.body += "server_protocol = " + server_protocol + "\r\n";
    response.body += "remote_addr = " + remote_addr + "\r\n";
    response.body += "remote_user = " + remote_user + "\r\n";
    response.body += "request_uri = " + request_uri + "\r\n";
  }
};

REGISTER_HMOD("modheaders", eh_modheaders, 1);

