/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EH_CONNECTION_H
#define EH_CONNECTION_H

typedef struct {
  struct iovec wvec;
  void *context;
  void (*destructor)(void *context);
} eh_wvec_t;

struct eh_app_s;
struct eh_vserver_s;
typedef struct eh_connection_s {
#ifdef DEBUG
  size_t read_try_count;            /* debug info */
  size_t wrote_bytes;               /* debug info */
  size_t event_count;               /* debug info */
  size_t pollin_count;              /* debug info */
  size_t pollout_count;             /* debug info */
#endif
  struct eh_app_s *app_backref;
  struct eh_vserver_s *vserver_backref;
  eh_fd_t *client_pfd;
  eh_strbuf_t readbuf;              /* buffer for reading requests */
  eh_request_t current_request;
  eh_rhandler_t *rhandler;          /* if non-zero, the last request is a
				       complex one and handled by reqhandler.
				       we mast wait until reqhandler is
				       finished. */
  size_t delayed_strbuf_remove_len; /* length bytes removed from readbuf when
				       the current request is finished */
#if 0
  size_t reqbody_len;               /* if non-zero, the last request has a
				       request-body and of length
				       reqbody_len. */
  size_t reqbody_left;
#endif
  eh_response_connection_t rconn;   /* keepalive etc. */
  eh_wvec_t *wvec;                  /* response queue */
  size_t wvec_len;                  /* number of wvecs in use */
  size_t wvec_alloclen;
  time_t timeout;
  struct sockaddr_in client_addr;
  SSL *sslcon;
  X509 *ssl_peer;
  size_t ssl_writev_buffer_len;
  size_t ssl_writev_buffer_alloclen;
  void *ssl_writev_buffer;          /* When we retry SSL_write because of
				       EWOULDBLOCK, we must use the same
				       pointer/length pair as the previous
				       call. Or we get 'bad write retry'
				       error. */
  eh_accesslog_t accesslog;
  int connection_timeout_sec;
  int ssl_renegotiate_is_in_progress : 1;
  int ssl_x509_v_ok : 1;
  int ssl_shutdown_is_in_progress : 1;
  int ssl_want_read : 1;
  int ssl_want_write : 1;
  int shutdown_flag : 1;
  int eof_flag : 1;
  int last_request_has_body : 1;
  int is_http_1_0 : 1;
  size_t dummy_read_limit;
} eh_connection_t;

void eh_connection_new (int fd, struct eh_app_s *app, struct eh_vserver_s *vs,
			struct sockaddr_in *client_addr, int ssl_flag);
void eh_connection_append_wvec (eh_connection_t *ec, void *buf, size_t blen,
				void (*destructor)(void *context),
				void *context);
void eh_connection_set_request_events (eh_connection_t *ec, int debug_info);
void eh_connection_request_finish (eh_connection_t *ec);
void eh_connection_write_finish (eh_connection_t *ec);

#endif
