/*
 * ESE, a HyperText Transfer Protocol server
 * Copyright (C) 1996-2001 Akira Higuchi <a-higuti@math.sci.hokudai.ac.jp>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* collapse ..././... etc. */
int eh_normalize_path (char *path);

int eh_substr (const char *sub, const char *str);
int eh_str_is_member (const char *memb, const char *str, const char *delim);
char **eh_get_token_arr (const char *str);
char *eh_find_end_of_header (char *buf, size_t len);

/* arrays of strings */
char **eh_strarr_copy (const char **strarr);
void eh_strarr_free (char **strarr);

/* get the whole contents of a file */
char *eh_str_load_file (const char *fname);

/* encode/decode URI strings */
int eh_decode_url (char *str);
char *eh_strdup_encode_url (const char *str);

/* similar to strtol() */
int eh_parse_sizestr (const char *str, size_t *val_r);
int eh_is_valid_id_string (const char *str);

/* escape unsafe shell characters */
char *eh_strdup_escape_shell_chars (const char *str);

/* escape/unescape doublequotes */
int eh_unescape_doublequotes (char *str);
int eh_strsplit_unescape_doblequotes (const char *str, ...);
char *eh_strdup_escape_doublequotes (const char *str);

#define eh_for_p_in_str(str, delim, p, q) \
  for ((p) = (str), (q) = (p) + strcspn ((p), (delim)); *(p); \
       (p) = (q) + strspn ((q), (delim)), (q) = (p) + strcspn ((p), (delim)))
