/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.DataAccess;
import estoc.dbm.DataAccessImpl;
import estoc.dbm.DbType;
import estoc.dbm.SqlCreatorImpl;
import estoc.dbm.TableAccess;
import estoc.dbm.TableAccessH2;
import java.sql.Connection;

public class AccessManager {
    private final DbType dbType;

    public AccessManager(DbType dbType) {
        if (dbType == null) {
            throw new IllegalArgumentException();
        }
        this.dbType = dbType;
    }

    public DataAccess getDataAccess(Connection connection) {
        SqlCreatorImpl creator = new SqlCreatorImpl();
        return new DataAccessImpl(connection, creator);
    }

    public TableAccess getTableAccess(Connection connection) {
        TableAccessH2 tableAccess = null;
        if (this.dbType != DbType.H2) {
            throw new UnsupportedOperationException("DbType=" + (Object)((Object)this.dbType));
        }
        tableAccess = new TableAccessH2(connection);
        return tableAccess;
    }
}

