/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.DataAccess;
import estoc.dbm.DbmUtil;
import estoc.dbm.SqlCreator;
import estoc.dbm.annotate.Table;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class DataAccessImpl
implements DataAccess {
    private static final Logger LOG = Logger.getLogger("global");
    private final Connection connection;
    private final SqlCreator creator;
    Map<Class<?>, List<ColumnInfo>> fieldMap = new HashMap();
    Map<Class<?>, PreparedStatement> selectStmts = new HashMap();
    Map<Class<?>, PreparedStatement> insertStmts = new HashMap();
    Map<Class<?>, PreparedStatement> updateStmts = new HashMap();
    Map<Class<?>, PreparedStatement> deleteStmts = new HashMap();

    public DataAccessImpl(Connection connection, SqlCreator creator) {
        this.connection = connection;
        this.creator = creator;
    }

    private List<ColumnInfo> getDeclaredFields(Class<?> clz) {
        List<ColumnInfo> fields = this.fieldMap.get(clz);
        if (fields == null) {
            Field[] declaredFields;
            fields = new ArrayList<ColumnInfo>();
            Field[] fieldArray = declaredFields = clz.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fields.add(new ColumnInfo(field));
                ++n2;
            }
            this.fieldMap.put(clz, fields);
        }
        return fields;
    }

    @Override
    public <T> T select(Class<T> clz, Object ... params) throws SQLException {
        PreparedStatement stmt = this.selectStmts.get(clz);
        if (stmt == null || stmt.getConnection() != this.connection) {
            stmt = this.createSelectStmt(clz);
        }
        this.setParams(stmt, params);
        ResultSet result = stmt.executeQuery();
        if (result != null && result.next()) {
            return DbmUtil.fillData(clz, result);
        }
        return null;
    }

    private <T> PreparedStatement createSelectStmt(Class<T> clz) throws SQLException {
        LinkedHashSet<String> cols = new LinkedHashSet<String>();
        LinkedHashSet<String> pks = new LinkedHashSet<String>();
        Field[] fieldArray = clz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            ColumnInfo info = new ColumnInfo(field);
            if (info.isColumn()) {
                cols.add(field.getName());
                if (info.isPk()) {
                    pks.add(field.getName());
                }
            }
            ++n2;
        }
        String tableName = this.getTableName(clz);
        String selectSql = this.creator.getSelectSql(tableName, pks, cols);
        PreparedStatement stmt = this.connection.prepareStatement(selectSql);
        this.selectStmts.put(clz, stmt);
        return stmt;
    }

    @Override
    public boolean delete(Object obj) throws SQLException {
        Class<?> clz = obj.getClass();
        PreparedStatement stmt = this.deleteStmts.get(clz);
        if (stmt == null || stmt.getConnection() != this.connection) {
            stmt = this.createDeleteStmt(clz);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (!info.isPk()) continue;
            params.add(DbmUtil.getVlaueFromField(obj, info));
        }
        this.setParams(stmt, params.toArray());
        return stmt.executeUpdate() == 1;
    }

    private PreparedStatement createDeleteStmt(Class<?> clz) throws SQLException {
        LinkedHashSet<String> pks = new LinkedHashSet<String>();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (!info.isPk()) continue;
            pks.add(info.getName());
        }
        String tableName = this.getTableName(clz);
        String sql = this.creator.getDeleteSql(tableName, pks);
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        this.deleteStmts.put(clz, stmt);
        return stmt;
    }

    @Override
    public <T> T insert(T obj) throws SQLException {
        Class<?> clz = obj.getClass();
        PreparedStatement stmt = this.insertStmts.get(clz);
        if (stmt == null || stmt.getConnection() != this.connection) {
            stmt = this.createInsertStmt(clz);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        Date now = new Date();
        ArrayList<ColumnInfo> autoIncFields = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> timeFields = new ArrayList<ColumnInfo>();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (!info.isColumn()) continue;
            if (info.isAutoInc()) {
                autoIncFields.add(info);
                continue;
            }
            if (info.isTimeStamp()) {
                timeFields.add(info);
                params.add(now);
                continue;
            }
            params.add(DbmUtil.getVlaueFromField(obj, info));
        }
        this.setParams(stmt, params.toArray());
        LOG.info("insert " + obj.toString());
        if (stmt.executeUpdate() == 1) {
            for (ColumnInfo info : timeFields) {
                DbmUtil.setVlaueToField(obj, info, now);
            }
            ResultSet keys = stmt.getGeneratedKeys();
            int i = 0;
            while (keys.next()) {
                ColumnInfo info = (ColumnInfo)autoIncFields.get(i++);
                DbmUtil.setVlaueToField(obj, info, keys.getObject(1));
            }
            return obj;
        }
        return null;
    }

    private PreparedStatement createInsertStmt(Class<?> clz) throws SQLException {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (!info.isColumn() || info.isAutoInc()) continue;
            columns.add(info.getName());
        }
        String tableName = this.getTableName(clz);
        String sql = this.creator.getInsertSql(tableName, columns);
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        this.insertStmts.put(clz, stmt);
        return stmt;
    }

    @Override
    public <T> T update(T obj) throws SQLException {
        Class<?> clz = obj.getClass();
        PreparedStatement stmt = this.updateStmts.get(clz);
        if (stmt == null || stmt.getConnection() != this.connection) {
            stmt = this.createUpdateStmt(clz);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Object> pkParams = new ArrayList<Object>();
        ArrayList<ColumnInfo> timeFields = new ArrayList<ColumnInfo>();
        Date now = new Date();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (info.isPk()) {
                pkParams.add(DbmUtil.getVlaueFromField(obj, info));
                continue;
            }
            if (!info.isColumn()) continue;
            if (info.isTimeStamp()) {
                timeFields.add(info);
                params.add(now);
                continue;
            }
            params.add(DbmUtil.getVlaueFromField(obj, info));
        }
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.addAll(params);
        tmp.addAll(pkParams);
        this.setParams(stmt, tmp.toArray());
        LOG.info("update " + obj.toString());
        if (stmt.executeUpdate() == 1) {
            for (ColumnInfo info : timeFields) {
                DbmUtil.setVlaueToField(obj, info, now);
            }
            return obj;
        }
        return null;
    }

    private PreparedStatement createUpdateStmt(Class<?> clz) throws SQLException {
        LinkedHashSet<String> pks = new LinkedHashSet<String>();
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (ColumnInfo info : this.getDeclaredFields(clz)) {
            if (info.isPk()) {
                pks.add(info.getName());
                continue;
            }
            if (!info.isColumn()) continue;
            columns.add(info.getName());
        }
        String tableName = this.getTableName(clz);
        String sql = this.creator.getUpdateSql(tableName, pks, columns);
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        this.updateStmts.put(clz, stmt);
        return stmt;
    }

    private String getTableName(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        return table.value();
    }

    private void setParams(PreparedStatement stmt, Object[] params) throws SQLException {
        int i = 1;
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                stmt.setString(i, (String)object);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                stmt.setTimestamp(i, new Timestamp(date.getTime()));
            } else if (object instanceof Integer) {
                stmt.setInt(i, (Integer)object);
            } else if (object instanceof BigDecimal) {
                stmt.setBigDecimal(i, (BigDecimal)object);
            } else if (object instanceof Double) {
                stmt.setDouble(i, (Double)object);
            } else if (object instanceof Boolean) {
                stmt.setBoolean(i, (Boolean)object);
            } else if (object instanceof byte[]) {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])object);
                stmt.setBinaryStream(i, is);
            } else if (object == null) {
                stmt.setObject(i, null);
            } else {
                throw new UnsupportedOperationException("Unsupport type " + object);
            }
            ++i;
            ++n2;
        }
    }
}

