/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class DbmUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static String toCommaString(Object[] objects, String sep) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(objects[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public static <T> T fillData(Class<T> clz, ResultSet result) throws SQLException {
        try {
            T instance = clz.newInstance();
            Field[] fieldArray = clz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                ColumnInfo info = new ColumnInfo(field);
                if (info.isColumn()) {
                    if (info.isTimeStamp()) {
                        Date dataDate = (Date)result.getObject(field.getName());
                        DbmUtil.setVlaueToField(instance, info, new Date(dataDate.getTime()));
                    } else {
                        DbmUtil.setVlaueToField(instance, info, result.getObject(info.getName()));
                    }
                }
                ++n2;
            }
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setVlaueToField(Object obj, ColumnInfo info, Object val) {
        String setter = DbmUtil.getSetterName(info.getName());
        try {
            try {
                Class[] param = new Class[]{info.getType()};
                Method method = obj.getClass().getDeclaredMethod(setter, param);
                method.invoke(obj, val);
            }
            catch (NoSuchMethodException e) {
                info.getField().set(obj, val);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVlaueFromField(Object obj, ColumnInfo info) {
        String getter = DbmUtil.getGetterName(info.getName());
        Object rtn = null;
        try {
            try {
                Object param = null;
                Method method = obj.getClass().getDeclaredMethod(getter, param);
                rtn = method.invoke(obj, EMPTY_ARRAY);
            }
            catch (NoSuchMethodException e) {
                rtn = info.getField().get(obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rtn;
    }

    private static String getSetterName(String name) {
        String first = name.substring(0, 1);
        StringBuilder sb = new StringBuilder();
        sb.append("set").append(first.toUpperCase()).append(name.substring(1));
        return sb.toString();
    }

    private static String getGetterName(String name) {
        String first = name.substring(0, 1);
        StringBuilder sb = new StringBuilder();
        sb.append("get").append(first.toUpperCase()).append(name.substring(1));
        return sb.toString();
    }
}

