/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.annotate.Table;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public abstract class TableAccess {
    private static final Logger LOG = Logger.getLogger("global");
    private final Connection connection;

    public abstract void drop(Class<?> var1) throws SQLException;

    public abstract void create(Class<?> var1) throws SQLException;

    public TableAccess(Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                throw new IllegalArgumentException();
            }
            this.connection = connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTableName(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        String tableName = table.value();
        return tableName;
    }

    protected List<ColumnInfo> getColumnInfo(Class<?> clz) {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        Field[] fieldArray = clz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            columns.add(new ColumnInfo(field));
            ++n2;
        }
        return columns;
    }

    protected String getDbType(Class<?> clz, int opt) {
        if (clz == String.class) {
            return this.getStringType(opt);
        }
        if (clz == Date.class) {
            return this.getDateType(opt);
        }
        if (clz == Integer.class) {
            return this.getIntType(opt);
        }
        if (clz == byte[].class) {
            return this.getBinaryType(opt);
        }
        if (clz == Boolean.class) {
            return this.getBooleanType(opt);
        }
        if (clz == Double.class) {
            return this.getDoubleType(opt);
        }
        if (clz == BigDecimal.class) {
            return this.getDecimalType(opt);
        }
        throw new UnsupportedOperationException("Unsupported type" + clz);
    }

    protected abstract String getStringType(int var1);

    protected abstract String getDateType(int var1);

    protected abstract String getIntType(int var1);

    protected abstract String getBinaryType(int var1);

    protected abstract String getBooleanType(int var1);

    protected abstract String getDoubleType(int var1);

    protected abstract String getDecimalType(int var1);

    protected void executeDiretory(String sql) throws SQLException {
        LOG.info("sql= " + sql);
        this.connection.createStatement().executeUpdate(sql);
    }
}

