/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.ColumnInfo;
import estoc.dbm.TableAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class TableAccessH2
extends TableAccess {
    public TableAccessH2(Connection connection) {
        super(connection);
    }

    @Override
    public void drop(Class<?> clz) throws SQLException {
        String tableName = this.getTableName(clz);
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS ").append(tableName).toString();
        this.executeDiretory(sb.toString());
    }

    @Override
    public void create(Class<?> clz) throws SQLException {
        String tableName = this.getTableName(clz);
        List<ColumnInfo> columns = this.getColumnInfo(clz);
        String sql = this.createTableSql(tableName, columns);
        this.executeDiretory(sql);
        for (ColumnInfo info : columns) {
            if (!info.isIndex()) continue;
            sql = this.createIndexSql(tableName, info);
            this.executeDiretory(sql);
        }
    }

    private String createTableSql(String tableName, List<ColumnInfo> columns) {
        StringBuilder sb = new StringBuilder();
        sb.append(" CREATE TABLE IF NOT EXISTS ").append(tableName).append(" ( ");
        boolean next = false;
        for (ColumnInfo info : columns) {
            if (next) {
                sb.append(",");
            } else {
                next = true;
            }
            sb.append(info.getName()).append(" ");
            sb.append(this.getDbType(info.getType(), info.getTypeOpt()));
            if (info.isNotNull() || info.isPk()) {
                sb.append(" NOT NULL ");
            }
            if (info.isAutoInc()) {
                sb.append(" AUTO_INCREMENT ");
            }
            if (!info.isPk()) continue;
            sb.append(" PRIMARY KEY ");
        }
        sb.append(" ) ");
        return sb.toString();
    }

    private String createIndexSql(String tableName, ColumnInfo column) {
        StringBuilder sb = new StringBuilder();
        sb.append(" CREATE INDEX IF NOT EXISTS ").append("idx_").append(column.getName());
        sb.append(" ON ").append(tableName).append(" (").append(column.getName()).append(")");
        return sb.toString();
    }

    @Override
    protected String getBinaryType(int opt) {
        if (opt == -1) {
            return "VARBINARY";
        }
        return "BINARY(" + opt + ")";
    }

    @Override
    protected String getDateType(int opt) {
        return "TIMESTAMP";
    }

    @Override
    protected String getIntType(int opt) {
        return "INT";
    }

    @Override
    protected String getStringType(int opt) {
        if (opt == -1) {
            return "VARCHAR";
        }
        return "VARCHAR(" + opt + ")";
    }

    @Override
    protected String getBooleanType(int opt) {
        return "BOOLEAN";
    }

    @Override
    protected String getDoubleType(int opt) {
        return "DOUBLE";
    }

    @Override
    protected String getDecimalType(int opt) {
        if (opt == -1) {
            return "DECIMAL";
        }
        return "DECIMAL(" + opt + ")";
    }
}

