/*
 * Decompiled with CFR 0.152.
 */
package estoc.dbm;

import estoc.dbm.annotate.AutoInc;
import estoc.dbm.annotate.Column;
import estoc.dbm.annotate.Index;
import estoc.dbm.annotate.NotNull;
import estoc.dbm.annotate.Pk;
import estoc.dbm.annotate.TimeStamp;
import estoc.dbm.annotate.Unique;
import java.lang.reflect.Field;

class ColumnInfo {
    private final Field field;
    private Boolean isColumn;
    private Boolean isAutoInc;
    private Boolean isIndex;
    private Boolean isNotNull;
    private Boolean isPk;
    private Boolean isTimeStamp;
    private Boolean isUnique;
    private String name;
    private Class<?> type;

    public ColumnInfo(Field field) {
        this.field = field;
    }

    public boolean isColumn() {
        if (this.isColumn == null) {
            this.isColumn = this.field.getAnnotation(Column.class) != null;
        }
        return this.isColumn;
    }

    public boolean isPk() {
        if (this.isPk == null) {
            this.isPk = this.field.getAnnotation(Pk.class) != null;
        }
        return this.isPk;
    }

    public boolean isNotNull() {
        if (this.isNotNull == null) {
            this.isNotNull = this.field.getAnnotation(NotNull.class) != null;
        }
        return this.isNotNull;
    }

    public boolean isIndex() {
        if (this.isIndex == null) {
            this.isIndex = this.field.getAnnotation(Index.class) != null;
        }
        return this.isIndex;
    }

    public boolean isAutoInc() {
        if (this.isAutoInc == null) {
            this.isAutoInc = this.field.getAnnotation(AutoInc.class) != null;
        }
        return this.isAutoInc;
    }

    public boolean isTimeStamp() {
        if (this.isTimeStamp == null) {
            this.isTimeStamp = this.field.getAnnotation(TimeStamp.class) != null;
        }
        return this.isTimeStamp;
    }

    public boolean isUnique() {
        if (this.isUnique == null) {
            this.isUnique = this.field.getAnnotation(Unique.class) != null;
        }
        return this.isUnique;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.field.getName();
        }
        return this.name;
    }

    public Class<?> getType() {
        if (this.type == null) {
            this.type = this.field.getType();
        }
        return this.type;
    }

    public int getTypeOpt1() {
        Column column = this.field.getAnnotation(Column.class);
        return column.value();
    }

    public int getTypeOpt2() {
        Column column = this.field.getAnnotation(Column.class);
        return column.value2();
    }

    Field getField() {
        return this.field;
    }
}

