<?php
// vim: foldmethod=marker
/**
 *	Ethna_AMF_ActionClass.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_AMF_ActionClass.php,v 1.2 2004/12/13 15:08:38 fujimoto Exp $
 */

// {{{ Ethna_AMF_ActionClass
/**
 *	AMF(Flash Remoting)action¹ԥ饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_AMF_ActionClass
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	object	Ethna_Backend		backend֥
	 */
	var $backend;

	/**
	 *	@var	object	Ethna_Config		ꥪ֥	
	 */
	var $config;

	/**
	 *	@var	object	Ethna_I18N			i18n֥
	 */
	var $i18n;

	/**
	 *	@var	object	Ethna_ActionError	󥨥顼֥
	 */
	var $action_error;

	/**
	 *	@var	object	Ethna_ActionError	󥨥顼֥(ά)
	 */
	var $ae;

	/**
	 *	@var	object	Ethna_Session		å󥪥֥
	 */
	var $session;

	/**
	 *	@var	array	᥽å
	 */
	var $method;

	/**#@-*/

	/**
	 *	Ethna_AMF_ActionClassΥ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	$backend	backend֥
	 */
	function Ethna_AMF_ActionClass()
	{
		$c =& $GLOBALS['controller'];
		$this->backend =& $c->getBackend();
		$this->config =& $this->backend->getConfig();
		$this->i18n =& $this->backend->getI18N();

		$this->action_error =& $this->backend->getActionError();
		$this->ae =& $this->action_error;

		$this->session =& $this->backend->getSession();
	}

	/**
	 *	Credentialإå˴ŤƥåԤ
	 *
	 *	@access	private
	 *	@param	string	$user_id	CredentialإåΥ桼ID
	 *	@param	string	$password	CredentialإåΥѥ(饤ȤϤ˥åIDꤹ)
	 */
	function _authenticate($user_id, $password)
	{
		if ($this->session != null) {
			// already authenticated
			return;
		}

		$c =& $this->backend->getController();

		session_id($password);
		$this->session =& new Session($c->getAppId(), $this->backend->getTmpdir(), $this->ae);
	}
}
// }}}
?>
