<?php
// vim: foldmethod=marker
/**
 *	Ethna_Util.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Util.php,v 1.6 2004/12/23 06:03:12 fujimoto Exp $
 */

// {{{ to_array
/**
 *	Х桼ƥƥؿ: 顼ͤǿ1Ȥ֤
 *
 *	@param	mixed	$v	Ȥư
 *	@return	array	Ѵ줿
 */
function to_array($v)
{
	if (is_array($v)) {
		return $v;
	} else {
		return array($v);
	}
}
// }}}

// {{{ is_error
/**
 *	Х桼ƥƥؿ: ꤵ줿եܤ˥顼뤫ɤ֤
 *
 *	@param	string	$name	ե̾
 *	@return	bool	true:顼ͭ false:顼̵
 */
function is_error($name)
{
	$c =& Ethna_Controller::getInstance();

	$action_error =& $c->getActionError();

	return $action_error->isError($name);
}
// }}}

// {{{ Ethna_Util
/**
 *	桼ƥƥ饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Util
{
	/**
	 *	POSTΥˡåԤ
	 *
	 *	@access	public
	 *	@return	bool	true:2ܰʹߤPOST false:1ܤPOST
	 */
	function isDuplicatePost()
	{
		$c =& Ethna_Controller::getInstance();

		// use raw post data
		if (isset($_POST['uniqid'])) {
			$uniqid = $_POST['uniqid'];
		} else if (isset($_GET['uniqid'])) {
			$uniqid = $_GET['uniqid'];
		} else {
			return false;
		}

		// purge old files
		Ethna_Util::purgeTmp("uniqid_", 60*60*1);

		$filename = sprintf("%s/uniqid_%s_%s", $c->getDirectory('tmp'), $_SERVER['REMOTE_ADDR'], $uniqid);
		$st = @stat($filename);
		if ($st == false) {
			touch($filename);
			return false;
		}
		if ($st[9] + 60*60*1 < time()) {
			// too old
			return false;
		}

		return true;
	}

	/**
	 *	POSTΥˡåե饰򥯥ꥢ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function clearDuplicatePost()
	{
		$c =& Ethna_Controller::getInstance();

		// use raw post data
		if (isset($_POST['uniqid'])) {
			$uniqid = $_POST['uniqid'];
		} else {
			return 0;
		}

		$filename = sprintf("%s/uniqid_%s_%s", $c->getDirectory('tmp'), $_SERVER['REMOTE_ADDR'], $uniqid);
		if (file_exists($filename)) {
			if (unlink($filename) == false) {
				return Ethna::raiseWarning(E_APP_WRITE, $filename);
			}
		}

		return 0;
	}

	/**
	 *	᡼륢ɥ쥹ɤå
	 *
	 *	@access	public
	 *	@param	string	$mailaddress	å᡼륢ɥ쥹
	 *	@return	bool	true: ᡼륢ɥ쥹 false: ʷ
	 */
	function checkMailAddress($mailaddress)
	{
		if (preg_match('/^([a-z0-9_]|\-|\.|\+)+@(([a-z0-9_]|\-)+\.)+[a-z]{2,4}$/i', $mailaddress)) {
			return true;
		}
		return false;
	}

	/**
	 *	CSVʸʬ䤹
	 *
	 *	@access	public
	 *	@param	string	$csv		CSVʸ(1ʬ)
	 * 	@param	string	$delimiter	եɤζڤʸ
	 *	@return	mixed	(array):ʬ Ethna_Error:顼(Է³)
	 */
	function explodeCSV($csv, $delimiter = ",")
	{
		$space_list = '';
		foreach (array(" ", "\t", "\r", "\n") as $c) {
			if ($c != $delimiter) {
				$space_list .= $c;
			}
		}

		$line_end = "";
		if (preg_match("/([$space_list]+)\$/sS", $csv, $match)) {
			$line_end = $match[1];
		}
		$csv = substr($csv, 0, strlen($csv)-strlen($line_end));
		$csv .= ' ';

		$field = '';
		$retval = array();

		$index = 0;
		$csv_len = strlen($csv);
		do {
			// 1. skip leading spaces
			if (preg_match("/^([$space_list]+)/sS", substr($csv, $index), $match)) {
				$index += strlen($match[1]);
			}
			if ($index >= $csv_len) {
				break;
			}

			// 2. read field
			if ($csv{$index} == '"') {
				// 2A. handle quote delimited field
				$index++;
				while ($index < $csv_len) {
					if ($csv{$index} == '"') {
						// handle double quote
						if ($csv{$index+1} == '"') {
							$field .= $csv{$index};
							$index += 2;
						} else {
							// must be end of string
							while ($csv{$index} != $delimiter && $index < $csv_len) {
								$index++;
							}
							if ($csv{$index} == $delimiter) {
								$index++;
							}
							break;
						}
					} else {
						// normal character
						if (preg_match("/^([^\"]*)/S", substr($csv, $index), $match)) {
							$field .= $match[1];
							$index += strlen($match[1]);
						}

						if ($index == $csv_len) {
							$field = substr($field, 0, strlen($field)-1);
							$field .= $line_end;

							// request one more line
							return Ethna::raiseNotice(E_UTIL_CSV_CONTINUE);
						}
					}
				}
			} else {
				// 2B. handle non-quoted field
				if (preg_match("/^([^$delimiter]*)/S", substr($csv, $index), $match)) {
					$field .= $match[1];
					$index += strlen($match[1]);
				}

				// remove trailing spaces
				$field = preg_replace("/[$space_list]+\$/S", '', $field);
				if ($csv{$index} == $delimiter) {
					$index++;
				}
			}
			$retval[] = $field;
			$field = '';
		} while ($index < $csv_len);

		return $retval;
	}

	/**
	 *	CSV׽Ԥ
	 *
	 *	@access	public
	 *	@param	string	$csv		оݤʸ(CSVγ)
	 *	@param	bool	$escape_nl	ʸ(\r/\n)Υץե饰
	 *	@return	string	CSVפ줿ʸ
	 */
	function escapeCSV($csv, $escape_nl = false)
	{
		if (preg_match('/[,"\r\n]/', $csv)) {
			if ($escape_nl) {
				$csv = preg_replace('/\r/', "\\r", $csv);
				$csv = preg_replace('/\n/', "\\n", $csv);
			}
			$csv = preg_replace('/"/', "\"\"", $csv);
			$csv = "\"$csv\"";
		}

		return $csv;
	}

	/**
	 *	ǤHTMLפ֤
	 *
	 *	@access	public
	 *	@param	array	$target		HTMLоݤȤʤ
	 *	@return	array	פ줿
	 */
	function escapeHtml($target)
	{
		$r = array();
		Ethna_Util::_escapeHtml($target, $r);
		return $r;
	}

	/**
	 *	ǤHTMLפ֤
	 *
	 *	@access	public
	 *	@param	mixed	$vars	HTMLоݤȤʤ
	 *	@param	mixed	$retval	HTMLоݤȤʤ
	 */
	function _escapeHtml(&$vars, &$retval)
	{
		foreach (array_keys($vars) as $name) {
			if (is_array($vars[$name])) {
				$retval[$name] = array();
				Ethna_Util::_escapeHtml($vars[$name], $retval[$name]);
			} else {
				$retval[$name] = htmlspecialchars($vars[$name]);
			}
		}
	}

	/**
	 *	Google󥯥ꥹȤ֤
	 *
	 *	@access	public
	 *	@param	int		$total		
	 *	@param	int		$offset		ɽեå
	 *	@param	int		$count		ɽ
	 *	@return	array	󥯾Ǽ
	 */
	function getDirectLinkList($total, $offset, $count)
	{
		$direct_link_list = array();

		if ($total == 0) {
			return array();
		}

		// backwards
		$current = $offset - $count;
		while ($current > 0) {
			array_unshift($direct_link_list, $current);
			$current -= $count;
		}
		if ($offset != 0 && $current <= 0) {
			array_unshift($direct_link_list, 0);
		}

		// current
		$backward_count = count($direct_link_list);
		array_push($direct_link_list, $offset);

		// forwards
		$current = $offset + $count;
		for ($i = 0; $i < 10; $i++) {
			if ($current >= $total) {
				break;
			}
			array_push($direct_link_list, $current);
			$current += $count;
		}
		$forward_count = count($direct_link_list) - $backward_count - 1;

		$backward_count -= 4;
		if ($forward_count < 5) {
			$backward_count -= 5 - $forward_count;
		}
		if ($backward_count < 0) {
			$backward_count = 0;
		}

		// add index
		$n = 1;
		$r = array();
		foreach ($direct_link_list as $direct_link) {
			$v = array('offset' => $direct_link, 'index' => $n);
			$r[] = $v;
			$n++;
		}

		return array_splice($r, $backward_count, 10);
	}

	/**
	 *	Ǥǯ֤
	 *
	 *	@access	public
	 *	@param	int		$t		unix time
	 *	@return	string	(ʾnull)
	 */
	function getEra($t)
	{
		$tm = localtime($t, true);
		$year = $tm['tm_year'] + 1900;

		if ($year >= 1989) {
			return array('ʿ', $year - 1988);
		} else if ($year >= 1926) {
			return array('', $year - 1925);
		}

		return null;
	}

	/**
	 *	getimagesize()֤᡼פбĥҤ֤
	 *
	 *	@access	public
	 *	@param	int		$type	getimagesize()ؿ֤᡼
	 *	@return	string	$typeбĥ
	 */
	function getImageExtName($type)
	{
		$ext_list = array(
			1	=> 'gif',
			2	=> 'jpg',
			3	=> 'png',
			4	=> 'swf',
			5	=> 'psd',
			6	=> 'bmp',
			7	=> 'tiff',
			8	=> 'tiff',
			9	=> 'jpc',
			10	=> 'jp2',
			11	=> 'jpx',
			12	=> 'jb2',
			13	=> 'swc',
			14	=> 'iff',
			15	=> 'wbmp',
			16	=> 'xbm',
		);

		return @$ext_list[$type];
	}

	/**
	 *	ʥϥåͤ
	 *
	 *	褷ƹ®ǤϤʤΤѤ򤱤뤳
	 *
	 *	@access	public
	 *	@param	int		$length	ϥåͤĹ(64)
	 *	@return	string	ϥå
	 */
	function getRandom($length = 64)
	{
		static $srand = false;

		if ($srand == false) {
			list($usec, $sec) = explode(' ', microtime());
			mt_srand((float) $sec + ((float) $usec * 100000) + getmypid());
			$srand = true;
		}

		$value = "";
		for ($i = 0; $i < 2; $i++) {
			// for Linux
			if (file_exists('/proc/net/dev')) {
				$rx = $tx = 0;
				$fp = fopen('/proc/net/dev', 'r');
				if ($fp != null) {
					$header = true;
					while (feof($fp) === false) {
						$s = fgets($fp, 4096);
						if ($header) {
							$header = false;
							continue;
						}
						$v = preg_split('/[:\s]+/', $s);
						if (is_array($v) && count($v) > 10) {
							$rx += $v[2];
							$tx += $v[10];
						}
					}
				}
				$platform_value = $rx . $tx . mt_rand() . getmypid();
			} else {
				$platform_value = mt_rand() . getmypid();
			}
			$now = strftime('%Y%m%d %T');
			$time = gettimeofday();
			$v = $now . $time['usec'] . $platform_value . mt_rand(0, time());
			$value .= md5($v);
		}

		if ($length < 64) {
			$value = substr($value, 0, $length);
		}
		return $value;
	}

	/**
	 *	1m x n˺ƹ
	 *
	 *	@access	public
	 *	@param	array	$array	оݤ1
	 *	@param	int		$m		ǿ
	 *	@param	int		$order	$mXȸYȸ(0:X 1:Y)
	 *	@return	array	m x n˺ƹ줿
	 */
	function get2dArray($array, $m, $order)
	{
		$r = array();
		
		$n = intval(count($array) / $m);
		if ((count($array) % $m) > 0) {
			$n++;
		}
		for ($i = 0; $i < $n; $i++) {
			$elts = array();
			for ($j = 0; $j < $m; $j++) {
				if ($order == 0) {
					// ¤($m ġ̵)
					$key = $i*$m+$j;
				} else {
					// ¤(̵ ġ$m)
					$key = $i+$n*$j;
				}
				if (array_key_exists($key, $array) == false) {
					$array[$key] = null;
				}
				$elts[] = $array[$key];
			}
			$r[] = $elts;
		}

		return $r;
	}

	/**
	 *	ѥ̾Хѥɤ֤
	 *
	 *	port from File in PEAR (for BC)
	 *
	 *	@access	public
	 *	@param	string	$path
	 *	@return	bool	true:Хѥ false:Хѥ
	 */
	function isAbsolute($path)
	{
        if (preg_match("/\.\./", $path)) {
            return false;
        }

        if (DIRECTORY_SEPARATOR == '/' && (substr($path, 0, 1) == '/' OR substr($path, 0, 1) == '~')) {
            return true;
        } elseif (DIRECTORY_SEPARATOR == '\\' && preg_match('/^[a-z]:\\\/i', $path)) {
            return true;
        }

        return false;
	}

	/**
	 *	ƥݥǥ쥯ȥΥե
	 *
	 *	@access	public
	 *	@param	string	$prefix		եΥץե
	 *	@param	int		$timeout	о(á60*60*1ʤ1)
	 */
	function purgeTmp($prefix, $timeout)
	{
		$c =& Ethna_Controller::getInstance();

		$dh = opendir($c->getDirectory('tmp'));
		if ($dh) {
			while (($file = readdir($dh)) !== false) {
				if (strncmp($file, $prefix, strlen($prefix)) == 0) {
					$f = $c->getDirectory('tmp') . "/" . $file;
					$st = @stat($f);
					if ($st[9] + $timeout < time()) {
						unlink($f);
					}
				}
			}
			closedir($dh);
		}
	}

	/**
	 *	եå
	 *
	 *	@access	public
	 *	@param	string	$file		åե̾
	 *	@param	int		$mode		å⡼('r', 'rw')
	 *	@param	int		$timeout	åԤॢ(á0ʤ̵)
	 *	@return	int		åϥɥ(falseʤ饨顼)
	 */
	function lockFile($file, $mode, $timeout = 0)
	{
		$lh = @fopen($file, 'r');
		if ($lh == null) {
			return false;
		}

		$lock_mode = $mode == 'r' ? LOCK_SH : LOCK_EX;

		for ($i = 0; $i < $timeout || $timeout == 0; $i++) {
			$r = flock($lh, $lock_mode | LOCK_NB);
			if ($r == true) {
				break;
			}
			sleep(1);
		}
		if ($timeout > 0 && $i == $timeout) {
			// timed out
			return false;
		}
 
		return $lh;
	}

	/**
	 *	եΥå
	 *
	 *	@access	public
	 *	@param	int		$lh		åϥɥ
	 */
	function unlockFile($lh)
	{
		fclose($lh);
	}

	/**
	 *	Хåȥ졼եޥåȤ֤
	 *
	 *	@access	public
	 *	@param	array	$bt		debug_backtrace()ؿǼХåȥ졼
	 *	@return	string	ʸ˥եޥåȤ줿Хåȥ졼
	 */
	function formatBacktrace($bt) 
	{
		$r = "";
		$i = 0;
		foreach ($bt as $elt) {
			$r .= sprintf("[%02d] %s:%d:%s.%s\n", $i, $elt['file'], $elt['line'], isset($elt['class']) ? $elt['class'] : 'global', $elt['function']);
			$i++;

			if (isset($elt['args']) == false || is_array($elt['args']) == false) {
				continue;
			}

			// Υ
			foreach ($elt['args'] as $arg) {
				$r .= Ethna_Util::_formatBacktrace($arg);
			}
		}

		return $r;
	}

	/**
	 *	Хåȥ졼եޥåȤ֤
	 *
	 *	@access	private
	 *	@param	string	$arg	Хåȥ졼ΰ
	 *	@param	int		$level	Хåȥ졼Υͥȥ٥
	 *	@param	int		$wrap	ԥե饰
	 *	@return	string	ʸ˥եޥåȤ줿Хåȥ졼
	 */
	function _formatBacktrace($arg, $level = 0, $wrap = true)
	{
		$pad = str_repeat("  ", $level);
		if (is_array($arg)) {
			$r = sprintf("     %s[array] => (\n", $pad);
			if ($level+1 > 4) {
				$r .= sprintf("     %s  *too deep*\n", $pad);
			} else {
				foreach ($arg as $key => $elt) {
					$r .= Ethna_Util::_formatBacktrace($key, $level, false);
					$r .= " => \n";
					$r .= Ethna_Util::_formatBacktrace($elt, $level+1);
				}
			}
			$r .= sprintf("     %s)\n", $pad);
		} else if (is_object($arg)) {
			$r = sprintf("     %s[object]%s%s", $pad, get_class($arg), $wrap ? "\n" : "");
		} else {
			$r = sprintf("     %s[%s]%s%s", $pad, gettype($arg), $arg, $wrap ? "\n" : "");
		}

		return $r;
	}
}
// }}}
?>
