<?php
// vim: foldmethod=marker
/**
 *	Ethna_SOAP_GatewayGenerator.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_SOAP_GatewayGenerator.php,v 1.3 2004/12/16 17:59:36 fujimoto Exp $
 */

// {{{ Ethna_SOAP_GatewayGenerator
/**
 *	ꤵ줿ȥб륲ȥ饹ɤ륯饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna	
 */
class Ethna_SOAP_GatewayGenerator
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	object	Ethna_Controller	controller֥
	 */
	var	$controller;

	/**
	 *	@var	object	Ethna_Config		ꥪ֥
	 */
	var	$config;

	/**
	 *	@var	object	Ethna_ActionError	󥨥顼֥
	 */
	var	$action_error;

	/**
	 *	@var	object	Ethna_ActionError	󥨥顼֥(ά)
	 */
	var	$ae;

	/**
	 *	@var	string		ȥ饹
	 */
	var	$gateway;

	/**
	 *	@var	string		ȥ饹̾
	 */
	var	$name;

	/**
	 *	@var	string		ȥ饹͡ॹڡ
	 */
	var	$namespace;

	/**#@-*/

	/**
	 *	Ethna_SOAP_GatewayGenerator饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 */
	function Ethna_SOAP_GatewayGenerator()
	{
		$this->controller =& Ethna_Controller::getInstance();
		$this->config =& $this->controller->getConfig();
		$this->action_error = null;
		$this->ae =& $this->action_error;
		$this->gateway = "";
		$this->name = $this->controller->getAppId();
		$this->namespace = $this->_getNameSpace();
	}

	/**
	 *	ȥ饹ɤ
	 *
	 *	@access	public
	 *	@return	string	ȥ饹
	 */
	function generate()
	{
		$prev_type = $this->controller->getClientType();
		$this->controller->setClientType(CLIENT_TYPE_SOAP);

		$this->gateway .= $this->_getHeader();
		$this->gateway .= $this->_getEntry();
		$this->gateway .= $this->_getFooter();

		$this->controller->setClientType($prev_type);

		return $this->gateway;
	}

	/**
	 *	ȥ饹Υ饹̾
	 *
	 *	@access	public
	 *	@return	string	ȥ饹Υ饹̾
	 */
	function getClassName()
	{
		return sprintf("Ethna_SOAP_%sGateway", $this->name);
	}

	/**
	 *	ȥ饹(إåʬ)
	 *
	 *	@access	private
	 *	@return	string	ȥ饹(إåʬ)
	 */
	function _getHeader()
	{
		$header = sprintf("class Ethna_SOAP_%sGateway extends Ethna_SOAP_Gateway {\n", $this->name);

		return $header;
	}

	/**
	 *	ȥ饹(᥽åɥȥʬ)
	 *
	 *	@access	private
	 *	@return	string	ȥ饹(᥽åɥȥʬ)
	 */
	function _getEntry()
	{
		$entry = "";
		foreach ($this->controller->soap_action as $k => $v) {
			$action_form_name = $this->controller->getActionFormName($k);
			$form =& new $action_form_name($this->controller);
			$arg_list = array_keys($form->form);

			$entry .= "  function $k(";
			for ($i = 0; $i < count($arg_list); $i++) {
				if ($i > 0) {
					$entry .= ", ";
				}
				$entry .= "\$" . $arg_list[$i];
			}
			$entry .= ") {\n";

			$entry .= "    \$_SERVER['REQUEST_METHOD'] = 'post';\n";
			$entry .= "    \$_POST['action_$k'] = 'dummy';\n";
			foreach ($arg_list as $arg) {
				$entry .= "    \$_POST['$arg'] = \$$arg;\n";
			}
			
			$entry .= "    \$this->dispatch();\n";

			$entry .= "    \$app =& \$this->getApp();\n";
			$entry .= "    \$errorcode = \$this->getErrorCode();\n";
			$entry .= "    \$errormessage = \$this->getErrorMessage();\n";
			$entry .= "    \$retval = array();\n";
			foreach ($form->retval as $k => $v) {
				$entry .= "    \$retval['$k'] = \$app['$k'];\n";
			}
			$entry .= "    \$retval['errorcode'] = \$errorcode;\n";
			$entry .= "    \$retval['errormessage'] = \$errormessage;\n";

			$entry .= "    return \$retval;\n";
			$entry .= "  }\n";
		}
		return $entry;
	}

	/**
	 *	ȥ饹(եåʬ)
	 *
	 *	@access	private
	 *	@return	string	ȥ饹(եåʬ)
	 */
	function _getFooter()
	{
		$footer = "}\n";

		return $footer;
	}

	/**
	 *	͡ॹڡ
	 *
	 *	@access	private
	 *	@return	string	͡ॹڡ
	 */
	function _getNameSpace()
	{
		return sprintf("%s/%s", $this->config->get('url'), $this->name);
	}
}
// }}}
?>
