<?php
// vim: foldmethod=marker
/**
 *	Ethna_AppSQL.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_AppSQL.php,v 1.3 2006/01/06 16:03:59 fujimoto Exp $
 */

// {{{ Ethna_AppSQL
/**
 *	ץꥱSQL١饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_AppSQL
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Controller	controller֥ */
	var $controller;

	/**#@-*/

	/**
	 *	Ethna_AppSQLΥ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	&$controller	controller֥
	 */
	function Ethna_AppSQL(&$controller)
	{
		$this->controller =& $controller;
	}

	/**
	 *	Ŭڤ˥פ줿SQLʸ֤
	 *
	 *	@access	public
	 *	@param	string	$sqlfunc	SQLʸ̾
	 *	@param	array	$args		
	 *	@return	string	פ줿SQLʸ
	 */
	function get($sqlid, $args)
	{
		Ethna_AppSQL::escapeSQL($args);

		return call_user_func_array(array(&$this, $sqlid), $args);
	}

	/**
	 *	SQL򥨥פ
	 *
	 *	@access	public
	 *	@param	mixed	&$var	פ
	 *	@static
	 */
	function escapeSQL(&$var)
	{
		if (!is_array($var)) {
			if (is_null($var)) {
				$var = 'NULL';
			} else {
				$var ='\'' . addslashes($var) . '\'';
			}
			return;
		}
		foreach (array_keys($var) as $key) {
			Ethna_AppSQL::escapeSQL($var[$key]);
		}
	}

	/**
	 *	escapeSQLǥפ줿ʸunescape
	 *
	 *	@access	public
	 *	@param	mixed	&$var	פ
	 *	@static
	 */
	function unescapeSQL(&$var)
	{
		if (!is_array($var)) {
			if ($var == 'NULL') {
				return;
			}
			$var = substr($var, 1, strlen($var)-2);
			$var = stripslashes($var);
			return;
		}
		foreach (array_keys($var) as $key) {
			Ethna_AppSQL::unescapeSQL($var[$key]);
		}
	}

	/**
	 *	WHEREʸ
	 *
	 *	@access	public
	 *	@param	string	$field		оݤΥե
	 *	@param	string	$value		
	 *	@param	int		$condition	(OBJECT_CONDITION_NE,...)
	 *	@return	string	ʸ
	 *	@static
	 */
	function getCondition($field, $value, $condition = OBJECT_CONDITION_EQ)
	{
		switch ($condition) {
		case OBJECT_CONDITION_EQ:
			$op = "="; break;
		case OBJECT_CONDITION_NE:
			$op = "!="; break;
		case OBJECT_CONDITION_LIKE:
			$op = "LIKE"; break;
		case OBJECT_CONDITION_GT:
			$op = ">"; break;
		case OBJECT_CONDITION_LT:
			$op = "<"; break;
		case OBJECT_CONDITION_GE:
			$op = ">="; break;
		case OBJECT_CONDITION_LE:
			$op = "<="; break;
		}

		// default operand
		$operand = $value;

		if (is_array($value)) {
			if (count($value) > 0) {
				switch ($condition) {
				case OBJECT_CONDITION_EQ:
					$op = "IN"; break;
				case OBJECT_CONDITION_NE:
					$op = "NOT IN"; break;
				}
				$operand = sprintf("(%s)", implode(',', $value));
			} else {
				// always be false
				$op = "=";
				$operand = "NULL";
			}
		} else {
			if ($value == 'NULL') {
				switch ($condition) {
				case OBJECT_CONDITION_EQ:
					$op = "IS"; break;
				case OBJECT_CONDITION_NE:
					$op = "IS NOT"; break;
				}
			}
			if ($condition == OBJECT_CONDITION_LIKE) {
				Ethna_AppSQL::unescapeSQL($value);
				$value = '%' . str_replace('%', '\\%', $value) . '%';
				Ethna_AppSQL::escapeSQL($value);
				$operand = $value;
			}
		}
		return "$field $op $operand";
	}
}
// }}}
?>
