<?php
// vim: foldmethod=marker
/**
 *	Ethna_ViewClass.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_ViewClass.php,v 1.10 2006/06/05 15:00:18 fujimoto Exp $
 */

// {{{ Ethna_ViewClass
/**
 *	view饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_ViewClass
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Backend		backend֥ */
	var $backend;

	/**	@var	object	Ethna_Config		ꥪ֥	*/
	var $config;

	/**	@var	object	Ethna_I18N			i18n֥ */
	var $i18n;

	/**	@var	object	Ethna_ActionError	󥨥顼֥ */
	var $action_error;

	/**	@var	object	Ethna_ActionError	󥨥顼֥(ά) */
	var $ae;

	/**	@var	object	Ethna_ActionForm	ե४֥ */
	var $action_form;

	/**	@var	object	Ethna_ActionForm	ե४֥(ά) */
	var $af;

	/**	@var    array   ե४֥(helper) */
	var $helper_action_form = array();

	/**	@var	object	Ethna_Session		å󥪥֥ */
	var $session;

	/**	@var	string	̾ */
	var $forward_name;

	/**	@var	string	ƥץ졼ȥե̾ */
	var $forward_path;

	/**#@-*/

	/**
	 *	Ethna_ViewClassΥ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	$backend	backend֥
	 *	@param	string	$forward_name	ӥ塼˴ϢդƤ̾
	 *	@param	string	$forward_path	ӥ塼˴ϢդƤƥץ졼ȥե̾
	 */
	function Ethna_ViewClass(&$backend, $forward_name, $forward_path)
	{
		$c =& $backend->getController();
		$this->backend =& $backend;
		$this->config =& $this->backend->getConfig();
		$this->i18n =& $this->backend->getI18N();

		$this->action_error =& $this->backend->getActionError();
		$this->ae =& $this->action_error;

		$this->action_form =& $this->backend->getActionForm();
		$this->af =& $this->action_form;

		$this->session =& $this->backend->getSession();

		// Ethna_AppManager֥Ȥ
		$manager_list = $c->getManagerList();
		foreach ($manager_list as $k => $v) {
			$this->$k =& $backend->getManager($v);
		}

		$this->forward_name = $forward_name;
		$this->forward_path = $forward_path;

        foreach ($this->helper_action_form as $key => $value) {
            if (is_object($value)) {
                continue;
            }
            $this->helper_action_form[$key] =& $this->_getHelperActionForm($key);
        }
	}

	/**
	 *	ɽ
	 *
	 *	ƥץ졼ȤꤹͤǥƥȤ˰¸ʤΤ
	 *	ꤹ(:쥯ȥܥå)
	 *
	 *	@access	public
	 */
	function preforward()
	{
	}

	/**
	 *	̾б̤Ϥ
	 *
	 *	üʲ̤ɽä˥С饤ɤɬפ̵
	 *	(preforward()ΤߥС饤ɤɤ)
	 *
	 *	@access	public
	 */
	function forward()
	{
		$smarty =& $this->_getTemplateEngine();
		$this->_setDefault($smarty);
		$smarty->display($this->forward_path);
	}

    /**
     *  helperե४֥Ȥꤹ
     *
     *  @access public
     */
    function addActionFormHelper($action)
    {
        if (is_object($this->helper_action_form[$action])) {
            return;
        }
        $this->helper_action_form[$action] =& $this->_getHelperActionForm($action);
    }

    /**
     *  helperե४֥Ȥ
     *
     *  @access public
     */
    function clearActionFormHelper($action)
    {
        unset($this->helper_action_form[$action]);
    }

    /**
     *  ꤵ줿եܤбե̾(w/ )
     *
     *  @access public
     */
    function getFormName($name, $params)
    {
        $def = $this->_getHelperActionFormDef($name);
        $form_name = null;
        if (is_null($def) || isset($def['name']) == false) {
            $form_name = $name;
        } else {
            $form_name = $def['name'];
        }

        return $form_name;
    }

    /**
     *  ꤵ줿եܤбեॿ
     *
     *  experimental(ȤȤꤢ-٤̥饹˹ԤǤ)
     *
     *  @access public
     *  @todo   form_typeƼб/JavaScriptб...
     */
    function getFormInput($name, $params)
    {
        $def = $this->_getHelperActionFormDef($name);
        if (is_null($def)) {
            return "";
        }

        if (isset($def['form_type']) == false) {
            $def['form_type'] = FORM_TYPE_TEXT;
        }
        
        switch ($def['form_type']) {
        case FORM_TYPE_BUTTON:
            $input = $this->_getFormInput_Button($name, $def, $params);
            break;
        case FORM_TYPE_CHECKBOX:
            // T.B.D.
            break;
        case FORM_TYPE_FILE:
            $input = $this->_getFormInput_File($name, $def, $params);
            break;
        case FORM_TYPE_HIDDEN:
            $input = $this->_getFormInput_Hidden($name, $def, $params);
            break;
        case FORM_TYPE_PASSWORD:
            $input = $this->_getFormInput_Password($name, $def, $params);
            break;
        case FORM_TYPE_RADIO:
            // T.B.D.
            break;
        case FORM_TYPE_SELECT:
            // T.B.D.
            break;
        case FORM_TYPE_SUBMIT:
            $input = $this->_getFormInput_Submit($name, $def, $params);
            break;
        case FORM_TYPE_TEXTAREA:
            $input = $this->_getFormInput_Textarea($name, $def, $params);
            break;
        case FORM_TYPE_TEXT:
        default:
            $input = $this->_getFormInput_Text($name, $def, $params);
            break;
        }

        print $input;
    }

    /**
     *  ե४֥(helper)
     *
     *  @access protected
     */
    function &_getHelperActionForm($action)
    {
        $af = null;
        $ctl =& Ethna_Controller::getInstance();
        $form_name = $ctl->getActionFormName($action);
        if ($form_name == null) {
            // TODO: logging
            return null;
        }
        $af =& new $form_name($ctl);

        return $af;
    }

    /**
     *  եܤбե
     *
     *  @access protected
     */
    function _getHelperActionFormDef($name)
    {
        $def = $this->af->getDef($name);
        if (is_null($def)) {
            foreach ($this->helper_action_form as $key => $value) {
                if (is_object($value) == false) {
                    continue;
                }
                $def = $value->getDef($name);
                if (is_null($def) == false) {
                    break;
                }
            }
        }
        return $def;
    }

    /**
     *  եॿ(type="button")
     *
     *  @access protected
     */
    function _getFormInput_Button($name, $def, $params)
    {
        $r = array();
        $r['type'] = "button";
        $r['name'] = $name;

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  եॿ(type="file")
     *
     *  @access protected
     */
    function _getFormInput_File($name, $def, $params)
    {
        $r = array();
        $r['type'] = "file";
        $r['name'] = $name;
        $r['value'] = "";

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  եॿ(type="hidden")
     *
     *  @access protected
     */
    function _getFormInput_Hidden($name, $def, $params)
    {
        $r = array();
        $r['type'] = "hidden";
        $r['name'] = $name;
        $r['value'] = $this->af->get($name);

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  եॿ(type="password")
     *
     *  @access protected
     */
    function _getFormInput_Password($name, $def, $params)
    {
        $r = array();
        $r['type'] = "password";
        $r['name'] = $name;
        $r['value'] = $this->af->get($name);

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  եॿ(type="submit")
     *
     *  @access protected
     */
    function _getFormInput_Submit($name, $def, $params)
    {
        $r = array();
        $r['type'] = "submit";
        $r['name'] = $name;

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  եॿ(textarea)
     *
     *  @access protected
     */
    function _getFormInput_Textarea($name, $def, $params)
    {
        $r = array();
        $r['name'] = $name;

        return $this->_getFormInput_Html("textarea", $r, $params, $this->af->get($name));
    }

    /**
     *  եॿ(type="text")
     *
     *  @access protected
     */
    function _getFormInput_Text($name, $def, $params)
    {
        $r = array();
        $r['type'] = "text";
        $r['name'] = $name;
        $r['value'] = $this->af->get($name);
        if (isset($def['max']) && $def['max']) {
            $r['maxlength'] = $def['max'];
        }

        return $this->_getFormInput_Html("input", $r, $params);
    }

    /**
     *  HTML
     *
     *  @access protected
     */
    function _getFormInput_Html($tag, $attr, $user_attr, $element = false)
    {
        // user defs
        foreach ($user_attr as $key => $value) {
            if ($key == "type" || $key == "name" || preg_match('/^[a-z0-9]+$/i', $key) == 0) {
                continue;
            }
            $attr[$key] = $value;
        }

        $r = "<$tag";

        foreach ($attr as $key => $value) {
            $r .= sprintf(' %s="%s"', $key, htmlspecialchars($value, ENT_QUOTES));
        }

        if ($element !== false) {
            $r .= sprintf('>%s</%s>', htmlspecialchars($element, ENT_QUOTES), $tag);
        } else {
            $r .= " />";
        }

        return $r;
    }

	/**
	 *	Smarty֥Ȥ
	 *
	 *	@access	protected
	 *	@return	object	Smarty	Smarty֥
	 */
	function &_getTemplateEngine()
	{
		$c =& $this->backend->getController();
		$smarty =& $c->getTemplateEngine();

		$form_array =& $this->af->getArray();
		$app_array =& $this->af->getAppArray();
		$app_ne_array =& $this->af->getAppNEArray();
		$smarty->assign_by_ref('form', $form_array);
		$smarty->assign_by_ref('app', $app_array);
		$smarty->assign_by_ref('app_ne', $app_ne_array);
		$message_list = Ethna_Util::escapeHtml($this->ae->getMessageList());
		$smarty->assign_by_ref('errors', $message_list);
		if (isset($_SESSION)) {
			$tmp_session = Ethna_Util::escapeHtml($_SESSION);
			$smarty->assign_by_ref('session', $tmp_session);
		}
		$smarty->assign('script', basename($_SERVER['PHP_SELF']));
		$smarty->assign('request_uri', htmlspecialchars($_SERVER['REQUEST_URI'], ENT_QUOTES));

		return $smarty;
	}

	/**
	 *	ͤꤹ
	 *
	 *	@access	protected
	 *	@param	object	Smarty	Smarty֥
	 */
	function _setDefault(&$smarty)
	{
	}
}
// }}}
?>
