<?php
// vim: foldmethod=marker
/**
 *  Ethna.php
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna.php,v 1.45 2006/11/29 10:16:17 ichii386 Exp $
 */

/** Ethna depends on PEAR */
require_once 'PEAR.php';

if (!defined('PATH_SEPARATOR')) {
    if (OS_WINDOWS) {
        /** include_path separator(Windows) */
        define('PATH_SEPARATOR', ';');
    } else {
        /** include_path separator(Unix) */
        define('PATH_SEPARATOR', ':');
    }
}
if (!defined('DIRECTORY_SEPARATOR')) {
    if (OS_WINDOWS) {
        /** directory separator(Windows) */
        define('DIRECTORY_SEPARATOR', '\\');
    } else {
        /** separator(Unix) */
        define('DIRECTORY_SEPARATOR', '/');
    }
}

/** С */
define('ETHNA_VERSION', '2.3.0');

/** Ethna١ǥ쥯ȥ */
define('ETHNA_BASE', dirname(__FILE__));

require_once ETHNA_BASE . '/class/Ethna_ActionClass.php';
require_once ETHNA_BASE . '/class/Ethna_ActionError.php';
require_once ETHNA_BASE . '/class/Ethna_ActionForm.php';
require_once ETHNA_BASE . '/class/Ethna_AppManager.php';
require_once ETHNA_BASE . '/class/Ethna_AppObject.php';
require_once ETHNA_BASE . '/class/Ethna_AppSQL.php';
require_once ETHNA_BASE . '/class/Ethna_AppSearchObject.php';
require_once ETHNA_BASE . '/class/Ethna_Backend.php';
require_once ETHNA_BASE . '/class/Ethna_CacheManager.php';
require_once ETHNA_BASE . '/class/Ethna_Config.php';
require_once ETHNA_BASE . '/class/Ethna_Controller.php';
require_once ETHNA_BASE . '/class/Ethna_ClassFactory.php';
require_once ETHNA_BASE . '/class/Ethna_DB.php';
require_once ETHNA_BASE . '/class/Ethna_Error.php';
require_once ETHNA_BASE . '/class/Ethna_Filter.php';
require_once ETHNA_BASE . '/class/Ethna_Handle.php';
require_once ETHNA_BASE . '/class/Ethna_I18N.php';
require_once ETHNA_BASE . '/class/Ethna_Logger.php';
require_once ETHNA_BASE . '/class/Ethna_MailSender.php';
require_once ETHNA_BASE . '/class/Ethna_Session.php';
require_once ETHNA_BASE . '/class/Ethna_Generator.php';
require_once ETHNA_BASE . '/class/Ethna_UrlHandler.php';
require_once ETHNA_BASE . '/class/Ethna_Util.php';
require_once ETHNA_BASE . '/class/Ethna_ViewClass.php';
require_once ETHNA_BASE . '/class/View/Ethna_View_List.php';
require_once ETHNA_BASE . '/class/Ethna_Plugin.php';
require_once ETHNA_BASE . '/class/Ethna_Renderer.php';
require_once ETHNA_BASE . '/class/CLI/Ethna_CLI_ActionClass.php';

if (extension_loaded('soap')) {
    require_once ETHNA_BASE . '/class/SOAP/Ethna_SOAP_ActionForm.php';
    require_once ETHNA_BASE . '/class/SOAP/Ethna_SOAP_Gateway.php';
    require_once ETHNA_BASE . '/class/SOAP/Ethna_SOAP_GatewayGenerator.php';
    require_once ETHNA_BASE . '/class/SOAP/Ethna_SOAP_Util.php';
    require_once ETHNA_BASE . '/class/SOAP/Ethna_SOAP_WsdlGenerator.php';
}

/** 饤ȸ: Ѹ */
define('LANG_EN', 'en');

/** 饤ȸ: ܸ */
define('LANG_JA', 'ja');


/** ȥ: WWW */
define('GATEWAY_WWW', 1);

/** ȥ: CLI */
define('GATEWAY_CLI', 2);

/** ȥ: XMLRPC */
define('GATEWAY_XMLRPC', 3);

/** ȥ: SOAP */
define('GATEWAY_SOAP', 4);


/** DB: R/W */
define('DB_TYPE_RW', 1);

/** DB: R/O */
define('DB_TYPE_RO', 2);

/** DB: Misc  */
define('DB_TYPE_MISC', 3);


/** Ƿ:  */
define('VAR_TYPE_INT', 1);

/** Ƿ: ư */
define('VAR_TYPE_FLOAT', 2);

/** Ƿ: ʸ */
define('VAR_TYPE_STRING', 3);

/** Ƿ:  */
define('VAR_TYPE_DATETIME', 4);

/** Ƿ:  */
define('VAR_TYPE_BOOLEAN', 5);

/** Ƿ: ե */
define('VAR_TYPE_FILE', 6);


/** ե෿: text */
define('FORM_TYPE_TEXT', 1);

/** ե෿: password */
define('FORM_TYPE_PASSWORD', 2);

/** ե෿: textarea */
define('FORM_TYPE_TEXTAREA', 3);

/** ե෿: select */
define('FORM_TYPE_SELECT', 4);

/** ե෿: radio */
define('FORM_TYPE_RADIO', 5);

/** ե෿: checkbox */
define('FORM_TYPE_CHECKBOX', 6);

/** ե෿: button */
define('FORM_TYPE_SUBMIT', 7);

/** ե෿: file */
define('FORM_TYPE_FILE', 8);

/** ե෿: button */
define('FORM_TYPE_BUTTON', 9);

/** ե෿: hidden */
define('FORM_TYPE_HIDDEN', 10);


/** 顼: ̥顼 */
define('E_GENERAL', 1);

/** 顼: DB³顼 */
define('E_DB_CONNECT', 2);

/** 顼: DBʤ */
define('E_DB_NODSN', 3);

/** 顼: DBꥨ顼 */
define('E_DB_QUERY', 4);

/** 顼: DBˡ顼 */
define('E_DB_DUPENT', 5);

/** 顼: DB̥顼 */
define('E_DB_INVALIDTYPE', 6);

/** 顼: å󥨥顼(ͭڤ) */
define('E_SESSION_EXPIRE', 16);

/** 顼: å󥨥顼(IPɥ쥹å顼) */
define('E_SESSION_IPCHECK', 17);

/** 顼: ̤顼 */
define('E_APP_UNDEFINED_ACTION', 32);

/** 顼: 󥯥饹̤顼 */
define('E_APP_UNDEFINED_ACTIONCLASS', 33);

/** 顼: ץꥱ󥪥֥IDʣ顼 */
define('E_APP_DUPENT', 34);

/** 顼: ץꥱ᥽åɤ¸ߤʤ */
define('E_APP_NOMETHOD', 35);

/** 顼: å顼 */
define('E_APP_LOCK', 36);

/** 顼: ɤ߹ߥ顼 */
define('E_APP_READ', 37);

/** 顼: 񤭹ߥ顼 */
define('E_APP_WRITE', 38);

/** 顼: CSVʬ䥨顼(Է³) */
define('E_UTIL_CSV_CONTINUE', 64);

/** 顼: եͷ顼(顼) */
define('E_FORM_WRONGTYPE_SCALAR', 128);

/** 顼: եͷ顼(˥顼) */
define('E_FORM_WRONGTYPE_ARRAY', 129);

/** 顼: եͷ顼() */
define('E_FORM_WRONGTYPE_INT', 130);

/** 顼: եͷ顼(ư) */
define('E_FORM_WRONGTYPE_FLOAT', 131);

/** 顼: եͷ顼(շ) */
define('E_FORM_WRONGTYPE_DATETIME', 132);

/** 顼: եͷ顼(BOOL) */
define('E_FORM_WRONGTYPE_BOOLEAN', 133);

/** 顼: եͷ顼(FILE) */
define('E_FORM_WRONGTYPE_FILE', 134);

/** 顼: եɬܥ顼 */
define('E_FORM_REQUIRED', 135);

/** 顼: եͺǾͥ顼() */
define('E_FORM_MIN_INT', 136);

/** 顼: եͺǾͥ顼(ư) */
define('E_FORM_MIN_FLOAT', 137);

/** 顼: եͺǾͥ顼(ʸ) */
define('E_FORM_MIN_STRING', 138);

/** 顼: եͺǾͥ顼(շ) */
define('E_FORM_MIN_DATETIME', 139);

/** 顼: եͺǾͥ顼(ե뷿) */
define('E_FORM_MIN_FILE', 140);

/** 顼: եͺͥ顼() */
define('E_FORM_MAX_INT', 141);

/** 顼: եͺͥ顼(ư) */
define('E_FORM_MAX_FLOAT', 142);

/** 顼: եͺͥ顼(ʸ) */
define('E_FORM_MAX_STRING', 143);

/** 顼: եͺͥ顼(շ) */
define('E_FORM_MAX_DATETIME', 144);

/** 顼: եͺͥ顼(ե뷿) */
define('E_FORM_MAX_FILE', 145);

/** 顼: եʸ(ɽ)顼 */
define('E_FORM_REGEXP', 146);

/** 顼: եͿ(å)顼 */
define('E_FORM_INVALIDVALUE', 147);

/** 顼: եʸ(å)顼 */
define('E_FORM_INVALIDCHAR', 148);

/** 顼: ǧѥȥϥ顼 */
define('E_FORM_CONFIRM', 149);

/** 顼: å奿 */
define('E_CACHE_INVALID_TYPE', 192);

/** 顼: åͤʤ */
define('E_CACHE_NO_VALUE', 193);

/** 顼: åͭ */
define('E_CACHE_EXPIRED', 194);

/** 顼: å奨顼(¾) */
define('E_CACHE_GENERAL', 195);

/** 顼: ץ饰󤬸Ĥʤ */
define('E_PLUGIN_NOTFOUND', 196);

/** 顼: ץ饰󥨥顼(¾) */
define('E_PLUGIN_GENERAL', 197);

if (defined('E_STRICT') == false) {
    /** PHP 5Ȥθߴݻ */
    define('E_STRICT', 0);
}

/** EthnaХѿ: 顼Хåؿ */
$GLOBALS['_Ethna_error_callback_list'] = array();

/** EthnaХѿ: 顼å */
$GLOBALS['_Ethna_error_message_list'] = array();


// {{{ Ethna
/**
 *  Ethnaե졼饹
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna extends PEAR
{
    /**#@+
     *  @access private
     */

    /**#@-*/

    /**
     *  Ethna_Error֥Ȥ(顼٥:E_USER_ERROR)
     *
     *  @access public
     *  @param  string  $message            顼å
     *  @param  int     $code               顼
     *  @static
     */
    function &raiseError($message, $code = E_GENERAL)
    {
        $userinfo = null;
        if (func_num_args() > 2) {
            $userinfo = array_slice(func_get_args(), 2);
            if (count($userinfo) == 1 && is_array($userinfo[0])) {
                $userinfo = $userinfo[0];
            }
        }
        return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_ERROR, $userinfo, 'Ethna_Error');
    }

    /**
     *  Ethna_Error֥Ȥ(顼٥:E_USER_WARNING)
     *
     *  @access public
     *  @param  string  $message            顼å
     *  @param  int     $code               顼
     *  @static
     */
    function &raiseWarning($message, $code = E_GENERAL)
    {
        $userinfo = null;
        if (func_num_args() > 2) {
            $userinfo = array_slice(func_get_args(), 2);
            if (count($userinfo) == 1 && is_array($userinfo[0])) {
                $userinfo = $userinfo[0];
            }
        }
        return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_WARNING, $userinfo, 'Ethna_Error');
    }

    /**
     *  Ethna_Error֥Ȥ(顼٥:E_USER_NOTICE)
     *
     *  @access public
     *  @param  string  $message            顼å
     *  @param  int     $code               顼
     *  @static
     */
    function &raiseNotice($message, $code = E_GENERAL)
    {
        $userinfo = null;
        if (func_num_args() > 2) {
            $userinfo = array_slice(func_get_args(), 2);
            if (count($userinfo) == 1 && is_array($userinfo[0])) {
                $userinfo = $userinfo[0];
            }
        }
        return PEAR::raiseError($message, $code, PEAR_ERROR_RETURN, E_USER_NOTICE, $userinfo, 'Ethna_Error');
    }

    /**
     *  顼ȯ(ե졼ȤƤ)Хåؿꤹ
     *
     *  @access public
     *  @param  mixed   string:Хåؿ̾ array:Хå饹(̾|֥)+᥽å̾
     *  @static
     */
    function setErrorCallback($callback)
    {
        $GLOBALS['_Ethna_error_callback_list'][] = $callback;
    }

    /**
     *  顼ȯ(ե졼ȤƤ)Хåؿ򥯥ꥢ
     *
     *  @access public
     *  @static
     */
    function clearErrorCallback()
    {
        $GLOBALS['_Ethna_error_callback_list'] = array();
    }

    /**
     *  顼ȯνԤ(Хåؿ/᥽åɤƤӽФ)
     *  
     *  @access public
     *  @param  object  Ethna_Error     Ethna_Error֥
     *  @static
     */
    function handleError(&$error)
    {
        for ($i = 0; $i < count($GLOBALS['_Ethna_error_callback_list']); $i++) {
            $callback =& $GLOBALS['_Ethna_error_callback_list'][$i];
            if (is_array($callback) == false) {
                call_user_func($callback, $error);
            } else if (is_object($callback[0])) {
                $object =& $callback[0];
                $method = $callback[1];

                // perform some more checks?
                $object->$method($error);
            } else {
                call_user_func($callback, $error);
            }
        }
    }
}
// }}}
?>
