<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin_Validator_Required.php
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Validator_Required.php,v 1.2 2006/07/19 05:22:39 fujimoto Exp $
 */

// {{{ Ethna_Plugin_Validator_Required
/**
 *  ɬܥեθڥץ饰
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Validator_Required extends Ethna_Plugin_Validator
{
    /** @var    bool    뤫ե饰 */
    var $accept_array = true;

    /**
     *  եͤϤƤ뤫򸡾ڤ
     *
     *  ξϡϤ٤ key Υꥹȡ
     *  뤤 key οǤޤ
     *
     *  @access public
     *  @param  string  $name       ե̾
     *  @param  mixed   $var        ե
     *  @param  array   $params     ץ饰Υѥ᡼
     */
    function &validate($name, $var, $params)
    {
        $true = true;
        if (isset($params['required']) && $params['required'] == false) {
            return $true;
        }
        $form_def = $this->getFormDef($name);

        // 򷿤Υեफɤ
        switch ($form_def['form_type']) {
        case FORM_TYPE_SELECT:
        case FORM_TYPE_RADIO:
        case FORM_TYPE_CHECKBOX:
        case FORM_TYPE_FILE:
            $choice = true;
            break;
        default:
            $choice = false;
        }

        // 顼ξ
        if (is_array($form_def['type']) == false) {
            if ($this->isEmpty($var, $this->getFormType($name))) {
                if (isset($params['error'])) {
                    $msg = $params['error'];
                } else if ($choice) {
                    $msg = '{form}򤵤Ƥޤ';
                } else {
                    $msg = '{form}ϤƤޤ';
                }
                return Ethna::raiseNotice($msg, E_FORM_REQUIRED);
            } else {
                return $true;
            }
        }
                
        // ξ
        $valid_keys = array();
        if ($var != null) {
            foreach (array_keys($var) as $key) {
                if ($this->isEmpty($var[$key], $form_def['type']) == false) {
                    $valid_keys[] = $key;
                }
            }
        }

        // required_key Υå
        if (isset($params['key'])) {
            $invalid_keys = array_diff(to_array($params['key']), $valid_keys);
            if (count($invalid_keys) > 0) {
                if (isset($params['error'])) {
                    $msg = $params['error'];
                } else if ($choice) {
                    $msg = '{form}ɬפʹܤ򤵤Ƥޤ';
                } else {
                    $msg = '{form}ɬפʹܤϤƤޤ';
                }
                return Ethna::raiseNotice($msg, E_FORM_REQUIRED);
            }
        }

        // required_num Υå
        if (isset($params['num'])) {
            if (count($valid_keys) < intval($params['num'])) {
                if (isset($params['error'])) {
                    $msg = $params['error'];
                } else if ($choice) {
                    $msg = '{form}ɬפʿޤ򤵤Ƥޤ';
                } else {
                    $msg = '{form}ɬפʿޤϤƤޤ';
                }
                return Ethna::raiseNotice($msg, E_FORM_REQUIRED);
            }
        }

        // Ȥ˻꤬ʤȤ: եͿ줿
        if (isset($params['key']) == false && isset($params['num']) == false) {
            if (count($valid_keys) == 0 || count($valid_keys) != count($var)) {
                if (isset($params['error'])) {
                    $msg = $params['error'];
                } else if ($choice) {
                    $msg = '{form}򤵤Ƥޤ';
                } else {
                    $msg = '{form}ϤƤޤ';
                }
                return Ethna::raiseNotice($msg, E_FORM_REQUIRED);
            }
        }

        return $true;
    }

}
// }}}
?>
