<?php
/**
 *  Ethna_Plugin_Validator_Max_Test.php
 */

/**
 *  Ethna_Plugin_Validator_Max饹Υƥȥ
 *
 *  @access public
 */
class Ethna_Plugin_Validator_Max_Test extends Ethna_UnitTestBase
{
    function testCheckValidatorMax()
    {
        $ctl =& Ethna_Controller::getInstance();
        $plugin =& $ctl->getPlugin();
        $vld = $plugin->getPlugin('Validator', 'Max');


        $form_int = array(
                          'type'          => VAR_TYPE_INT,
                          'required'      => true,
                          'max'           => '10',
                          'error'         => '{form}ˤ10ʲο()ϤƲ'
                          );
        $vld->af->setDef('namae_int', $form_int);

        $pear_error = $vld->validate('namae_int', 9, $form_int);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_int', 10, $form_int);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_int', '', $form_int);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_int', 9.5, $form_int);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        // maxĶ
        $pear_error = $vld->validate('namae_int', 11, $form_int);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_INT,$pear_error->getCode());
        $this->assertEqual($form_int['error'], $pear_error->getMessage());



        $form_float = array(
                            'type'          => VAR_TYPE_FLOAT,
                            'required'      => true,
                            'max'           => '10.000000',
                            'error'         => '{form}ˤ10.000000ʲο()ϤƲ'
                            );
        $vld->af->setDef('namae_float', $form_float);

        $pear_error = $vld->validate('namae_float', 10, $form_float);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_float', '', $form_float);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        // maxĶ
        $pear_error = $vld->validate('namae_float', 10.11, $form_float);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_FLOAT, $pear_error->getCode());
        $this->assertEqual($form_float['error'], $pear_error->getMessage());

        // maxĶ
        $pear_error = $vld->validate('namae_float', 11, $form_float);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_FLOAT, $pear_error->getCode());
        $this->assertEqual($form_float['error'], $pear_error->getMessage());



        $form_string = array(
                             'type'          => VAR_TYPE_STRING,
                             'required'      => true,
                             'max'           => '2',
                             'error'         => '{form}2ʸʲ(Ⱦ1ʸʲ)ϤƲ'
                             );
        $vld->af->setDef('namae_string', $form_string);

        $pear_error = $vld->validate('namae_string', '', $form_string);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_string', 'as', $form_string);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        // maxĶʸĹ
        $pear_error = $vld->validate('namae_string', 'ddd', $form_string);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_STRING, $pear_error->getCode());
        $this->assertEqual($form_string['error'], $pear_error->getMessage());

        // maxĶʸĹ
        $pear_error = $vld->validate('namae_string', 118888, $form_string);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_STRING, $pear_error->getCode());
        $this->assertEqual($form_string['error'], $pear_error->getMessage());



        $form_datetime = array(
                               'type'          => VAR_TYPE_DATETIME,
                               'required'      => true,
                               'max'           => '-1 day',
                               'error'         => '{form}ˤ-1 dayդϤƲ'
                               );
        $vld->af->setDef('namae_datetime', $form_datetime);

        $pear_error = $vld->validate('namae_datetime', '-2 day', $form_datetime);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_datetime', '-1 day', $form_datetime);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        $pear_error = $vld->validate('namae_datetime', '', $form_datetime);
        $this->assertFalse(is_a($pear_error, 'PEAR_Error'));

        // maxĶ
        $pear_error = $vld->validate('namae_datetime', '+3 day', $form_datetime);
        $this->assertTrue(is_a($pear_error, 'PEAR_Error'));
        $this->assertEqual(E_FORM_MAX_DATETIME, $pear_error->getCode());
        $this->assertEqual($form_datetime['error'], $pear_error->getMessage());


    }
}
?>
