<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin_Csrf.php
 *
 *  @author     Keita Arai <cocoiti@comio.info>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Csrf.php 390 2006-11-06 15:26:27Z cocoitiban $
 */

// {{{ Ethna_Plugin_Csrf
/**
 *  CSRFк쥯饹
 *
 *  CSRFкȡѤк뤿Υ
 *
 *  @author     Keita Arai <cocoiti@comio.info>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Csrf
{
    /**#@+
     *  @access private
     */

    var $controller;

    /** @var    object  Ethna_Controller    controller֥($controllerξά) */
    var $ctl;

    /** @var    object  Ethna_Config        ꥪ֥ */
    var $config;

    /** @var    object  Ethna_Logger        ֥ */
    var $logger;
    
    /** @var    string  ͭȡ̾ */
    var $token_name = 'ethna_csrf';
    
    /**#@-*/


    /**
     *  Ethna_Plugin_CsrfΥ󥹥ȥ饯
     *
     *  @access public
     *  @param  object  Ethna_Controller    &$controller    ȥ饪֥
     */
    function Ethna_Plugin_Csrf(&$controller)
    {
        // ֥Ȥ
        $this->controller =& $controller;
        $this->ctl =& $this->controller;

        $this->config =& $controller->getConfig();
        $this->logger =& $this->controller->getLogger();
    }
    
    /**
     *  ȡViewȥե˥åȤ
     *
     *  @access public
     *  @return string  ȡKey
     */
    function set()
    {

    }

    /**
     *  ȡID
     *
     *  @access public
     *  @return string ȡID֤
     */
    function get()
    {

    }

    /**
     *  ȡID
     *
     *  @access public
     *  @return string ȡID֤
     */
    function remove()
    {

    }

    /**
     *  ȡ̾
     *
     *  @access public
     *  @return string ȡ֤̾
     */
    function getName()
    {
        return $this->token_name;
    }

    /**
     *  ȡID򸡾ڤ
     *
     *  @access public
     *  @return mixed  ξtrue, ξfalse
     */
    function isValid()
    {
        $token = $this->_get_token();

        $local_token = $this->get();

        if (is_null($local_token)) {
            return false;
        }

        if ($token === $local_token) {
            return true;
        }

        return false;
    }

    /**
     *  
     *
     *  @access public
     *  @return string  keyname
     */
    function _generateKey()
    {
        return Ethna_Util::getRandom(32);
    }

    /**
     *  ꥯȤȡIDȥꥯIDȴФ
     *
     *  @access public
     *  @return mixed  ξϥȡ̾, ξfalse
     */
    function _get_token()
    {
        $token_name = $this->getName();
        if (strcasecmp($_SERVER['REQUEST_METHOD'], 'post') === 0) {
            return isset($_POST[$token_name]) ? $_POST[$token_name] : null;
        } else {
            return isset($_GET[$token_name]) ? $_GET[$token_name] : null;
        }
    }
}
// }}}
?>
