<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin_Validator_Min.php
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Validator_Min.php 416 2006-11-17 08:41:54Z ichii386 $
 */

// {{{ Ethna_Plugin_Validator_Min
/**
 *  Ǿͥåץ饰
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Validator_Min extends Ethna_Plugin_Validator
{
    /** @var    bool    뤫ե饰 */
    var $accept_array = false;

    /**
     *  ǾͤΥåԤ
     *
     *  @access public
     *  @param  string  $name       ե̾
     *  @param  mixed   $var        ե
     *  @param  array   $params     ץ饰Υѥ᡼
     */
    function &validate($name, $var, $params)
    {
        $true = true;
        $type = $this->getFormType($name);
        if (isset($params['min']) == false || $this->isEmpty($var, $type)) {
            return $true;
        }

        switch ($type) {
            case VAR_TYPE_INT:
                if ($var < $params['min']) {
                    if (isset($params['error'])) {
                        $msg = $params['error'];
                    } else {
                        $msg = "{form}ˤ%dʾο()ϤƲ";
                    }
                    return Ethna::raiseNotice($msg, E_FORM_MIN_INT, array($params['min']));
                }
                break;

            case VAR_TYPE_FLOAT:
                if ($var < $params['min']) {
                    if (isset($params['error'])) {
                        $msg = $params['error'];
                    } else {
                        $msg = "{form}ˤ%fʾο()ϤƲ";
                    }
                    return Ethna::raiseNotice($msg, E_FORM_MIN_FLOAT, array($params['min']));
                }
                break;

            case VAR_TYPE_DATETIME:
                $t_min = strtotime($params['min']);
                $t_var = strtotime($var);
                if ($t_var < $t_min) {
                    if (isset($params['error'])) {
                        $msg = $params['error'];
                    } else {
                        $msg = "{form}ˤ%sʹߤդϤƲ";
                    }
                    return Ethna::raiseNotice($msg, E_FORM_MIN_DATETIME, array($params['min']));
                }
                break;

            case VAR_TYPE_FILE:
                $st = stat($var['tmp_name']);
                if ($st[7] < $params['min'] * 1024) {
                    if (isset($params['error'])) {
                        $msg = $params['error'];
                    } else {
                        $msg = "{form}ˤ%dKBʾΥեꤷƲ";
                    }
                    return Ethna::raiseNotice($msg, E_FORM_MIN_FILE, array($params['min']));
                }
                break;

            case VAR_TYPE_STRING:
                if (strlen($var) < $params['min']) {
                    if (isset($params['error'])) {
                        $msg = $params['error'];
                    } else {
                        $msg = "{form}%dʸʾ(Ⱦ%dʸʾ)ϤƲ";
                    }
                    return Ethna::raiseNotice($msg, E_FORM_MIN_STRING,
                            array(intval($params['min']/2), $params['min']));
                }
                break;
        }

        return $true;
    }
}
// }}}
?>
