/*
 * Decompiled with CFR 0.152.
 */
package jp.uclab.sticky;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jp.uclab.sticky.CloseIcon;
import jp.uclab.sticky.DragWindowListener;
import jp.uclab.sticky.EVNote;

class Sticky
extends JPanel {
    private static final long serialVersionUID = -1647903358493541762L;
    String iniFile = "Sticky.ini";
    JFrame frame;
    JLabel label;
    JLabel titleLabel;
    EVNote evn;
    String title;
    String content;
    boolean moved = false;
    Color frameColor = Color.ORANGE;
    Color bodyColor;
    Color borderColor = new Color(100, 100, 100);
    Color titleFontColor;
    Color bodyFontColor;
    int titleFontSize;
    int bodyFontSize;
    Font titleFont;
    Font bodyFont;
    private static final int W = 4;
    private JLabel left;
    private JLabel right;
    private JLabel top;
    private JLabel bottom;
    private JLabel topleft;
    private JLabel topright;
    private JLabel bottomleft;
    private JLabel bottomright;
    private JPanel resizePanel = new JPanel(new BorderLayout()){
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setPaint(Sticky.this.frameColor);
            g2.fillRect(0, 0, w, h);
            g2.setPaint(Sticky.this.borderColor);
            g2.drawRect(0, 0, w - 1, h - 1);
            g2.drawLine(0, 2, 2, 0);
            g2.drawLine(w - 3, 0, w - 1, 2);
            g2.clearRect(0, 0, 2, 1);
            g2.clearRect(0, 0, 1, 2);
            g2.clearRect(w - 2, 0, 2, 1);
            g2.clearRect(w - 1, 0, 1, 2);
            g2.dispose();
        }
    };
    private JPanel contentPanel = new JPanel(new BorderLayout());

    public Sticky(EVNote evn) {
        super(new BorderLayout());
        this.evn = evn;
        this.title = evn.title;
        this.content = evn.content;
        this.initProperties();
        this.label = new JLabel();
        this.label = new JLabel();
        this.label.setFont(this.bodyFont);
        this.label.setOpaque(true);
        this.label.setBackground(this.bodyColor);
        this.label.setForeground(this.bodyFontColor);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleFont);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(this.frameColor);
        this.titleLabel.setForeground(this.titleFontColor);
        this.add(this.label);
        this.setLabel();
    }

    public void initProperties() {
        try {
            FileInputStream in = new FileInputStream(new File(this.iniFile));
            Properties prop = new Properties();
            prop.load(in);
            this.frameColor = this.getColor(prop.getProperty("FRAME_COLOR", "#FFD700"));
            this.bodyColor = this.getColor(prop.getProperty("BODY_COLOR", "#FFFFE0"));
            this.titleFontColor = this.getColor(prop.getProperty("TITLE_FONT_COLOR", "#040404"));
            this.bodyFontColor = this.getColor(prop.getProperty("BODY_FONT_COLOR", "#040404"));
            this.titleFontSize = Integer.parseInt(prop.getProperty("TITLE_FONT_SIZE", "12"));
            this.bodyFontSize = Integer.parseInt(prop.getProperty("BODY_FONT_SIZE", "12"));
            this.titleFont = new Font(prop.getProperty("TITLE_FONT", "\u30e1\u30a4\u30ea\u30aa"), 0, this.titleFontSize);
            this.bodyFont = new Font(prop.getProperty("BODY_FONT", "\u30e1\u30a4\u30ea\u30aa"), 0, this.bodyFontSize);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JFrame makeFrame() {
        this.frame = new JFrame(){
            private static final long serialVersionUID = -342598390171086471L;

            @Override
            public Container getContentPane() {
                return Sticky.this.contentPanel;
            }
        };
        ImageIcon icon = new ImageIcon("icon.png");
        this.frame.setIconImage(icon.getImage());
        this.frame.setUndecorated(true);
        this.frame.setBackground(new Color(255, 255, 255, 0));
        JButton button = new JButton(new CloseIcon());
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(true);
        button.setBackground(this.frameColor);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sticky.this.frame.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(Sticky.this.frame, 201));
            }
        });
        JPanel title = new JPanel(new BorderLayout());
        MyDragWindowListener dwl = new MyDragWindowListener();
        title.addMouseListener(dwl);
        title.addMouseMotionListener(dwl);
        title.setOpaque(false);
        title.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        title.add(this.titleLabel);
        title.add((Component)button, "East");
        ResizeWindowListener rwl = new ResizeWindowListener(this.frame);
        this.left = new JLabel();
        this.right = new JLabel();
        this.top = new JLabel();
        this.bottom = new JLabel();
        this.topleft = new JLabel();
        this.topright = new JLabel();
        this.bottomleft = new JLabel();
        this.bottomright = new JLabel();
        for (JLabel l : Arrays.asList(this.left, this.right, this.top, this.bottom, this.topleft, this.topright, this.bottomleft, this.bottomright)) {
            l.addMouseListener(rwl);
            l.addMouseMotionListener(rwl);
        }
        Dimension d = new Dimension(4, 0);
        this.left.setPreferredSize(d);
        this.left.setMinimumSize(d);
        this.right.setPreferredSize(d);
        this.right.setMinimumSize(d);
        d = new Dimension(0, 4);
        this.top.setPreferredSize(d);
        this.top.setMinimumSize(d);
        this.bottom.setPreferredSize(d);
        this.bottom.setMinimumSize(d);
        d = new Dimension(4, 4);
        this.topleft.setPreferredSize(d);
        this.topleft.setMinimumSize(d);
        this.topright.setPreferredSize(d);
        this.topright.setMinimumSize(d);
        this.bottomleft.setPreferredSize(d);
        this.bottomleft.setMinimumSize(d);
        this.bottomright.setPreferredSize(d);
        this.bottomright.setMinimumSize(d);
        this.left.setCursor(Cursor.getPredefinedCursor(10));
        this.right.setCursor(Cursor.getPredefinedCursor(11));
        this.top.setCursor(Cursor.getPredefinedCursor(8));
        this.bottom.setCursor(Cursor.getPredefinedCursor(9));
        this.topleft.setCursor(Cursor.getPredefinedCursor(6));
        this.topright.setCursor(Cursor.getPredefinedCursor(7));
        this.bottomleft.setCursor(Cursor.getPredefinedCursor(4));
        this.bottomright.setCursor(Cursor.getPredefinedCursor(5));
        JPanel titlePanel = new JPanel(new BorderLayout(0, 0));
        titlePanel.add((Component)this.top, "North");
        titlePanel.add((Component)title, "Center");
        JPanel northPanel = new JPanel(new BorderLayout(0, 0));
        northPanel.add((Component)this.topleft, "West");
        northPanel.add((Component)titlePanel, "Center");
        northPanel.add((Component)this.topright, "East");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.bottomleft, "West");
        southPanel.add((Component)this.bottom, "Center");
        southPanel.add((Component)this.bottomright, "East");
        this.resizePanel.add((Component)this.left, "West");
        this.resizePanel.add((Component)this.right, "East");
        this.resizePanel.add((Component)northPanel, "North");
        this.resizePanel.add((Component)southPanel, "South");
        this.resizePanel.add((Component)this.contentPanel, "Center");
        titlePanel.setOpaque(false);
        northPanel.setOpaque(false);
        southPanel.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.resizePanel.setOpaque(false);
        this.frame.setContentPane(this.resizePanel);
        return this.frame;
    }

    public void setEVNote(EVNote evn) {
        if (!this.evn.content.equals(evn.content)) {
            this.evn = evn;
            this.title = evn.title;
            this.content = evn.content;
            this.setLabel();
            this.frame.pack();
        }
    }

    public void setLabel() {
        this.titleLabel.setText(this.title);
        this.label.setText(this.content);
    }

    public static Sticky createSticky(EVNote evn) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Sticky p = new Sticky(evn);
        JFrame frame = p.makeFrame();
        frame.getContentPane().add(p);
        frame.setMinimumSize(new Dimension(100, 50));
        frame.pack();
        frame.setVisible(true);
        return p;
    }

    public Color getColor(String color) {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        int c = Integer.parseInt(color, 16);
        return new Color((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF);
    }

    class MyDragWindowListener
    extends DragWindowListener {
        MyDragWindowListener() {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            super.mouseDragged(me);
            if (!Sticky.this.moved) {
                Sticky.this.moved = true;
            }
        }
    }

    class ResizeWindowListener
    extends MouseAdapter {
        private Rectangle startSide = null;
        private final JFrame frame;

        public ResizeWindowListener(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startSide = this.frame.getBounds();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startSide == null) {
                return;
            }
            Component c = e.getComponent();
            if (c == Sticky.this.topleft) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == Sticky.this.top) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
            } else if (c == Sticky.this.topright) {
                this.startSide.y += e.getY();
                this.startSide.height -= e.getY();
                this.startSide.width += e.getX();
            } else if (c == Sticky.this.left) {
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == Sticky.this.right) {
                this.startSide.width += e.getX();
            } else if (c == Sticky.this.bottomleft) {
                this.startSide.height += e.getY();
                this.startSide.x += e.getX();
                this.startSide.width -= e.getX();
            } else if (c == Sticky.this.bottom) {
                this.startSide.height += e.getY();
            } else if (c == Sticky.this.bottomright) {
                this.startSide.height += e.getY();
                this.startSide.width += e.getX();
            }
            this.frame.setBounds(this.startSide);
        }
    }

    public static enum Side {
        NW_SIDE,
        N_SIDE,
        NE_SIDE,
        L_SIDE,
        R_SIDE,
        SW_SIDE,
        S_SIDE,
        SE_SIDE;

    }
}

