/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.type;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 * An advertisement that may be displayed within an Evernote client.
 * Advertisements are either a snippet of HTML or else they
 * are an image (of type: JPEG, GIF, PNG) with an associated destination URL.
 * 
 * <dl>
 *   <dt>id</dt>
 *   <dd>The unique identifier of this advertisement within Evernote's ad
 *   inventory.
 *   </dd>
 * 
 *   <dt>width</dt>
 *   <dd>This ad should be displayed within a rectangle that is this wide,
 *   in pixels.
 *   </dd>
 * 
 *   <dt>height</dt>
 *   <dd>This ad should be displayed within a rectangle that is this high,
 *   in pixels.
 *   </dd>
 * 
 *   <dt>advertiserName</dt>
 *   <dd>A string containing a readable version of the name of this advertiser.
 *   </dd>
 * 
 *   <dt>imageUrl</dt>
 *   <dd>The location of the image to display for this ad.</dd>
 * 
 *   <dt>destinationUrl</dt>
 *   <dd>When a user clicks on the ad, this is the destination they should be
 *   sent to in a browser.</dd>
 * 
 *   <dt>displaySeconds</dt>
 *   <dd>The number of seconds that the ad should be displayed before it is
 *   replaced with a different ad.</dd>
 * 
 *   <dt>score</dt>
 *   <dd>A numeric indicator of the relative value of this ad, which can be
 *   compared against other ads from the same day.
 *   </dd>
 * 
 *   <dt>image</dt>
 *   <dd>If present, this is the raw image bits of the image file to display
 *   for the ad.  If not present, the imageUrl should be retrieved directly.
 *   </dd>
 * 
 *   <dt>imageMime</dt>
 *   <dd>The MIME type of the 'image' bytes, if those are set.</dd>
 * 
 *   <dt>html</dt>
 *   <dd>The exact HTML to display for this ad, to support rich or external
 *   advertisements.</dd>
 * 
 *   <dt>displayFrequency</dt>
 *   <dd>If this value is set, this is the relatively frequency that this
 *   ad should be displayed in the daily set of ads, relative to a base
 *   frequency of 1.0.  I.e. an ad with a frequency of 3.0 should be displayed
 *   three times more frequently than an ad with a frequency of 1.0.</dd>
 * </dl>
 */
public class Ad implements TBase<Ad._Fields>, java.io.Serializable, Cloneable, Comparable<Ad> {
  private static final TStruct STRUCT_DESC = new TStruct("Ad");

  private static final TField ID_FIELD_DESC = new TField("id", TType.I32, (short)1);
  private static final TField WIDTH_FIELD_DESC = new TField("width", TType.I16, (short)2);
  private static final TField HEIGHT_FIELD_DESC = new TField("height", TType.I16, (short)3);
  private static final TField ADVERTISER_NAME_FIELD_DESC = new TField("advertiserName", TType.STRING, (short)4);
  private static final TField IMAGE_URL_FIELD_DESC = new TField("imageUrl", TType.STRING, (short)5);
  private static final TField DESTINATION_URL_FIELD_DESC = new TField("destinationUrl", TType.STRING, (short)6);
  private static final TField DISPLAY_SECONDS_FIELD_DESC = new TField("displaySeconds", TType.I16, (short)7);
  private static final TField SCORE_FIELD_DESC = new TField("score", TType.DOUBLE, (short)8);
  private static final TField IMAGE_FIELD_DESC = new TField("image", TType.STRING, (short)9);
  private static final TField IMAGE_MIME_FIELD_DESC = new TField("imageMime", TType.STRING, (short)10);
  private static final TField HTML_FIELD_DESC = new TField("html", TType.STRING, (short)11);
  private static final TField DISPLAY_FREQUENCY_FIELD_DESC = new TField("displayFrequency", TType.DOUBLE, (short)12);

  private int id;
  private short width;
  private short height;
  private String advertiserName;
  private String imageUrl;
  private String destinationUrl;
  private short displaySeconds;
  private double score;
  private byte[] image;
  private String imageMime;
  private String html;
  private double displayFrequency;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    ID((short)1, "id"),
    WIDTH((short)2, "width"),
    HEIGHT((short)3, "height"),
    ADVERTISER_NAME((short)4, "advertiserName"),
    IMAGE_URL((short)5, "imageUrl"),
    DESTINATION_URL((short)6, "destinationUrl"),
    DISPLAY_SECONDS((short)7, "displaySeconds"),
    SCORE((short)8, "score"),
    IMAGE((short)9, "image"),
    IMAGE_MIME((short)10, "imageMime"),
    HTML((short)11, "html"),
    DISPLAY_FREQUENCY((short)12, "displayFrequency");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __ID_ISSET_ID = 0;
  private static final int __WIDTH_ISSET_ID = 1;
  private static final int __HEIGHT_ISSET_ID = 2;
  private static final int __DISPLAYSECONDS_ISSET_ID = 3;
  private static final int __SCORE_ISSET_ID = 4;
  private static final int __DISPLAYFREQUENCY_ISSET_ID = 5;
  private BitSet __isset_bit_vector = new BitSet(6);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.ID, new FieldMetaData("id", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.WIDTH, new FieldMetaData("width", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I16)));
    put(_Fields.HEIGHT, new FieldMetaData("height", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I16)));
    put(_Fields.ADVERTISER_NAME, new FieldMetaData("advertiserName", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.IMAGE_URL, new FieldMetaData("imageUrl", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.DESTINATION_URL, new FieldMetaData("destinationUrl", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.DISPLAY_SECONDS, new FieldMetaData("displaySeconds", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I16)));
    put(_Fields.SCORE, new FieldMetaData("score", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.DOUBLE)));
    put(_Fields.IMAGE, new FieldMetaData("image", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.IMAGE_MIME, new FieldMetaData("imageMime", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.HTML, new FieldMetaData("html", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.DISPLAY_FREQUENCY, new FieldMetaData("displayFrequency", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.DOUBLE)));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(Ad.class, metaDataMap);
  }

  public Ad() {
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public Ad(Ad other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    this.id = other.id;
    this.width = other.width;
    this.height = other.height;
    if (other.isSetAdvertiserName()) {
      this.advertiserName = other.advertiserName;
    }
    if (other.isSetImageUrl()) {
      this.imageUrl = other.imageUrl;
    }
    if (other.isSetDestinationUrl()) {
      this.destinationUrl = other.destinationUrl;
    }
    this.displaySeconds = other.displaySeconds;
    this.score = other.score;
    if (other.isSetImage()) {
      this.image = new byte[other.image.length];
      System.arraycopy(other.image, 0, image, 0, other.image.length);
    }
    if (other.isSetImageMime()) {
      this.imageMime = other.imageMime;
    }
    if (other.isSetHtml()) {
      this.html = other.html;
    }
    this.displayFrequency = other.displayFrequency;
  }

  public Ad deepCopy() {
    return new Ad(this);
  }

  @Deprecated
  public Ad clone() {
    return new Ad(this);
  }

  public int getId() {
    return this.id;
  }

  public void setId(int id) {
    this.id = id;
    setIdIsSet(true);
  }

  public void unsetId() {
    __isset_bit_vector.clear(__ID_ISSET_ID);
  }

  /** Returns true if field id is set (has been asigned a value) and false otherwise */
  public boolean isSetId() {
    return __isset_bit_vector.get(__ID_ISSET_ID);
  }

  public void setIdIsSet(boolean value) {
    __isset_bit_vector.set(__ID_ISSET_ID, value);
  }

  public short getWidth() {
    return this.width;
  }

  public void setWidth(short width) {
    this.width = width;
    setWidthIsSet(true);
  }

  public void unsetWidth() {
    __isset_bit_vector.clear(__WIDTH_ISSET_ID);
  }

  /** Returns true if field width is set (has been asigned a value) and false otherwise */
  public boolean isSetWidth() {
    return __isset_bit_vector.get(__WIDTH_ISSET_ID);
  }

  public void setWidthIsSet(boolean value) {
    __isset_bit_vector.set(__WIDTH_ISSET_ID, value);
  }

  public short getHeight() {
    return this.height;
  }

  public void setHeight(short height) {
    this.height = height;
    setHeightIsSet(true);
  }

  public void unsetHeight() {
    __isset_bit_vector.clear(__HEIGHT_ISSET_ID);
  }

  /** Returns true if field height is set (has been asigned a value) and false otherwise */
  public boolean isSetHeight() {
    return __isset_bit_vector.get(__HEIGHT_ISSET_ID);
  }

  public void setHeightIsSet(boolean value) {
    __isset_bit_vector.set(__HEIGHT_ISSET_ID, value);
  }

  public String getAdvertiserName() {
    return this.advertiserName;
  }

  public void setAdvertiserName(String advertiserName) {
    this.advertiserName = advertiserName;
  }

  public void unsetAdvertiserName() {
    this.advertiserName = null;
  }

  /** Returns true if field advertiserName is set (has been asigned a value) and false otherwise */
  public boolean isSetAdvertiserName() {
    return this.advertiserName != null;
  }

  public void setAdvertiserNameIsSet(boolean value) {
    if (!value) {
      this.advertiserName = null;
    }
  }

  public String getImageUrl() {
    return this.imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  public void unsetImageUrl() {
    this.imageUrl = null;
  }

  /** Returns true if field imageUrl is set (has been asigned a value) and false otherwise */
  public boolean isSetImageUrl() {
    return this.imageUrl != null;
  }

  public void setImageUrlIsSet(boolean value) {
    if (!value) {
      this.imageUrl = null;
    }
  }

  public String getDestinationUrl() {
    return this.destinationUrl;
  }

  public void setDestinationUrl(String destinationUrl) {
    this.destinationUrl = destinationUrl;
  }

  public void unsetDestinationUrl() {
    this.destinationUrl = null;
  }

  /** Returns true if field destinationUrl is set (has been asigned a value) and false otherwise */
  public boolean isSetDestinationUrl() {
    return this.destinationUrl != null;
  }

  public void setDestinationUrlIsSet(boolean value) {
    if (!value) {
      this.destinationUrl = null;
    }
  }

  public short getDisplaySeconds() {
    return this.displaySeconds;
  }

  public void setDisplaySeconds(short displaySeconds) {
    this.displaySeconds = displaySeconds;
    setDisplaySecondsIsSet(true);
  }

  public void unsetDisplaySeconds() {
    __isset_bit_vector.clear(__DISPLAYSECONDS_ISSET_ID);
  }

  /** Returns true if field displaySeconds is set (has been asigned a value) and false otherwise */
  public boolean isSetDisplaySeconds() {
    return __isset_bit_vector.get(__DISPLAYSECONDS_ISSET_ID);
  }

  public void setDisplaySecondsIsSet(boolean value) {
    __isset_bit_vector.set(__DISPLAYSECONDS_ISSET_ID, value);
  }

  public double getScore() {
    return this.score;
  }

  public void setScore(double score) {
    this.score = score;
    setScoreIsSet(true);
  }

  public void unsetScore() {
    __isset_bit_vector.clear(__SCORE_ISSET_ID);
  }

  /** Returns true if field score is set (has been asigned a value) and false otherwise */
  public boolean isSetScore() {
    return __isset_bit_vector.get(__SCORE_ISSET_ID);
  }

  public void setScoreIsSet(boolean value) {
    __isset_bit_vector.set(__SCORE_ISSET_ID, value);
  }

  public byte[] getImage() {
    return this.image;
  }

  public void setImage(byte[] image) {
    this.image = image;
  }

  public void unsetImage() {
    this.image = null;
  }

  /** Returns true if field image is set (has been asigned a value) and false otherwise */
  public boolean isSetImage() {
    return this.image != null;
  }

  public void setImageIsSet(boolean value) {
    if (!value) {
      this.image = null;
    }
  }

  public String getImageMime() {
    return this.imageMime;
  }

  public void setImageMime(String imageMime) {
    this.imageMime = imageMime;
  }

  public void unsetImageMime() {
    this.imageMime = null;
  }

  /** Returns true if field imageMime is set (has been asigned a value) and false otherwise */
  public boolean isSetImageMime() {
    return this.imageMime != null;
  }

  public void setImageMimeIsSet(boolean value) {
    if (!value) {
      this.imageMime = null;
    }
  }

  public String getHtml() {
    return this.html;
  }

  public void setHtml(String html) {
    this.html = html;
  }

  public void unsetHtml() {
    this.html = null;
  }

  /** Returns true if field html is set (has been asigned a value) and false otherwise */
  public boolean isSetHtml() {
    return this.html != null;
  }

  public void setHtmlIsSet(boolean value) {
    if (!value) {
      this.html = null;
    }
  }

  public double getDisplayFrequency() {
    return this.displayFrequency;
  }

  public void setDisplayFrequency(double displayFrequency) {
    this.displayFrequency = displayFrequency;
    setDisplayFrequencyIsSet(true);
  }

  public void unsetDisplayFrequency() {
    __isset_bit_vector.clear(__DISPLAYFREQUENCY_ISSET_ID);
  }

  /** Returns true if field displayFrequency is set (has been asigned a value) and false otherwise */
  public boolean isSetDisplayFrequency() {
    return __isset_bit_vector.get(__DISPLAYFREQUENCY_ISSET_ID);
  }

  public void setDisplayFrequencyIsSet(boolean value) {
    __isset_bit_vector.set(__DISPLAYFREQUENCY_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case ID:
      if (value == null) {
        unsetId();
      } else {
        setId((Integer)value);
      }
      break;

    case WIDTH:
      if (value == null) {
        unsetWidth();
      } else {
        setWidth((Short)value);
      }
      break;

    case HEIGHT:
      if (value == null) {
        unsetHeight();
      } else {
        setHeight((Short)value);
      }
      break;

    case ADVERTISER_NAME:
      if (value == null) {
        unsetAdvertiserName();
      } else {
        setAdvertiserName((String)value);
      }
      break;

    case IMAGE_URL:
      if (value == null) {
        unsetImageUrl();
      } else {
        setImageUrl((String)value);
      }
      break;

    case DESTINATION_URL:
      if (value == null) {
        unsetDestinationUrl();
      } else {
        setDestinationUrl((String)value);
      }
      break;

    case DISPLAY_SECONDS:
      if (value == null) {
        unsetDisplaySeconds();
      } else {
        setDisplaySeconds((Short)value);
      }
      break;

    case SCORE:
      if (value == null) {
        unsetScore();
      } else {
        setScore((Double)value);
      }
      break;

    case IMAGE:
      if (value == null) {
        unsetImage();
      } else {
        setImage((byte[])value);
      }
      break;

    case IMAGE_MIME:
      if (value == null) {
        unsetImageMime();
      } else {
        setImageMime((String)value);
      }
      break;

    case HTML:
      if (value == null) {
        unsetHtml();
      } else {
        setHtml((String)value);
      }
      break;

    case DISPLAY_FREQUENCY:
      if (value == null) {
        unsetDisplayFrequency();
      } else {
        setDisplayFrequency((Double)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case ID:
      return new Integer(getId());

    case WIDTH:
      return new Short(getWidth());

    case HEIGHT:
      return new Short(getHeight());

    case ADVERTISER_NAME:
      return getAdvertiserName();

    case IMAGE_URL:
      return getImageUrl();

    case DESTINATION_URL:
      return getDestinationUrl();

    case DISPLAY_SECONDS:
      return new Short(getDisplaySeconds());

    case SCORE:
      return new Double(getScore());

    case IMAGE:
      return getImage();

    case IMAGE_MIME:
      return getImageMime();

    case HTML:
      return getHtml();

    case DISPLAY_FREQUENCY:
      return new Double(getDisplayFrequency());

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case ID:
      return isSetId();
    case WIDTH:
      return isSetWidth();
    case HEIGHT:
      return isSetHeight();
    case ADVERTISER_NAME:
      return isSetAdvertiserName();
    case IMAGE_URL:
      return isSetImageUrl();
    case DESTINATION_URL:
      return isSetDestinationUrl();
    case DISPLAY_SECONDS:
      return isSetDisplaySeconds();
    case SCORE:
      return isSetScore();
    case IMAGE:
      return isSetImage();
    case IMAGE_MIME:
      return isSetImageMime();
    case HTML:
      return isSetHtml();
    case DISPLAY_FREQUENCY:
      return isSetDisplayFrequency();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof Ad)
      return this.equals((Ad)that);
    return false;
  }

  public boolean equals(Ad that) {
    if (that == null)
      return false;

    boolean this_present_id = true && this.isSetId();
    boolean that_present_id = true && that.isSetId();
    if (this_present_id || that_present_id) {
      if (!(this_present_id && that_present_id))
        return false;
      if (this.id != that.id)
        return false;
    }

    boolean this_present_width = true && this.isSetWidth();
    boolean that_present_width = true && that.isSetWidth();
    if (this_present_width || that_present_width) {
      if (!(this_present_width && that_present_width))
        return false;
      if (this.width != that.width)
        return false;
    }

    boolean this_present_height = true && this.isSetHeight();
    boolean that_present_height = true && that.isSetHeight();
    if (this_present_height || that_present_height) {
      if (!(this_present_height && that_present_height))
        return false;
      if (this.height != that.height)
        return false;
    }

    boolean this_present_advertiserName = true && this.isSetAdvertiserName();
    boolean that_present_advertiserName = true && that.isSetAdvertiserName();
    if (this_present_advertiserName || that_present_advertiserName) {
      if (!(this_present_advertiserName && that_present_advertiserName))
        return false;
      if (!this.advertiserName.equals(that.advertiserName))
        return false;
    }

    boolean this_present_imageUrl = true && this.isSetImageUrl();
    boolean that_present_imageUrl = true && that.isSetImageUrl();
    if (this_present_imageUrl || that_present_imageUrl) {
      if (!(this_present_imageUrl && that_present_imageUrl))
        return false;
      if (!this.imageUrl.equals(that.imageUrl))
        return false;
    }

    boolean this_present_destinationUrl = true && this.isSetDestinationUrl();
    boolean that_present_destinationUrl = true && that.isSetDestinationUrl();
    if (this_present_destinationUrl || that_present_destinationUrl) {
      if (!(this_present_destinationUrl && that_present_destinationUrl))
        return false;
      if (!this.destinationUrl.equals(that.destinationUrl))
        return false;
    }

    boolean this_present_displaySeconds = true && this.isSetDisplaySeconds();
    boolean that_present_displaySeconds = true && that.isSetDisplaySeconds();
    if (this_present_displaySeconds || that_present_displaySeconds) {
      if (!(this_present_displaySeconds && that_present_displaySeconds))
        return false;
      if (this.displaySeconds != that.displaySeconds)
        return false;
    }

    boolean this_present_score = true && this.isSetScore();
    boolean that_present_score = true && that.isSetScore();
    if (this_present_score || that_present_score) {
      if (!(this_present_score && that_present_score))
        return false;
      if (this.score != that.score)
        return false;
    }

    boolean this_present_image = true && this.isSetImage();
    boolean that_present_image = true && that.isSetImage();
    if (this_present_image || that_present_image) {
      if (!(this_present_image && that_present_image))
        return false;
      if (!java.util.Arrays.equals(this.image, that.image))
        return false;
    }

    boolean this_present_imageMime = true && this.isSetImageMime();
    boolean that_present_imageMime = true && that.isSetImageMime();
    if (this_present_imageMime || that_present_imageMime) {
      if (!(this_present_imageMime && that_present_imageMime))
        return false;
      if (!this.imageMime.equals(that.imageMime))
        return false;
    }

    boolean this_present_html = true && this.isSetHtml();
    boolean that_present_html = true && that.isSetHtml();
    if (this_present_html || that_present_html) {
      if (!(this_present_html && that_present_html))
        return false;
      if (!this.html.equals(that.html))
        return false;
    }

    boolean this_present_displayFrequency = true && this.isSetDisplayFrequency();
    boolean that_present_displayFrequency = true && that.isSetDisplayFrequency();
    if (this_present_displayFrequency || that_present_displayFrequency) {
      if (!(this_present_displayFrequency && that_present_displayFrequency))
        return false;
      if (this.displayFrequency != that.displayFrequency)
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(Ad other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    Ad typedOther = (Ad)other;

    lastComparison = Boolean.valueOf(isSetId()).compareTo(isSetId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(id, typedOther.id);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetWidth()).compareTo(isSetWidth());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(width, typedOther.width);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetHeight()).compareTo(isSetHeight());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(height, typedOther.height);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetAdvertiserName()).compareTo(isSetAdvertiserName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(advertiserName, typedOther.advertiserName);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetImageUrl()).compareTo(isSetImageUrl());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(imageUrl, typedOther.imageUrl);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDestinationUrl()).compareTo(isSetDestinationUrl());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(destinationUrl, typedOther.destinationUrl);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDisplaySeconds()).compareTo(isSetDisplaySeconds());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(displaySeconds, typedOther.displaySeconds);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetScore()).compareTo(isSetScore());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(score, typedOther.score);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetImage()).compareTo(isSetImage());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(image, typedOther.image);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetImageMime()).compareTo(isSetImageMime());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(imageMime, typedOther.imageMime);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetHtml()).compareTo(isSetHtml());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(html, typedOther.html);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDisplayFrequency()).compareTo(isSetDisplayFrequency());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(displayFrequency, typedOther.displayFrequency);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case ID:
            if (field.type == TType.I32) {
              this.id = iprot.readI32();
              setIdIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case WIDTH:
            if (field.type == TType.I16) {
              this.width = iprot.readI16();
              setWidthIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case HEIGHT:
            if (field.type == TType.I16) {
              this.height = iprot.readI16();
              setHeightIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ADVERTISER_NAME:
            if (field.type == TType.STRING) {
              this.advertiserName = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case IMAGE_URL:
            if (field.type == TType.STRING) {
              this.imageUrl = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DESTINATION_URL:
            if (field.type == TType.STRING) {
              this.destinationUrl = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DISPLAY_SECONDS:
            if (field.type == TType.I16) {
              this.displaySeconds = iprot.readI16();
              setDisplaySecondsIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case SCORE:
            if (field.type == TType.DOUBLE) {
              this.score = iprot.readDouble();
              setScoreIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case IMAGE:
            if (field.type == TType.STRING) {
              this.image = iprot.readBinary();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case IMAGE_MIME:
            if (field.type == TType.STRING) {
              this.imageMime = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case HTML:
            if (field.type == TType.STRING) {
              this.html = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DISPLAY_FREQUENCY:
            if (field.type == TType.DOUBLE) {
              this.displayFrequency = iprot.readDouble();
              setDisplayFrequencyIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (isSetId()) {
      oprot.writeFieldBegin(ID_FIELD_DESC);
      oprot.writeI32(this.id);
      oprot.writeFieldEnd();
    }
    if (isSetWidth()) {
      oprot.writeFieldBegin(WIDTH_FIELD_DESC);
      oprot.writeI16(this.width);
      oprot.writeFieldEnd();
    }
    if (isSetHeight()) {
      oprot.writeFieldBegin(HEIGHT_FIELD_DESC);
      oprot.writeI16(this.height);
      oprot.writeFieldEnd();
    }
    if (this.advertiserName != null) {
      if (isSetAdvertiserName()) {
        oprot.writeFieldBegin(ADVERTISER_NAME_FIELD_DESC);
        oprot.writeString(this.advertiserName);
        oprot.writeFieldEnd();
      }
    }
    if (this.imageUrl != null) {
      if (isSetImageUrl()) {
        oprot.writeFieldBegin(IMAGE_URL_FIELD_DESC);
        oprot.writeString(this.imageUrl);
        oprot.writeFieldEnd();
      }
    }
    if (this.destinationUrl != null) {
      if (isSetDestinationUrl()) {
        oprot.writeFieldBegin(DESTINATION_URL_FIELD_DESC);
        oprot.writeString(this.destinationUrl);
        oprot.writeFieldEnd();
      }
    }
    if (isSetDisplaySeconds()) {
      oprot.writeFieldBegin(DISPLAY_SECONDS_FIELD_DESC);
      oprot.writeI16(this.displaySeconds);
      oprot.writeFieldEnd();
    }
    if (isSetScore()) {
      oprot.writeFieldBegin(SCORE_FIELD_DESC);
      oprot.writeDouble(this.score);
      oprot.writeFieldEnd();
    }
    if (this.image != null) {
      if (isSetImage()) {
        oprot.writeFieldBegin(IMAGE_FIELD_DESC);
        oprot.writeBinary(this.image);
        oprot.writeFieldEnd();
      }
    }
    if (this.imageMime != null) {
      if (isSetImageMime()) {
        oprot.writeFieldBegin(IMAGE_MIME_FIELD_DESC);
        oprot.writeString(this.imageMime);
        oprot.writeFieldEnd();
      }
    }
    if (this.html != null) {
      if (isSetHtml()) {
        oprot.writeFieldBegin(HTML_FIELD_DESC);
        oprot.writeString(this.html);
        oprot.writeFieldEnd();
      }
    }
    if (isSetDisplayFrequency()) {
      oprot.writeFieldBegin(DISPLAY_FREQUENCY_FIELD_DESC);
      oprot.writeDouble(this.displayFrequency);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("Ad(");
    boolean first = true;

    if (isSetId()) {
      sb.append("id:");
      sb.append(this.id);
      first = false;
    }
    if (isSetWidth()) {
      if (!first) sb.append(", ");
      sb.append("width:");
      sb.append(this.width);
      first = false;
    }
    if (isSetHeight()) {
      if (!first) sb.append(", ");
      sb.append("height:");
      sb.append(this.height);
      first = false;
    }
    if (isSetAdvertiserName()) {
      if (!first) sb.append(", ");
      sb.append("advertiserName:");
      if (this.advertiserName == null) {
        sb.append("null");
      } else {
        sb.append(this.advertiserName);
      }
      first = false;
    }
    if (isSetImageUrl()) {
      if (!first) sb.append(", ");
      sb.append("imageUrl:");
      if (this.imageUrl == null) {
        sb.append("null");
      } else {
        sb.append(this.imageUrl);
      }
      first = false;
    }
    if (isSetDestinationUrl()) {
      if (!first) sb.append(", ");
      sb.append("destinationUrl:");
      if (this.destinationUrl == null) {
        sb.append("null");
      } else {
        sb.append(this.destinationUrl);
      }
      first = false;
    }
    if (isSetDisplaySeconds()) {
      if (!first) sb.append(", ");
      sb.append("displaySeconds:");
      sb.append(this.displaySeconds);
      first = false;
    }
    if (isSetScore()) {
      if (!first) sb.append(", ");
      sb.append("score:");
      sb.append(this.score);
      first = false;
    }
    if (isSetImage()) {
      if (!first) sb.append(", ");
      sb.append("image:");
      if (this.image == null) {
        sb.append("null");
      } else {
          int __image_size = Math.min(this.image.length, 128);
          for (int i = 0; i < __image_size; i++) {
            if (i != 0) sb.append(" ");
            sb.append(Integer.toHexString(this.image[i]).length() > 1 ? Integer.toHexString(this.image[i]).substring(Integer.toHexString(this.image[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.image[i]).toUpperCase());
          }
          if (this.image.length > 128) sb.append(" ...");
      }
      first = false;
    }
    if (isSetImageMime()) {
      if (!first) sb.append(", ");
      sb.append("imageMime:");
      if (this.imageMime == null) {
        sb.append("null");
      } else {
        sb.append(this.imageMime);
      }
      first = false;
    }
    if (isSetHtml()) {
      if (!first) sb.append(", ");
      sb.append("html:");
      if (this.html == null) {
        sb.append("null");
      } else {
        sb.append(this.html);
      }
      first = false;
    }
    if (isSetDisplayFrequency()) {
      if (!first) sb.append(", ");
      sb.append("displayFrequency:");
      sb.append(this.displayFrequency);
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }

}

