/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.type;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 *  A structure holding the optional attributes that can be stored
 *  on a User.  These are generally less critical than the core User fields.
 * 
 * <dl>
 *  <dt>defaultLocationName</dt>
 *    <dd>the location string that should be associated
 *    with the user in order to determine where notes are taken if not otherwise
 *    specified.<br/>
 *    Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
 *    </dd>
 * 
 *  <dt>defaultLatitude</dt>
 *    <dd>if set, this is the latitude that should be
 *    assigned to any notes that have no other latitude information.
 *    </dd>
 * 
 *  <dt>defaultLongitude</dt>
 *    <dd>if set, this is the longitude that should be
 *    assigned to any notes that have no other longitude information.
 *    </dd>
 * 
 *  <dt>preactivation</dt>
 *    <dd>if set, the user account is not yet confirmed for
 *    login.  I.e. the account has been created, but we are still waiting for
 *    the user to complete the activation step.
 *    </dd>
 * 
 *  <dt>viewedPromotions</dt>
 *    <dd>a list of promotions the user has seen.
 *     This list may occasionally be modified by the system when promotions are
 *     no longer available.<br/>
 *     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
 *    </dd>
 * 
 *  <dt>incomingEmailAddress</dt>
 *    <dd>if set, this is the email address that the
 *     user may send email to in order to add an email note directly into the
 *     account via the SMTP email gateway.  This is the part of the email
 *     address before the '@' symbol ... our domain is not included.
 *     If this is not set, the user may not add notes via the gateway.<br/>
 *     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
 *    </dd>
 * 
 *  <dt>recentMailedAddresses</dt>
 *    <dd>if set, this will contain a list of email
 *     addresses that have recently been used as recipients
 *     of outbound emails by the user.  This can be used to pre-populate a
 *     list of possible destinations when a user wishes to send a note via
 *     email.<br/>
 *     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX each<br/>
 *     Max:  EDAM_USER_RECENT_MAILED_ADDRESSES_MAX entries
 *    </dd>
 * 
 *  <dt>comments</dt>
 *    <dd>Free-form text field that may hold general support
 *     information, etc.<br/>
 *     Length:  EDAM_ATTRIBUTE_LEN_MIN - EDAM_ATTRIBUTE_LEN_MAX
 *    </dd>
 * 
 *  <dt>dateAgreedToTermsOfService</dt>
 *    <dd>The date/time when the user agreed to
 *     the terms of service.  This can be used as the effective "start date"
 *     for the account.
 *    </dd>
 * 
 *  <dt>maxReferrals</dt>
 *    <dd>The number of referrals that the user is permitted
 *     to make.
 *    </dd>
 * 
 *  <dt>referralCount</dt>
 *    <dd>The number of referrals sent from this account.
 *    </dd>
 * 
 *  <dt>refererCode</dt>
 *    <dd>A code indicating where the user was sent from. AKA
 *     promotion code
 *    </dd>
 *     
 *  <dt>sentEmailDate</dt>
 *    <dd>The most recent date when the user sent outbound
 *     emails from the service.  Used with sentEmailCount to limit the number
 *     of emails that can be sent per day.
 *    </dd>
 *     
 *  <dt>sentEmailCount</dt>
 *    <dd>The number of emails that were sent from the user
 *     via the service on sentEmailDate.  Used to enforce a limit on the number
 *     of emails per user per day to prevent spamming.
 *    </dd>
 * 
 *  <dt>dailyEmailLimit</dt>
 *    <dd>If set, this is the maximum number of emails that
 *     may be sent in a given day from this account.  If unset, the server will
 *     use the configured default limit.
 *    </dd>
 * 
 *  <dt>emailOptOutDate</dt>
 *    <dd>If set, this is the date when the user asked
 *     to be excluded from offers and promotions sent by Evernote.  If not set,
 *     then the user currently agrees to receive these messages.
 *    </dd>
 * 
 *  <dt>partnerEmailOptInDate</dt>
 *    <dd>If set, this is the date when the user asked
 *     to be included in offers and promotions sent by Evernote's partners.
 *     If not sent, then the user currently does not agree to receive these
 *     emails.
 *    </dd>
 * 
 *  <dt>preferredLanguage</dt>
 *    <dd>a 2 character language codes based on:
 *        http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt used for
 *       localization purposes to determine what language to use for the web
 *       interface and for other direct communication (e.g. emails).
 *    </dd>
 * 
 *  <dt>preferredCountry</dt>
 *    <dd>Preferred country code based on ISO 3166-1-alpha-2 indicating the
 *    users preferred country</dd>
 * 
 *  <dt>clipFullPage</dt>
 *    <dd>Boolean flag set to true if the user wants to clip full pages by
 *    default when they use the web clipper without a selection.</dd>
 * 
 *  <dt>twitterUserName</dt>
 *    <dd>The username of the account of someone who has chosen to enable
 *    Twittering into Evernote.  This value is subject to change, since users
 *    may change their Twitter user name.</dd>
 * 
 *  <dt>twitterId</dt>
 *    <dd>The unique identifier of the user's Twitter account if that user
 *    has chosen to enable Twittering into Evernote.</dd>
 * 
 *  <dt>groupName</dt>
 *    <dd>A name identifier used to identify a particular set of branding and
 *     light customization.</dd>
 *     
 *  <dt>recognitionLanguage</dt>
 *    <dd>a 2 character language codes based on:
 *        http://ftp.ics.uci.edu/pub/ietf/http/related/iso639.txt
 *        If set, this is used to determine the language that should be used
 *        when processing images and PDF files to find text.
 *        If not set, then the 'preferredLanguage' will be used.
 *    </dd>
 *  </dl>
 * 
 *  <dt>customerProfileId</dt>
 *    <dd>a numeric identified which provides a linkage between the user record
 *        and the direct credit card payment creditcard profile.
 *    </dd>
 *  </dl>
 * 
 */
public class UserAttributes implements TBase<UserAttributes._Fields>, java.io.Serializable, Cloneable, Comparable<UserAttributes> {
  private static final TStruct STRUCT_DESC = new TStruct("UserAttributes");

  private static final TField DEFAULT_LOCATION_NAME_FIELD_DESC = new TField("defaultLocationName", TType.STRING, (short)1);
  private static final TField DEFAULT_LATITUDE_FIELD_DESC = new TField("defaultLatitude", TType.DOUBLE, (short)2);
  private static final TField DEFAULT_LONGITUDE_FIELD_DESC = new TField("defaultLongitude", TType.DOUBLE, (short)3);
  private static final TField PREACTIVATION_FIELD_DESC = new TField("preactivation", TType.BOOL, (short)4);
  private static final TField VIEWED_PROMOTIONS_FIELD_DESC = new TField("viewedPromotions", TType.LIST, (short)5);
  private static final TField INCOMING_EMAIL_ADDRESS_FIELD_DESC = new TField("incomingEmailAddress", TType.STRING, (short)6);
  private static final TField RECENT_MAILED_ADDRESSES_FIELD_DESC = new TField("recentMailedAddresses", TType.LIST, (short)7);
  private static final TField COMMENTS_FIELD_DESC = new TField("comments", TType.STRING, (short)9);
  private static final TField DATE_AGREED_TO_TERMS_OF_SERVICE_FIELD_DESC = new TField("dateAgreedToTermsOfService", TType.I64, (short)11);
  private static final TField MAX_REFERRALS_FIELD_DESC = new TField("maxReferrals", TType.I32, (short)12);
  private static final TField REFERRAL_COUNT_FIELD_DESC = new TField("referralCount", TType.I32, (short)13);
  private static final TField REFERER_CODE_FIELD_DESC = new TField("refererCode", TType.STRING, (short)14);
  private static final TField SENT_EMAIL_DATE_FIELD_DESC = new TField("sentEmailDate", TType.I64, (short)15);
  private static final TField SENT_EMAIL_COUNT_FIELD_DESC = new TField("sentEmailCount", TType.I32, (short)16);
  private static final TField DAILY_EMAIL_LIMIT_FIELD_DESC = new TField("dailyEmailLimit", TType.I32, (short)17);
  private static final TField EMAIL_OPT_OUT_DATE_FIELD_DESC = new TField("emailOptOutDate", TType.I64, (short)18);
  private static final TField PARTNER_EMAIL_OPT_IN_DATE_FIELD_DESC = new TField("partnerEmailOptInDate", TType.I64, (short)19);
  private static final TField PREFERRED_LANGUAGE_FIELD_DESC = new TField("preferredLanguage", TType.STRING, (short)20);
  private static final TField PREFERRED_COUNTRY_FIELD_DESC = new TField("preferredCountry", TType.STRING, (short)21);
  private static final TField CLIP_FULL_PAGE_FIELD_DESC = new TField("clipFullPage", TType.BOOL, (short)22);
  private static final TField TWITTER_USER_NAME_FIELD_DESC = new TField("twitterUserName", TType.STRING, (short)23);
  private static final TField TWITTER_ID_FIELD_DESC = new TField("twitterId", TType.STRING, (short)24);
  private static final TField GROUP_NAME_FIELD_DESC = new TField("groupName", TType.STRING, (short)25);
  private static final TField RECOGNITION_LANGUAGE_FIELD_DESC = new TField("recognitionLanguage", TType.STRING, (short)26);
  private static final TField CUSTOMER_PROFILE_ID_FIELD_DESC = new TField("customerProfileId", TType.I64, (short)27);
  private static final TField REFERRAL_PROOF_FIELD_DESC = new TField("referralProof", TType.STRING, (short)28);

  private String defaultLocationName;
  private double defaultLatitude;
  private double defaultLongitude;
  private boolean preactivation;
  private List<String> viewedPromotions;
  private String incomingEmailAddress;
  private List<String> recentMailedAddresses;
  private String comments;
  private long dateAgreedToTermsOfService;
  private int maxReferrals;
  private int referralCount;
  private String refererCode;
  private long sentEmailDate;
  private int sentEmailCount;
  private int dailyEmailLimit;
  private long emailOptOutDate;
  private long partnerEmailOptInDate;
  private String preferredLanguage;
  private String preferredCountry;
  private boolean clipFullPage;
  private String twitterUserName;
  private String twitterId;
  private String groupName;
  private String recognitionLanguage;
  private long customerProfileId;
  private String referralProof;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    DEFAULT_LOCATION_NAME((short)1, "defaultLocationName"),
    DEFAULT_LATITUDE((short)2, "defaultLatitude"),
    DEFAULT_LONGITUDE((short)3, "defaultLongitude"),
    PREACTIVATION((short)4, "preactivation"),
    VIEWED_PROMOTIONS((short)5, "viewedPromotions"),
    INCOMING_EMAIL_ADDRESS((short)6, "incomingEmailAddress"),
    RECENT_MAILED_ADDRESSES((short)7, "recentMailedAddresses"),
    COMMENTS((short)9, "comments"),
    DATE_AGREED_TO_TERMS_OF_SERVICE((short)11, "dateAgreedToTermsOfService"),
    MAX_REFERRALS((short)12, "maxReferrals"),
    REFERRAL_COUNT((short)13, "referralCount"),
    REFERER_CODE((short)14, "refererCode"),
    SENT_EMAIL_DATE((short)15, "sentEmailDate"),
    SENT_EMAIL_COUNT((short)16, "sentEmailCount"),
    DAILY_EMAIL_LIMIT((short)17, "dailyEmailLimit"),
    EMAIL_OPT_OUT_DATE((short)18, "emailOptOutDate"),
    PARTNER_EMAIL_OPT_IN_DATE((short)19, "partnerEmailOptInDate"),
    PREFERRED_LANGUAGE((short)20, "preferredLanguage"),
    PREFERRED_COUNTRY((short)21, "preferredCountry"),
    CLIP_FULL_PAGE((short)22, "clipFullPage"),
    TWITTER_USER_NAME((short)23, "twitterUserName"),
    TWITTER_ID((short)24, "twitterId"),
    GROUP_NAME((short)25, "groupName"),
    RECOGNITION_LANGUAGE((short)26, "recognitionLanguage"),
    CUSTOMER_PROFILE_ID((short)27, "customerProfileId"),
    REFERRAL_PROOF((short)28, "referralProof");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __DEFAULTLATITUDE_ISSET_ID = 0;
  private static final int __DEFAULTLONGITUDE_ISSET_ID = 1;
  private static final int __PREACTIVATION_ISSET_ID = 2;
  private static final int __DATEAGREEDTOTERMSOFSERVICE_ISSET_ID = 3;
  private static final int __MAXREFERRALS_ISSET_ID = 4;
  private static final int __REFERRALCOUNT_ISSET_ID = 5;
  private static final int __SENTEMAILDATE_ISSET_ID = 6;
  private static final int __SENTEMAILCOUNT_ISSET_ID = 7;
  private static final int __DAILYEMAILLIMIT_ISSET_ID = 8;
  private static final int __EMAILOPTOUTDATE_ISSET_ID = 9;
  private static final int __PARTNEREMAILOPTINDATE_ISSET_ID = 10;
  private static final int __CLIPFULLPAGE_ISSET_ID = 11;
  private static final int __CUSTOMERPROFILEID_ISSET_ID = 12;
  private BitSet __isset_bit_vector = new BitSet(13);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.DEFAULT_LOCATION_NAME, new FieldMetaData("defaultLocationName", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.DEFAULT_LATITUDE, new FieldMetaData("defaultLatitude", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.DOUBLE)));
    put(_Fields.DEFAULT_LONGITUDE, new FieldMetaData("defaultLongitude", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.DOUBLE)));
    put(_Fields.PREACTIVATION, new FieldMetaData("preactivation", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.BOOL)));
    put(_Fields.VIEWED_PROMOTIONS, new FieldMetaData("viewedPromotions", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.INCOMING_EMAIL_ADDRESS, new FieldMetaData("incomingEmailAddress", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.RECENT_MAILED_ADDRESSES, new FieldMetaData("recentMailedAddresses", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.COMMENTS, new FieldMetaData("comments", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.DATE_AGREED_TO_TERMS_OF_SERVICE, new FieldMetaData("dateAgreedToTermsOfService", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.MAX_REFERRALS, new FieldMetaData("maxReferrals", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.REFERRAL_COUNT, new FieldMetaData("referralCount", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.REFERER_CODE, new FieldMetaData("refererCode", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.SENT_EMAIL_DATE, new FieldMetaData("sentEmailDate", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.SENT_EMAIL_COUNT, new FieldMetaData("sentEmailCount", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.DAILY_EMAIL_LIMIT, new FieldMetaData("dailyEmailLimit", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.EMAIL_OPT_OUT_DATE, new FieldMetaData("emailOptOutDate", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PARTNER_EMAIL_OPT_IN_DATE, new FieldMetaData("partnerEmailOptInDate", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PREFERRED_LANGUAGE, new FieldMetaData("preferredLanguage", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.PREFERRED_COUNTRY, new FieldMetaData("preferredCountry", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.CLIP_FULL_PAGE, new FieldMetaData("clipFullPage", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.BOOL)));
    put(_Fields.TWITTER_USER_NAME, new FieldMetaData("twitterUserName", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.TWITTER_ID, new FieldMetaData("twitterId", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.GROUP_NAME, new FieldMetaData("groupName", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.RECOGNITION_LANGUAGE, new FieldMetaData("recognitionLanguage", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.CUSTOMER_PROFILE_ID, new FieldMetaData("customerProfileId", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.REFERRAL_PROOF, new FieldMetaData("referralProof", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(UserAttributes.class, metaDataMap);
  }

  public UserAttributes() {
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public UserAttributes(UserAttributes other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    if (other.isSetDefaultLocationName()) {
      this.defaultLocationName = other.defaultLocationName;
    }
    this.defaultLatitude = other.defaultLatitude;
    this.defaultLongitude = other.defaultLongitude;
    this.preactivation = other.preactivation;
    if (other.isSetViewedPromotions()) {
      List<String> __this__viewedPromotions = new ArrayList<String>();
      for (String other_element : other.viewedPromotions) {
        __this__viewedPromotions.add(other_element);
      }
      this.viewedPromotions = __this__viewedPromotions;
    }
    if (other.isSetIncomingEmailAddress()) {
      this.incomingEmailAddress = other.incomingEmailAddress;
    }
    if (other.isSetRecentMailedAddresses()) {
      List<String> __this__recentMailedAddresses = new ArrayList<String>();
      for (String other_element : other.recentMailedAddresses) {
        __this__recentMailedAddresses.add(other_element);
      }
      this.recentMailedAddresses = __this__recentMailedAddresses;
    }
    if (other.isSetComments()) {
      this.comments = other.comments;
    }
    this.dateAgreedToTermsOfService = other.dateAgreedToTermsOfService;
    this.maxReferrals = other.maxReferrals;
    this.referralCount = other.referralCount;
    if (other.isSetRefererCode()) {
      this.refererCode = other.refererCode;
    }
    this.sentEmailDate = other.sentEmailDate;
    this.sentEmailCount = other.sentEmailCount;
    this.dailyEmailLimit = other.dailyEmailLimit;
    this.emailOptOutDate = other.emailOptOutDate;
    this.partnerEmailOptInDate = other.partnerEmailOptInDate;
    if (other.isSetPreferredLanguage()) {
      this.preferredLanguage = other.preferredLanguage;
    }
    if (other.isSetPreferredCountry()) {
      this.preferredCountry = other.preferredCountry;
    }
    this.clipFullPage = other.clipFullPage;
    if (other.isSetTwitterUserName()) {
      this.twitterUserName = other.twitterUserName;
    }
    if (other.isSetTwitterId()) {
      this.twitterId = other.twitterId;
    }
    if (other.isSetGroupName()) {
      this.groupName = other.groupName;
    }
    if (other.isSetRecognitionLanguage()) {
      this.recognitionLanguage = other.recognitionLanguage;
    }
    this.customerProfileId = other.customerProfileId;
    if (other.isSetReferralProof()) {
      this.referralProof = other.referralProof;
    }
  }

  public UserAttributes deepCopy() {
    return new UserAttributes(this);
  }

  @Deprecated
  public UserAttributes clone() {
    return new UserAttributes(this);
  }

  public String getDefaultLocationName() {
    return this.defaultLocationName;
  }

  public void setDefaultLocationName(String defaultLocationName) {
    this.defaultLocationName = defaultLocationName;
  }

  public void unsetDefaultLocationName() {
    this.defaultLocationName = null;
  }

  /** Returns true if field defaultLocationName is set (has been asigned a value) and false otherwise */
  public boolean isSetDefaultLocationName() {
    return this.defaultLocationName != null;
  }

  public void setDefaultLocationNameIsSet(boolean value) {
    if (!value) {
      this.defaultLocationName = null;
    }
  }

  public double getDefaultLatitude() {
    return this.defaultLatitude;
  }

  public void setDefaultLatitude(double defaultLatitude) {
    this.defaultLatitude = defaultLatitude;
    setDefaultLatitudeIsSet(true);
  }

  public void unsetDefaultLatitude() {
    __isset_bit_vector.clear(__DEFAULTLATITUDE_ISSET_ID);
  }

  /** Returns true if field defaultLatitude is set (has been asigned a value) and false otherwise */
  public boolean isSetDefaultLatitude() {
    return __isset_bit_vector.get(__DEFAULTLATITUDE_ISSET_ID);
  }

  public void setDefaultLatitudeIsSet(boolean value) {
    __isset_bit_vector.set(__DEFAULTLATITUDE_ISSET_ID, value);
  }

  public double getDefaultLongitude() {
    return this.defaultLongitude;
  }

  public void setDefaultLongitude(double defaultLongitude) {
    this.defaultLongitude = defaultLongitude;
    setDefaultLongitudeIsSet(true);
  }

  public void unsetDefaultLongitude() {
    __isset_bit_vector.clear(__DEFAULTLONGITUDE_ISSET_ID);
  }

  /** Returns true if field defaultLongitude is set (has been asigned a value) and false otherwise */
  public boolean isSetDefaultLongitude() {
    return __isset_bit_vector.get(__DEFAULTLONGITUDE_ISSET_ID);
  }

  public void setDefaultLongitudeIsSet(boolean value) {
    __isset_bit_vector.set(__DEFAULTLONGITUDE_ISSET_ID, value);
  }

  public boolean isPreactivation() {
    return this.preactivation;
  }

  public void setPreactivation(boolean preactivation) {
    this.preactivation = preactivation;
    setPreactivationIsSet(true);
  }

  public void unsetPreactivation() {
    __isset_bit_vector.clear(__PREACTIVATION_ISSET_ID);
  }

  /** Returns true if field preactivation is set (has been asigned a value) and false otherwise */
  public boolean isSetPreactivation() {
    return __isset_bit_vector.get(__PREACTIVATION_ISSET_ID);
  }

  public void setPreactivationIsSet(boolean value) {
    __isset_bit_vector.set(__PREACTIVATION_ISSET_ID, value);
  }

  public int getViewedPromotionsSize() {
    return (this.viewedPromotions == null) ? 0 : this.viewedPromotions.size();
  }

  public java.util.Iterator<String> getViewedPromotionsIterator() {
    return (this.viewedPromotions == null) ? null : this.viewedPromotions.iterator();
  }

  public void addToViewedPromotions(String elem) {
    if (this.viewedPromotions == null) {
      this.viewedPromotions = new ArrayList<String>();
    }
    this.viewedPromotions.add(elem);
  }

  public List<String> getViewedPromotions() {
    return this.viewedPromotions;
  }

  public void setViewedPromotions(List<String> viewedPromotions) {
    this.viewedPromotions = viewedPromotions;
  }

  public void unsetViewedPromotions() {
    this.viewedPromotions = null;
  }

  /** Returns true if field viewedPromotions is set (has been asigned a value) and false otherwise */
  public boolean isSetViewedPromotions() {
    return this.viewedPromotions != null;
  }

  public void setViewedPromotionsIsSet(boolean value) {
    if (!value) {
      this.viewedPromotions = null;
    }
  }

  public String getIncomingEmailAddress() {
    return this.incomingEmailAddress;
  }

  public void setIncomingEmailAddress(String incomingEmailAddress) {
    this.incomingEmailAddress = incomingEmailAddress;
  }

  public void unsetIncomingEmailAddress() {
    this.incomingEmailAddress = null;
  }

  /** Returns true if field incomingEmailAddress is set (has been asigned a value) and false otherwise */
  public boolean isSetIncomingEmailAddress() {
    return this.incomingEmailAddress != null;
  }

  public void setIncomingEmailAddressIsSet(boolean value) {
    if (!value) {
      this.incomingEmailAddress = null;
    }
  }

  public int getRecentMailedAddressesSize() {
    return (this.recentMailedAddresses == null) ? 0 : this.recentMailedAddresses.size();
  }

  public java.util.Iterator<String> getRecentMailedAddressesIterator() {
    return (this.recentMailedAddresses == null) ? null : this.recentMailedAddresses.iterator();
  }

  public void addToRecentMailedAddresses(String elem) {
    if (this.recentMailedAddresses == null) {
      this.recentMailedAddresses = new ArrayList<String>();
    }
    this.recentMailedAddresses.add(elem);
  }

  public List<String> getRecentMailedAddresses() {
    return this.recentMailedAddresses;
  }

  public void setRecentMailedAddresses(List<String> recentMailedAddresses) {
    this.recentMailedAddresses = recentMailedAddresses;
  }

  public void unsetRecentMailedAddresses() {
    this.recentMailedAddresses = null;
  }

  /** Returns true if field recentMailedAddresses is set (has been asigned a value) and false otherwise */
  public boolean isSetRecentMailedAddresses() {
    return this.recentMailedAddresses != null;
  }

  public void setRecentMailedAddressesIsSet(boolean value) {
    if (!value) {
      this.recentMailedAddresses = null;
    }
  }

  public String getComments() {
    return this.comments;
  }

  public void setComments(String comments) {
    this.comments = comments;
  }

  public void unsetComments() {
    this.comments = null;
  }

  /** Returns true if field comments is set (has been asigned a value) and false otherwise */
  public boolean isSetComments() {
    return this.comments != null;
  }

  public void setCommentsIsSet(boolean value) {
    if (!value) {
      this.comments = null;
    }
  }

  public long getDateAgreedToTermsOfService() {
    return this.dateAgreedToTermsOfService;
  }

  public void setDateAgreedToTermsOfService(long dateAgreedToTermsOfService) {
    this.dateAgreedToTermsOfService = dateAgreedToTermsOfService;
    setDateAgreedToTermsOfServiceIsSet(true);
  }

  public void unsetDateAgreedToTermsOfService() {
    __isset_bit_vector.clear(__DATEAGREEDTOTERMSOFSERVICE_ISSET_ID);
  }

  /** Returns true if field dateAgreedToTermsOfService is set (has been asigned a value) and false otherwise */
  public boolean isSetDateAgreedToTermsOfService() {
    return __isset_bit_vector.get(__DATEAGREEDTOTERMSOFSERVICE_ISSET_ID);
  }

  public void setDateAgreedToTermsOfServiceIsSet(boolean value) {
    __isset_bit_vector.set(__DATEAGREEDTOTERMSOFSERVICE_ISSET_ID, value);
  }

  public int getMaxReferrals() {
    return this.maxReferrals;
  }

  public void setMaxReferrals(int maxReferrals) {
    this.maxReferrals = maxReferrals;
    setMaxReferralsIsSet(true);
  }

  public void unsetMaxReferrals() {
    __isset_bit_vector.clear(__MAXREFERRALS_ISSET_ID);
  }

  /** Returns true if field maxReferrals is set (has been asigned a value) and false otherwise */
  public boolean isSetMaxReferrals() {
    return __isset_bit_vector.get(__MAXREFERRALS_ISSET_ID);
  }

  public void setMaxReferralsIsSet(boolean value) {
    __isset_bit_vector.set(__MAXREFERRALS_ISSET_ID, value);
  }

  public int getReferralCount() {
    return this.referralCount;
  }

  public void setReferralCount(int referralCount) {
    this.referralCount = referralCount;
    setReferralCountIsSet(true);
  }

  public void unsetReferralCount() {
    __isset_bit_vector.clear(__REFERRALCOUNT_ISSET_ID);
  }

  /** Returns true if field referralCount is set (has been asigned a value) and false otherwise */
  public boolean isSetReferralCount() {
    return __isset_bit_vector.get(__REFERRALCOUNT_ISSET_ID);
  }

  public void setReferralCountIsSet(boolean value) {
    __isset_bit_vector.set(__REFERRALCOUNT_ISSET_ID, value);
  }

  public String getRefererCode() {
    return this.refererCode;
  }

  public void setRefererCode(String refererCode) {
    this.refererCode = refererCode;
  }

  public void unsetRefererCode() {
    this.refererCode = null;
  }

  /** Returns true if field refererCode is set (has been asigned a value) and false otherwise */
  public boolean isSetRefererCode() {
    return this.refererCode != null;
  }

  public void setRefererCodeIsSet(boolean value) {
    if (!value) {
      this.refererCode = null;
    }
  }

  public long getSentEmailDate() {
    return this.sentEmailDate;
  }

  public void setSentEmailDate(long sentEmailDate) {
    this.sentEmailDate = sentEmailDate;
    setSentEmailDateIsSet(true);
  }

  public void unsetSentEmailDate() {
    __isset_bit_vector.clear(__SENTEMAILDATE_ISSET_ID);
  }

  /** Returns true if field sentEmailDate is set (has been asigned a value) and false otherwise */
  public boolean isSetSentEmailDate() {
    return __isset_bit_vector.get(__SENTEMAILDATE_ISSET_ID);
  }

  public void setSentEmailDateIsSet(boolean value) {
    __isset_bit_vector.set(__SENTEMAILDATE_ISSET_ID, value);
  }

  public int getSentEmailCount() {
    return this.sentEmailCount;
  }

  public void setSentEmailCount(int sentEmailCount) {
    this.sentEmailCount = sentEmailCount;
    setSentEmailCountIsSet(true);
  }

  public void unsetSentEmailCount() {
    __isset_bit_vector.clear(__SENTEMAILCOUNT_ISSET_ID);
  }

  /** Returns true if field sentEmailCount is set (has been asigned a value) and false otherwise */
  public boolean isSetSentEmailCount() {
    return __isset_bit_vector.get(__SENTEMAILCOUNT_ISSET_ID);
  }

  public void setSentEmailCountIsSet(boolean value) {
    __isset_bit_vector.set(__SENTEMAILCOUNT_ISSET_ID, value);
  }

  public int getDailyEmailLimit() {
    return this.dailyEmailLimit;
  }

  public void setDailyEmailLimit(int dailyEmailLimit) {
    this.dailyEmailLimit = dailyEmailLimit;
    setDailyEmailLimitIsSet(true);
  }

  public void unsetDailyEmailLimit() {
    __isset_bit_vector.clear(__DAILYEMAILLIMIT_ISSET_ID);
  }

  /** Returns true if field dailyEmailLimit is set (has been asigned a value) and false otherwise */
  public boolean isSetDailyEmailLimit() {
    return __isset_bit_vector.get(__DAILYEMAILLIMIT_ISSET_ID);
  }

  public void setDailyEmailLimitIsSet(boolean value) {
    __isset_bit_vector.set(__DAILYEMAILLIMIT_ISSET_ID, value);
  }

  public long getEmailOptOutDate() {
    return this.emailOptOutDate;
  }

  public void setEmailOptOutDate(long emailOptOutDate) {
    this.emailOptOutDate = emailOptOutDate;
    setEmailOptOutDateIsSet(true);
  }

  public void unsetEmailOptOutDate() {
    __isset_bit_vector.clear(__EMAILOPTOUTDATE_ISSET_ID);
  }

  /** Returns true if field emailOptOutDate is set (has been asigned a value) and false otherwise */
  public boolean isSetEmailOptOutDate() {
    return __isset_bit_vector.get(__EMAILOPTOUTDATE_ISSET_ID);
  }

  public void setEmailOptOutDateIsSet(boolean value) {
    __isset_bit_vector.set(__EMAILOPTOUTDATE_ISSET_ID, value);
  }

  public long getPartnerEmailOptInDate() {
    return this.partnerEmailOptInDate;
  }

  public void setPartnerEmailOptInDate(long partnerEmailOptInDate) {
    this.partnerEmailOptInDate = partnerEmailOptInDate;
    setPartnerEmailOptInDateIsSet(true);
  }

  public void unsetPartnerEmailOptInDate() {
    __isset_bit_vector.clear(__PARTNEREMAILOPTINDATE_ISSET_ID);
  }

  /** Returns true if field partnerEmailOptInDate is set (has been asigned a value) and false otherwise */
  public boolean isSetPartnerEmailOptInDate() {
    return __isset_bit_vector.get(__PARTNEREMAILOPTINDATE_ISSET_ID);
  }

  public void setPartnerEmailOptInDateIsSet(boolean value) {
    __isset_bit_vector.set(__PARTNEREMAILOPTINDATE_ISSET_ID, value);
  }

  public String getPreferredLanguage() {
    return this.preferredLanguage;
  }

  public void setPreferredLanguage(String preferredLanguage) {
    this.preferredLanguage = preferredLanguage;
  }

  public void unsetPreferredLanguage() {
    this.preferredLanguage = null;
  }

  /** Returns true if field preferredLanguage is set (has been asigned a value) and false otherwise */
  public boolean isSetPreferredLanguage() {
    return this.preferredLanguage != null;
  }

  public void setPreferredLanguageIsSet(boolean value) {
    if (!value) {
      this.preferredLanguage = null;
    }
  }

  public String getPreferredCountry() {
    return this.preferredCountry;
  }

  public void setPreferredCountry(String preferredCountry) {
    this.preferredCountry = preferredCountry;
  }

  public void unsetPreferredCountry() {
    this.preferredCountry = null;
  }

  /** Returns true if field preferredCountry is set (has been asigned a value) and false otherwise */
  public boolean isSetPreferredCountry() {
    return this.preferredCountry != null;
  }

  public void setPreferredCountryIsSet(boolean value) {
    if (!value) {
      this.preferredCountry = null;
    }
  }

  public boolean isClipFullPage() {
    return this.clipFullPage;
  }

  public void setClipFullPage(boolean clipFullPage) {
    this.clipFullPage = clipFullPage;
    setClipFullPageIsSet(true);
  }

  public void unsetClipFullPage() {
    __isset_bit_vector.clear(__CLIPFULLPAGE_ISSET_ID);
  }

  /** Returns true if field clipFullPage is set (has been asigned a value) and false otherwise */
  public boolean isSetClipFullPage() {
    return __isset_bit_vector.get(__CLIPFULLPAGE_ISSET_ID);
  }

  public void setClipFullPageIsSet(boolean value) {
    __isset_bit_vector.set(__CLIPFULLPAGE_ISSET_ID, value);
  }

  public String getTwitterUserName() {
    return this.twitterUserName;
  }

  public void setTwitterUserName(String twitterUserName) {
    this.twitterUserName = twitterUserName;
  }

  public void unsetTwitterUserName() {
    this.twitterUserName = null;
  }

  /** Returns true if field twitterUserName is set (has been asigned a value) and false otherwise */
  public boolean isSetTwitterUserName() {
    return this.twitterUserName != null;
  }

  public void setTwitterUserNameIsSet(boolean value) {
    if (!value) {
      this.twitterUserName = null;
    }
  }

  public String getTwitterId() {
    return this.twitterId;
  }

  public void setTwitterId(String twitterId) {
    this.twitterId = twitterId;
  }

  public void unsetTwitterId() {
    this.twitterId = null;
  }

  /** Returns true if field twitterId is set (has been asigned a value) and false otherwise */
  public boolean isSetTwitterId() {
    return this.twitterId != null;
  }

  public void setTwitterIdIsSet(boolean value) {
    if (!value) {
      this.twitterId = null;
    }
  }

  public String getGroupName() {
    return this.groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public void unsetGroupName() {
    this.groupName = null;
  }

  /** Returns true if field groupName is set (has been asigned a value) and false otherwise */
  public boolean isSetGroupName() {
    return this.groupName != null;
  }

  public void setGroupNameIsSet(boolean value) {
    if (!value) {
      this.groupName = null;
    }
  }

  public String getRecognitionLanguage() {
    return this.recognitionLanguage;
  }

  public void setRecognitionLanguage(String recognitionLanguage) {
    this.recognitionLanguage = recognitionLanguage;
  }

  public void unsetRecognitionLanguage() {
    this.recognitionLanguage = null;
  }

  /** Returns true if field recognitionLanguage is set (has been asigned a value) and false otherwise */
  public boolean isSetRecognitionLanguage() {
    return this.recognitionLanguage != null;
  }

  public void setRecognitionLanguageIsSet(boolean value) {
    if (!value) {
      this.recognitionLanguage = null;
    }
  }

  public long getCustomerProfileId() {
    return this.customerProfileId;
  }

  public void setCustomerProfileId(long customerProfileId) {
    this.customerProfileId = customerProfileId;
    setCustomerProfileIdIsSet(true);
  }

  public void unsetCustomerProfileId() {
    __isset_bit_vector.clear(__CUSTOMERPROFILEID_ISSET_ID);
  }

  /** Returns true if field customerProfileId is set (has been asigned a value) and false otherwise */
  public boolean isSetCustomerProfileId() {
    return __isset_bit_vector.get(__CUSTOMERPROFILEID_ISSET_ID);
  }

  public void setCustomerProfileIdIsSet(boolean value) {
    __isset_bit_vector.set(__CUSTOMERPROFILEID_ISSET_ID, value);
  }

  public String getReferralProof() {
    return this.referralProof;
  }

  public void setReferralProof(String referralProof) {
    this.referralProof = referralProof;
  }

  public void unsetReferralProof() {
    this.referralProof = null;
  }

  /** Returns true if field referralProof is set (has been asigned a value) and false otherwise */
  public boolean isSetReferralProof() {
    return this.referralProof != null;
  }

  public void setReferralProofIsSet(boolean value) {
    if (!value) {
      this.referralProof = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case DEFAULT_LOCATION_NAME:
      if (value == null) {
        unsetDefaultLocationName();
      } else {
        setDefaultLocationName((String)value);
      }
      break;

    case DEFAULT_LATITUDE:
      if (value == null) {
        unsetDefaultLatitude();
      } else {
        setDefaultLatitude((Double)value);
      }
      break;

    case DEFAULT_LONGITUDE:
      if (value == null) {
        unsetDefaultLongitude();
      } else {
        setDefaultLongitude((Double)value);
      }
      break;

    case PREACTIVATION:
      if (value == null) {
        unsetPreactivation();
      } else {
        setPreactivation((Boolean)value);
      }
      break;

    case VIEWED_PROMOTIONS:
      if (value == null) {
        unsetViewedPromotions();
      } else {
        setViewedPromotions((List<String>)value);
      }
      break;

    case INCOMING_EMAIL_ADDRESS:
      if (value == null) {
        unsetIncomingEmailAddress();
      } else {
        setIncomingEmailAddress((String)value);
      }
      break;

    case RECENT_MAILED_ADDRESSES:
      if (value == null) {
        unsetRecentMailedAddresses();
      } else {
        setRecentMailedAddresses((List<String>)value);
      }
      break;

    case COMMENTS:
      if (value == null) {
        unsetComments();
      } else {
        setComments((String)value);
      }
      break;

    case DATE_AGREED_TO_TERMS_OF_SERVICE:
      if (value == null) {
        unsetDateAgreedToTermsOfService();
      } else {
        setDateAgreedToTermsOfService((Long)value);
      }
      break;

    case MAX_REFERRALS:
      if (value == null) {
        unsetMaxReferrals();
      } else {
        setMaxReferrals((Integer)value);
      }
      break;

    case REFERRAL_COUNT:
      if (value == null) {
        unsetReferralCount();
      } else {
        setReferralCount((Integer)value);
      }
      break;

    case REFERER_CODE:
      if (value == null) {
        unsetRefererCode();
      } else {
        setRefererCode((String)value);
      }
      break;

    case SENT_EMAIL_DATE:
      if (value == null) {
        unsetSentEmailDate();
      } else {
        setSentEmailDate((Long)value);
      }
      break;

    case SENT_EMAIL_COUNT:
      if (value == null) {
        unsetSentEmailCount();
      } else {
        setSentEmailCount((Integer)value);
      }
      break;

    case DAILY_EMAIL_LIMIT:
      if (value == null) {
        unsetDailyEmailLimit();
      } else {
        setDailyEmailLimit((Integer)value);
      }
      break;

    case EMAIL_OPT_OUT_DATE:
      if (value == null) {
        unsetEmailOptOutDate();
      } else {
        setEmailOptOutDate((Long)value);
      }
      break;

    case PARTNER_EMAIL_OPT_IN_DATE:
      if (value == null) {
        unsetPartnerEmailOptInDate();
      } else {
        setPartnerEmailOptInDate((Long)value);
      }
      break;

    case PREFERRED_LANGUAGE:
      if (value == null) {
        unsetPreferredLanguage();
      } else {
        setPreferredLanguage((String)value);
      }
      break;

    case PREFERRED_COUNTRY:
      if (value == null) {
        unsetPreferredCountry();
      } else {
        setPreferredCountry((String)value);
      }
      break;

    case CLIP_FULL_PAGE:
      if (value == null) {
        unsetClipFullPage();
      } else {
        setClipFullPage((Boolean)value);
      }
      break;

    case TWITTER_USER_NAME:
      if (value == null) {
        unsetTwitterUserName();
      } else {
        setTwitterUserName((String)value);
      }
      break;

    case TWITTER_ID:
      if (value == null) {
        unsetTwitterId();
      } else {
        setTwitterId((String)value);
      }
      break;

    case GROUP_NAME:
      if (value == null) {
        unsetGroupName();
      } else {
        setGroupName((String)value);
      }
      break;

    case RECOGNITION_LANGUAGE:
      if (value == null) {
        unsetRecognitionLanguage();
      } else {
        setRecognitionLanguage((String)value);
      }
      break;

    case CUSTOMER_PROFILE_ID:
      if (value == null) {
        unsetCustomerProfileId();
      } else {
        setCustomerProfileId((Long)value);
      }
      break;

    case REFERRAL_PROOF:
      if (value == null) {
        unsetReferralProof();
      } else {
        setReferralProof((String)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case DEFAULT_LOCATION_NAME:
      return getDefaultLocationName();

    case DEFAULT_LATITUDE:
      return new Double(getDefaultLatitude());

    case DEFAULT_LONGITUDE:
      return new Double(getDefaultLongitude());

    case PREACTIVATION:
      return new Boolean(isPreactivation());

    case VIEWED_PROMOTIONS:
      return getViewedPromotions();

    case INCOMING_EMAIL_ADDRESS:
      return getIncomingEmailAddress();

    case RECENT_MAILED_ADDRESSES:
      return getRecentMailedAddresses();

    case COMMENTS:
      return getComments();

    case DATE_AGREED_TO_TERMS_OF_SERVICE:
      return new Long(getDateAgreedToTermsOfService());

    case MAX_REFERRALS:
      return new Integer(getMaxReferrals());

    case REFERRAL_COUNT:
      return new Integer(getReferralCount());

    case REFERER_CODE:
      return getRefererCode();

    case SENT_EMAIL_DATE:
      return new Long(getSentEmailDate());

    case SENT_EMAIL_COUNT:
      return new Integer(getSentEmailCount());

    case DAILY_EMAIL_LIMIT:
      return new Integer(getDailyEmailLimit());

    case EMAIL_OPT_OUT_DATE:
      return new Long(getEmailOptOutDate());

    case PARTNER_EMAIL_OPT_IN_DATE:
      return new Long(getPartnerEmailOptInDate());

    case PREFERRED_LANGUAGE:
      return getPreferredLanguage();

    case PREFERRED_COUNTRY:
      return getPreferredCountry();

    case CLIP_FULL_PAGE:
      return new Boolean(isClipFullPage());

    case TWITTER_USER_NAME:
      return getTwitterUserName();

    case TWITTER_ID:
      return getTwitterId();

    case GROUP_NAME:
      return getGroupName();

    case RECOGNITION_LANGUAGE:
      return getRecognitionLanguage();

    case CUSTOMER_PROFILE_ID:
      return new Long(getCustomerProfileId());

    case REFERRAL_PROOF:
      return getReferralProof();

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case DEFAULT_LOCATION_NAME:
      return isSetDefaultLocationName();
    case DEFAULT_LATITUDE:
      return isSetDefaultLatitude();
    case DEFAULT_LONGITUDE:
      return isSetDefaultLongitude();
    case PREACTIVATION:
      return isSetPreactivation();
    case VIEWED_PROMOTIONS:
      return isSetViewedPromotions();
    case INCOMING_EMAIL_ADDRESS:
      return isSetIncomingEmailAddress();
    case RECENT_MAILED_ADDRESSES:
      return isSetRecentMailedAddresses();
    case COMMENTS:
      return isSetComments();
    case DATE_AGREED_TO_TERMS_OF_SERVICE:
      return isSetDateAgreedToTermsOfService();
    case MAX_REFERRALS:
      return isSetMaxReferrals();
    case REFERRAL_COUNT:
      return isSetReferralCount();
    case REFERER_CODE:
      return isSetRefererCode();
    case SENT_EMAIL_DATE:
      return isSetSentEmailDate();
    case SENT_EMAIL_COUNT:
      return isSetSentEmailCount();
    case DAILY_EMAIL_LIMIT:
      return isSetDailyEmailLimit();
    case EMAIL_OPT_OUT_DATE:
      return isSetEmailOptOutDate();
    case PARTNER_EMAIL_OPT_IN_DATE:
      return isSetPartnerEmailOptInDate();
    case PREFERRED_LANGUAGE:
      return isSetPreferredLanguage();
    case PREFERRED_COUNTRY:
      return isSetPreferredCountry();
    case CLIP_FULL_PAGE:
      return isSetClipFullPage();
    case TWITTER_USER_NAME:
      return isSetTwitterUserName();
    case TWITTER_ID:
      return isSetTwitterId();
    case GROUP_NAME:
      return isSetGroupName();
    case RECOGNITION_LANGUAGE:
      return isSetRecognitionLanguage();
    case CUSTOMER_PROFILE_ID:
      return isSetCustomerProfileId();
    case REFERRAL_PROOF:
      return isSetReferralProof();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof UserAttributes)
      return this.equals((UserAttributes)that);
    return false;
  }

  public boolean equals(UserAttributes that) {
    if (that == null)
      return false;

    boolean this_present_defaultLocationName = true && this.isSetDefaultLocationName();
    boolean that_present_defaultLocationName = true && that.isSetDefaultLocationName();
    if (this_present_defaultLocationName || that_present_defaultLocationName) {
      if (!(this_present_defaultLocationName && that_present_defaultLocationName))
        return false;
      if (!this.defaultLocationName.equals(that.defaultLocationName))
        return false;
    }

    boolean this_present_defaultLatitude = true && this.isSetDefaultLatitude();
    boolean that_present_defaultLatitude = true && that.isSetDefaultLatitude();
    if (this_present_defaultLatitude || that_present_defaultLatitude) {
      if (!(this_present_defaultLatitude && that_present_defaultLatitude))
        return false;
      if (this.defaultLatitude != that.defaultLatitude)
        return false;
    }

    boolean this_present_defaultLongitude = true && this.isSetDefaultLongitude();
    boolean that_present_defaultLongitude = true && that.isSetDefaultLongitude();
    if (this_present_defaultLongitude || that_present_defaultLongitude) {
      if (!(this_present_defaultLongitude && that_present_defaultLongitude))
        return false;
      if (this.defaultLongitude != that.defaultLongitude)
        return false;
    }

    boolean this_present_preactivation = true && this.isSetPreactivation();
    boolean that_present_preactivation = true && that.isSetPreactivation();
    if (this_present_preactivation || that_present_preactivation) {
      if (!(this_present_preactivation && that_present_preactivation))
        return false;
      if (this.preactivation != that.preactivation)
        return false;
    }

    boolean this_present_viewedPromotions = true && this.isSetViewedPromotions();
    boolean that_present_viewedPromotions = true && that.isSetViewedPromotions();
    if (this_present_viewedPromotions || that_present_viewedPromotions) {
      if (!(this_present_viewedPromotions && that_present_viewedPromotions))
        return false;
      if (!this.viewedPromotions.equals(that.viewedPromotions))
        return false;
    }

    boolean this_present_incomingEmailAddress = true && this.isSetIncomingEmailAddress();
    boolean that_present_incomingEmailAddress = true && that.isSetIncomingEmailAddress();
    if (this_present_incomingEmailAddress || that_present_incomingEmailAddress) {
      if (!(this_present_incomingEmailAddress && that_present_incomingEmailAddress))
        return false;
      if (!this.incomingEmailAddress.equals(that.incomingEmailAddress))
        return false;
    }

    boolean this_present_recentMailedAddresses = true && this.isSetRecentMailedAddresses();
    boolean that_present_recentMailedAddresses = true && that.isSetRecentMailedAddresses();
    if (this_present_recentMailedAddresses || that_present_recentMailedAddresses) {
      if (!(this_present_recentMailedAddresses && that_present_recentMailedAddresses))
        return false;
      if (!this.recentMailedAddresses.equals(that.recentMailedAddresses))
        return false;
    }

    boolean this_present_comments = true && this.isSetComments();
    boolean that_present_comments = true && that.isSetComments();
    if (this_present_comments || that_present_comments) {
      if (!(this_present_comments && that_present_comments))
        return false;
      if (!this.comments.equals(that.comments))
        return false;
    }

    boolean this_present_dateAgreedToTermsOfService = true && this.isSetDateAgreedToTermsOfService();
    boolean that_present_dateAgreedToTermsOfService = true && that.isSetDateAgreedToTermsOfService();
    if (this_present_dateAgreedToTermsOfService || that_present_dateAgreedToTermsOfService) {
      if (!(this_present_dateAgreedToTermsOfService && that_present_dateAgreedToTermsOfService))
        return false;
      if (this.dateAgreedToTermsOfService != that.dateAgreedToTermsOfService)
        return false;
    }

    boolean this_present_maxReferrals = true && this.isSetMaxReferrals();
    boolean that_present_maxReferrals = true && that.isSetMaxReferrals();
    if (this_present_maxReferrals || that_present_maxReferrals) {
      if (!(this_present_maxReferrals && that_present_maxReferrals))
        return false;
      if (this.maxReferrals != that.maxReferrals)
        return false;
    }

    boolean this_present_referralCount = true && this.isSetReferralCount();
    boolean that_present_referralCount = true && that.isSetReferralCount();
    if (this_present_referralCount || that_present_referralCount) {
      if (!(this_present_referralCount && that_present_referralCount))
        return false;
      if (this.referralCount != that.referralCount)
        return false;
    }

    boolean this_present_refererCode = true && this.isSetRefererCode();
    boolean that_present_refererCode = true && that.isSetRefererCode();
    if (this_present_refererCode || that_present_refererCode) {
      if (!(this_present_refererCode && that_present_refererCode))
        return false;
      if (!this.refererCode.equals(that.refererCode))
        return false;
    }

    boolean this_present_sentEmailDate = true && this.isSetSentEmailDate();
    boolean that_present_sentEmailDate = true && that.isSetSentEmailDate();
    if (this_present_sentEmailDate || that_present_sentEmailDate) {
      if (!(this_present_sentEmailDate && that_present_sentEmailDate))
        return false;
      if (this.sentEmailDate != that.sentEmailDate)
        return false;
    }

    boolean this_present_sentEmailCount = true && this.isSetSentEmailCount();
    boolean that_present_sentEmailCount = true && that.isSetSentEmailCount();
    if (this_present_sentEmailCount || that_present_sentEmailCount) {
      if (!(this_present_sentEmailCount && that_present_sentEmailCount))
        return false;
      if (this.sentEmailCount != that.sentEmailCount)
        return false;
    }

    boolean this_present_dailyEmailLimit = true && this.isSetDailyEmailLimit();
    boolean that_present_dailyEmailLimit = true && that.isSetDailyEmailLimit();
    if (this_present_dailyEmailLimit || that_present_dailyEmailLimit) {
      if (!(this_present_dailyEmailLimit && that_present_dailyEmailLimit))
        return false;
      if (this.dailyEmailLimit != that.dailyEmailLimit)
        return false;
    }

    boolean this_present_emailOptOutDate = true && this.isSetEmailOptOutDate();
    boolean that_present_emailOptOutDate = true && that.isSetEmailOptOutDate();
    if (this_present_emailOptOutDate || that_present_emailOptOutDate) {
      if (!(this_present_emailOptOutDate && that_present_emailOptOutDate))
        return false;
      if (this.emailOptOutDate != that.emailOptOutDate)
        return false;
    }

    boolean this_present_partnerEmailOptInDate = true && this.isSetPartnerEmailOptInDate();
    boolean that_present_partnerEmailOptInDate = true && that.isSetPartnerEmailOptInDate();
    if (this_present_partnerEmailOptInDate || that_present_partnerEmailOptInDate) {
      if (!(this_present_partnerEmailOptInDate && that_present_partnerEmailOptInDate))
        return false;
      if (this.partnerEmailOptInDate != that.partnerEmailOptInDate)
        return false;
    }

    boolean this_present_preferredLanguage = true && this.isSetPreferredLanguage();
    boolean that_present_preferredLanguage = true && that.isSetPreferredLanguage();
    if (this_present_preferredLanguage || that_present_preferredLanguage) {
      if (!(this_present_preferredLanguage && that_present_preferredLanguage))
        return false;
      if (!this.preferredLanguage.equals(that.preferredLanguage))
        return false;
    }

    boolean this_present_preferredCountry = true && this.isSetPreferredCountry();
    boolean that_present_preferredCountry = true && that.isSetPreferredCountry();
    if (this_present_preferredCountry || that_present_preferredCountry) {
      if (!(this_present_preferredCountry && that_present_preferredCountry))
        return false;
      if (!this.preferredCountry.equals(that.preferredCountry))
        return false;
    }

    boolean this_present_clipFullPage = true && this.isSetClipFullPage();
    boolean that_present_clipFullPage = true && that.isSetClipFullPage();
    if (this_present_clipFullPage || that_present_clipFullPage) {
      if (!(this_present_clipFullPage && that_present_clipFullPage))
        return false;
      if (this.clipFullPage != that.clipFullPage)
        return false;
    }

    boolean this_present_twitterUserName = true && this.isSetTwitterUserName();
    boolean that_present_twitterUserName = true && that.isSetTwitterUserName();
    if (this_present_twitterUserName || that_present_twitterUserName) {
      if (!(this_present_twitterUserName && that_present_twitterUserName))
        return false;
      if (!this.twitterUserName.equals(that.twitterUserName))
        return false;
    }

    boolean this_present_twitterId = true && this.isSetTwitterId();
    boolean that_present_twitterId = true && that.isSetTwitterId();
    if (this_present_twitterId || that_present_twitterId) {
      if (!(this_present_twitterId && that_present_twitterId))
        return false;
      if (!this.twitterId.equals(that.twitterId))
        return false;
    }

    boolean this_present_groupName = true && this.isSetGroupName();
    boolean that_present_groupName = true && that.isSetGroupName();
    if (this_present_groupName || that_present_groupName) {
      if (!(this_present_groupName && that_present_groupName))
        return false;
      if (!this.groupName.equals(that.groupName))
        return false;
    }

    boolean this_present_recognitionLanguage = true && this.isSetRecognitionLanguage();
    boolean that_present_recognitionLanguage = true && that.isSetRecognitionLanguage();
    if (this_present_recognitionLanguage || that_present_recognitionLanguage) {
      if (!(this_present_recognitionLanguage && that_present_recognitionLanguage))
        return false;
      if (!this.recognitionLanguage.equals(that.recognitionLanguage))
        return false;
    }

    boolean this_present_customerProfileId = true && this.isSetCustomerProfileId();
    boolean that_present_customerProfileId = true && that.isSetCustomerProfileId();
    if (this_present_customerProfileId || that_present_customerProfileId) {
      if (!(this_present_customerProfileId && that_present_customerProfileId))
        return false;
      if (this.customerProfileId != that.customerProfileId)
        return false;
    }

    boolean this_present_referralProof = true && this.isSetReferralProof();
    boolean that_present_referralProof = true && that.isSetReferralProof();
    if (this_present_referralProof || that_present_referralProof) {
      if (!(this_present_referralProof && that_present_referralProof))
        return false;
      if (!this.referralProof.equals(that.referralProof))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(UserAttributes other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    UserAttributes typedOther = (UserAttributes)other;

    lastComparison = Boolean.valueOf(isSetDefaultLocationName()).compareTo(isSetDefaultLocationName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(defaultLocationName, typedOther.defaultLocationName);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDefaultLatitude()).compareTo(isSetDefaultLatitude());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(defaultLatitude, typedOther.defaultLatitude);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDefaultLongitude()).compareTo(isSetDefaultLongitude());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(defaultLongitude, typedOther.defaultLongitude);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPreactivation()).compareTo(isSetPreactivation());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(preactivation, typedOther.preactivation);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetViewedPromotions()).compareTo(isSetViewedPromotions());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(viewedPromotions, typedOther.viewedPromotions);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetIncomingEmailAddress()).compareTo(isSetIncomingEmailAddress());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(incomingEmailAddress, typedOther.incomingEmailAddress);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetRecentMailedAddresses()).compareTo(isSetRecentMailedAddresses());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(recentMailedAddresses, typedOther.recentMailedAddresses);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetComments()).compareTo(isSetComments());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(comments, typedOther.comments);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDateAgreedToTermsOfService()).compareTo(isSetDateAgreedToTermsOfService());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(dateAgreedToTermsOfService, typedOther.dateAgreedToTermsOfService);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetMaxReferrals()).compareTo(isSetMaxReferrals());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(maxReferrals, typedOther.maxReferrals);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetReferralCount()).compareTo(isSetReferralCount());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(referralCount, typedOther.referralCount);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetRefererCode()).compareTo(isSetRefererCode());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(refererCode, typedOther.refererCode);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetSentEmailDate()).compareTo(isSetSentEmailDate());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(sentEmailDate, typedOther.sentEmailDate);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetSentEmailCount()).compareTo(isSetSentEmailCount());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(sentEmailCount, typedOther.sentEmailCount);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDailyEmailLimit()).compareTo(isSetDailyEmailLimit());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(dailyEmailLimit, typedOther.dailyEmailLimit);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetEmailOptOutDate()).compareTo(isSetEmailOptOutDate());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(emailOptOutDate, typedOther.emailOptOutDate);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPartnerEmailOptInDate()).compareTo(isSetPartnerEmailOptInDate());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(partnerEmailOptInDate, typedOther.partnerEmailOptInDate);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPreferredLanguage()).compareTo(isSetPreferredLanguage());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(preferredLanguage, typedOther.preferredLanguage);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPreferredCountry()).compareTo(isSetPreferredCountry());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(preferredCountry, typedOther.preferredCountry);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetClipFullPage()).compareTo(isSetClipFullPage());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(clipFullPage, typedOther.clipFullPage);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTwitterUserName()).compareTo(isSetTwitterUserName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(twitterUserName, typedOther.twitterUserName);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTwitterId()).compareTo(isSetTwitterId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(twitterId, typedOther.twitterId);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetGroupName()).compareTo(isSetGroupName());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(groupName, typedOther.groupName);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetRecognitionLanguage()).compareTo(isSetRecognitionLanguage());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(recognitionLanguage, typedOther.recognitionLanguage);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetCustomerProfileId()).compareTo(isSetCustomerProfileId());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(customerProfileId, typedOther.customerProfileId);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetReferralProof()).compareTo(isSetReferralProof());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(referralProof, typedOther.referralProof);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case DEFAULT_LOCATION_NAME:
            if (field.type == TType.STRING) {
              this.defaultLocationName = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DEFAULT_LATITUDE:
            if (field.type == TType.DOUBLE) {
              this.defaultLatitude = iprot.readDouble();
              setDefaultLatitudeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DEFAULT_LONGITUDE:
            if (field.type == TType.DOUBLE) {
              this.defaultLongitude = iprot.readDouble();
              setDefaultLongitudeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREACTIVATION:
            if (field.type == TType.BOOL) {
              this.preactivation = iprot.readBool();
              setPreactivationIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case VIEWED_PROMOTIONS:
            if (field.type == TType.LIST) {
              {
                TList _list0 = iprot.readListBegin();
                this.viewedPromotions = new ArrayList<String>(_list0.size);
                for (int _i1 = 0; _i1 < _list0.size; ++_i1)
                {
                  String _elem2;
                  _elem2 = iprot.readString();
                  this.viewedPromotions.add(_elem2);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case INCOMING_EMAIL_ADDRESS:
            if (field.type == TType.STRING) {
              this.incomingEmailAddress = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case RECENT_MAILED_ADDRESSES:
            if (field.type == TType.LIST) {
              {
                TList _list3 = iprot.readListBegin();
                this.recentMailedAddresses = new ArrayList<String>(_list3.size);
                for (int _i4 = 0; _i4 < _list3.size; ++_i4)
                {
                  String _elem5;
                  _elem5 = iprot.readString();
                  this.recentMailedAddresses.add(_elem5);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case COMMENTS:
            if (field.type == TType.STRING) {
              this.comments = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DATE_AGREED_TO_TERMS_OF_SERVICE:
            if (field.type == TType.I64) {
              this.dateAgreedToTermsOfService = iprot.readI64();
              setDateAgreedToTermsOfServiceIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case MAX_REFERRALS:
            if (field.type == TType.I32) {
              this.maxReferrals = iprot.readI32();
              setMaxReferralsIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case REFERRAL_COUNT:
            if (field.type == TType.I32) {
              this.referralCount = iprot.readI32();
              setReferralCountIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case REFERER_CODE:
            if (field.type == TType.STRING) {
              this.refererCode = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case SENT_EMAIL_DATE:
            if (field.type == TType.I64) {
              this.sentEmailDate = iprot.readI64();
              setSentEmailDateIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case SENT_EMAIL_COUNT:
            if (field.type == TType.I32) {
              this.sentEmailCount = iprot.readI32();
              setSentEmailCountIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DAILY_EMAIL_LIMIT:
            if (field.type == TType.I32) {
              this.dailyEmailLimit = iprot.readI32();
              setDailyEmailLimitIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case EMAIL_OPT_OUT_DATE:
            if (field.type == TType.I64) {
              this.emailOptOutDate = iprot.readI64();
              setEmailOptOutDateIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PARTNER_EMAIL_OPT_IN_DATE:
            if (field.type == TType.I64) {
              this.partnerEmailOptInDate = iprot.readI64();
              setPartnerEmailOptInDateIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREFERRED_LANGUAGE:
            if (field.type == TType.STRING) {
              this.preferredLanguage = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREFERRED_COUNTRY:
            if (field.type == TType.STRING) {
              this.preferredCountry = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CLIP_FULL_PAGE:
            if (field.type == TType.BOOL) {
              this.clipFullPage = iprot.readBool();
              setClipFullPageIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TWITTER_USER_NAME:
            if (field.type == TType.STRING) {
              this.twitterUserName = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TWITTER_ID:
            if (field.type == TType.STRING) {
              this.twitterId = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case GROUP_NAME:
            if (field.type == TType.STRING) {
              this.groupName = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case RECOGNITION_LANGUAGE:
            if (field.type == TType.STRING) {
              this.recognitionLanguage = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CUSTOMER_PROFILE_ID:
            if (field.type == TType.I64) {
              this.customerProfileId = iprot.readI64();
              setCustomerProfileIdIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case REFERRAL_PROOF:
            if (field.type == TType.STRING) {
              this.referralProof = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (this.defaultLocationName != null) {
      if (isSetDefaultLocationName()) {
        oprot.writeFieldBegin(DEFAULT_LOCATION_NAME_FIELD_DESC);
        oprot.writeString(this.defaultLocationName);
        oprot.writeFieldEnd();
      }
    }
    if (isSetDefaultLatitude()) {
      oprot.writeFieldBegin(DEFAULT_LATITUDE_FIELD_DESC);
      oprot.writeDouble(this.defaultLatitude);
      oprot.writeFieldEnd();
    }
    if (isSetDefaultLongitude()) {
      oprot.writeFieldBegin(DEFAULT_LONGITUDE_FIELD_DESC);
      oprot.writeDouble(this.defaultLongitude);
      oprot.writeFieldEnd();
    }
    if (isSetPreactivation()) {
      oprot.writeFieldBegin(PREACTIVATION_FIELD_DESC);
      oprot.writeBool(this.preactivation);
      oprot.writeFieldEnd();
    }
    if (this.viewedPromotions != null) {
      if (isSetViewedPromotions()) {
        oprot.writeFieldBegin(VIEWED_PROMOTIONS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.viewedPromotions.size()));
          for (String _iter6 : this.viewedPromotions)
          {
            oprot.writeString(_iter6);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.incomingEmailAddress != null) {
      if (isSetIncomingEmailAddress()) {
        oprot.writeFieldBegin(INCOMING_EMAIL_ADDRESS_FIELD_DESC);
        oprot.writeString(this.incomingEmailAddress);
        oprot.writeFieldEnd();
      }
    }
    if (this.recentMailedAddresses != null) {
      if (isSetRecentMailedAddresses()) {
        oprot.writeFieldBegin(RECENT_MAILED_ADDRESSES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.recentMailedAddresses.size()));
          for (String _iter7 : this.recentMailedAddresses)
          {
            oprot.writeString(_iter7);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.comments != null) {
      if (isSetComments()) {
        oprot.writeFieldBegin(COMMENTS_FIELD_DESC);
        oprot.writeString(this.comments);
        oprot.writeFieldEnd();
      }
    }
    if (isSetDateAgreedToTermsOfService()) {
      oprot.writeFieldBegin(DATE_AGREED_TO_TERMS_OF_SERVICE_FIELD_DESC);
      oprot.writeI64(this.dateAgreedToTermsOfService);
      oprot.writeFieldEnd();
    }
    if (isSetMaxReferrals()) {
      oprot.writeFieldBegin(MAX_REFERRALS_FIELD_DESC);
      oprot.writeI32(this.maxReferrals);
      oprot.writeFieldEnd();
    }
    if (isSetReferralCount()) {
      oprot.writeFieldBegin(REFERRAL_COUNT_FIELD_DESC);
      oprot.writeI32(this.referralCount);
      oprot.writeFieldEnd();
    }
    if (this.refererCode != null) {
      if (isSetRefererCode()) {
        oprot.writeFieldBegin(REFERER_CODE_FIELD_DESC);
        oprot.writeString(this.refererCode);
        oprot.writeFieldEnd();
      }
    }
    if (isSetSentEmailDate()) {
      oprot.writeFieldBegin(SENT_EMAIL_DATE_FIELD_DESC);
      oprot.writeI64(this.sentEmailDate);
      oprot.writeFieldEnd();
    }
    if (isSetSentEmailCount()) {
      oprot.writeFieldBegin(SENT_EMAIL_COUNT_FIELD_DESC);
      oprot.writeI32(this.sentEmailCount);
      oprot.writeFieldEnd();
    }
    if (isSetDailyEmailLimit()) {
      oprot.writeFieldBegin(DAILY_EMAIL_LIMIT_FIELD_DESC);
      oprot.writeI32(this.dailyEmailLimit);
      oprot.writeFieldEnd();
    }
    if (isSetEmailOptOutDate()) {
      oprot.writeFieldBegin(EMAIL_OPT_OUT_DATE_FIELD_DESC);
      oprot.writeI64(this.emailOptOutDate);
      oprot.writeFieldEnd();
    }
    if (isSetPartnerEmailOptInDate()) {
      oprot.writeFieldBegin(PARTNER_EMAIL_OPT_IN_DATE_FIELD_DESC);
      oprot.writeI64(this.partnerEmailOptInDate);
      oprot.writeFieldEnd();
    }
    if (this.preferredLanguage != null) {
      if (isSetPreferredLanguage()) {
        oprot.writeFieldBegin(PREFERRED_LANGUAGE_FIELD_DESC);
        oprot.writeString(this.preferredLanguage);
        oprot.writeFieldEnd();
      }
    }
    if (this.preferredCountry != null) {
      if (isSetPreferredCountry()) {
        oprot.writeFieldBegin(PREFERRED_COUNTRY_FIELD_DESC);
        oprot.writeString(this.preferredCountry);
        oprot.writeFieldEnd();
      }
    }
    if (isSetClipFullPage()) {
      oprot.writeFieldBegin(CLIP_FULL_PAGE_FIELD_DESC);
      oprot.writeBool(this.clipFullPage);
      oprot.writeFieldEnd();
    }
    if (this.twitterUserName != null) {
      if (isSetTwitterUserName()) {
        oprot.writeFieldBegin(TWITTER_USER_NAME_FIELD_DESC);
        oprot.writeString(this.twitterUserName);
        oprot.writeFieldEnd();
      }
    }
    if (this.twitterId != null) {
      if (isSetTwitterId()) {
        oprot.writeFieldBegin(TWITTER_ID_FIELD_DESC);
        oprot.writeString(this.twitterId);
        oprot.writeFieldEnd();
      }
    }
    if (this.groupName != null) {
      if (isSetGroupName()) {
        oprot.writeFieldBegin(GROUP_NAME_FIELD_DESC);
        oprot.writeString(this.groupName);
        oprot.writeFieldEnd();
      }
    }
    if (this.recognitionLanguage != null) {
      if (isSetRecognitionLanguage()) {
        oprot.writeFieldBegin(RECOGNITION_LANGUAGE_FIELD_DESC);
        oprot.writeString(this.recognitionLanguage);
        oprot.writeFieldEnd();
      }
    }
    if (isSetCustomerProfileId()) {
      oprot.writeFieldBegin(CUSTOMER_PROFILE_ID_FIELD_DESC);
      oprot.writeI64(this.customerProfileId);
      oprot.writeFieldEnd();
    }
    if (this.referralProof != null) {
      if (isSetReferralProof()) {
        oprot.writeFieldBegin(REFERRAL_PROOF_FIELD_DESC);
        oprot.writeString(this.referralProof);
        oprot.writeFieldEnd();
      }
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("UserAttributes(");
    boolean first = true;

    if (isSetDefaultLocationName()) {
      sb.append("defaultLocationName:");
      if (this.defaultLocationName == null) {
        sb.append("null");
      } else {
        sb.append(this.defaultLocationName);
      }
      first = false;
    }
    if (isSetDefaultLatitude()) {
      if (!first) sb.append(", ");
      sb.append("defaultLatitude:");
      sb.append(this.defaultLatitude);
      first = false;
    }
    if (isSetDefaultLongitude()) {
      if (!first) sb.append(", ");
      sb.append("defaultLongitude:");
      sb.append(this.defaultLongitude);
      first = false;
    }
    if (isSetPreactivation()) {
      if (!first) sb.append(", ");
      sb.append("preactivation:");
      sb.append(this.preactivation);
      first = false;
    }
    if (isSetViewedPromotions()) {
      if (!first) sb.append(", ");
      sb.append("viewedPromotions:");
      if (this.viewedPromotions == null) {
        sb.append("null");
      } else {
        sb.append(this.viewedPromotions);
      }
      first = false;
    }
    if (isSetIncomingEmailAddress()) {
      if (!first) sb.append(", ");
      sb.append("incomingEmailAddress:");
      if (this.incomingEmailAddress == null) {
        sb.append("null");
      } else {
        sb.append(this.incomingEmailAddress);
      }
      first = false;
    }
    if (isSetRecentMailedAddresses()) {
      if (!first) sb.append(", ");
      sb.append("recentMailedAddresses:");
      if (this.recentMailedAddresses == null) {
        sb.append("null");
      } else {
        sb.append(this.recentMailedAddresses);
      }
      first = false;
    }
    if (isSetComments()) {
      if (!first) sb.append(", ");
      sb.append("comments:");
      if (this.comments == null) {
        sb.append("null");
      } else {
        sb.append(this.comments);
      }
      first = false;
    }
    if (isSetDateAgreedToTermsOfService()) {
      if (!first) sb.append(", ");
      sb.append("dateAgreedToTermsOfService:");
      sb.append(this.dateAgreedToTermsOfService);
      first = false;
    }
    if (isSetMaxReferrals()) {
      if (!first) sb.append(", ");
      sb.append("maxReferrals:");
      sb.append(this.maxReferrals);
      first = false;
    }
    if (isSetReferralCount()) {
      if (!first) sb.append(", ");
      sb.append("referralCount:");
      sb.append(this.referralCount);
      first = false;
    }
    if (isSetRefererCode()) {
      if (!first) sb.append(", ");
      sb.append("refererCode:");
      if (this.refererCode == null) {
        sb.append("null");
      } else {
        sb.append(this.refererCode);
      }
      first = false;
    }
    if (isSetSentEmailDate()) {
      if (!first) sb.append(", ");
      sb.append("sentEmailDate:");
      sb.append(this.sentEmailDate);
      first = false;
    }
    if (isSetSentEmailCount()) {
      if (!first) sb.append(", ");
      sb.append("sentEmailCount:");
      sb.append(this.sentEmailCount);
      first = false;
    }
    if (isSetDailyEmailLimit()) {
      if (!first) sb.append(", ");
      sb.append("dailyEmailLimit:");
      sb.append(this.dailyEmailLimit);
      first = false;
    }
    if (isSetEmailOptOutDate()) {
      if (!first) sb.append(", ");
      sb.append("emailOptOutDate:");
      sb.append(this.emailOptOutDate);
      first = false;
    }
    if (isSetPartnerEmailOptInDate()) {
      if (!first) sb.append(", ");
      sb.append("partnerEmailOptInDate:");
      sb.append(this.partnerEmailOptInDate);
      first = false;
    }
    if (isSetPreferredLanguage()) {
      if (!first) sb.append(", ");
      sb.append("preferredLanguage:");
      if (this.preferredLanguage == null) {
        sb.append("null");
      } else {
        sb.append(this.preferredLanguage);
      }
      first = false;
    }
    if (isSetPreferredCountry()) {
      if (!first) sb.append(", ");
      sb.append("preferredCountry:");
      if (this.preferredCountry == null) {
        sb.append("null");
      } else {
        sb.append(this.preferredCountry);
      }
      first = false;
    }
    if (isSetClipFullPage()) {
      if (!first) sb.append(", ");
      sb.append("clipFullPage:");
      sb.append(this.clipFullPage);
      first = false;
    }
    if (isSetTwitterUserName()) {
      if (!first) sb.append(", ");
      sb.append("twitterUserName:");
      if (this.twitterUserName == null) {
        sb.append("null");
      } else {
        sb.append(this.twitterUserName);
      }
      first = false;
    }
    if (isSetTwitterId()) {
      if (!first) sb.append(", ");
      sb.append("twitterId:");
      if (this.twitterId == null) {
        sb.append("null");
      } else {
        sb.append(this.twitterId);
      }
      first = false;
    }
    if (isSetGroupName()) {
      if (!first) sb.append(", ");
      sb.append("groupName:");
      if (this.groupName == null) {
        sb.append("null");
      } else {
        sb.append(this.groupName);
      }
      first = false;
    }
    if (isSetRecognitionLanguage()) {
      if (!first) sb.append(", ");
      sb.append("recognitionLanguage:");
      if (this.recognitionLanguage == null) {
        sb.append("null");
      } else {
        sb.append(this.recognitionLanguage);
      }
      first = false;
    }
    if (isSetCustomerProfileId()) {
      if (!first) sb.append(", ");
      sb.append("customerProfileId:");
      sb.append(this.customerProfileId);
      first = false;
    }
    if (isSetReferralProof()) {
      if (!first) sb.append(", ");
      sb.append("referralProof:");
      if (this.referralProof == null) {
        sb.append("null");
      } else {
        sb.append(this.referralProof);
      }
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }

}

