/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.type;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 * Represents a single note in the user's account.
 * 
 * <dl>
 * <dt>guid</dt>
 *   <dd>The unique identifier of this note.  Will be set by the
 *   server, but will be omitted by clients calling NoteStore.createNote()
 *   <br/>
 *   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
 *   <br/>
 *   Regex:  EDAM_GUID_REGEX
 *   </dd>
 * 
 * <dt>title</dt>
 *   <dd>The subject of the note.  Can't begin or end with a space.
 *   <br/>
 *   Length:  EDAM_NOTE_TITLE_LEN_MIN - EDAM_NOTE_TITLE_LEN_MAX
 *   <br/>
 *   Regex:  EDAM_NOTE_TITLE_REGEX
 *   </dd>
 * 
 * <dt>content</dt>
 *   <dd>The XHTML block that makes up the note.  This is
 *   the canonical form of the note's contents, so will include abstract
 *   Evernote tags for internal resource references.  A client may create
 *   a separate transformed version of this content for internal presentation,
 *   but the same canonical bytes should be used for transmission and
 *   comparison unless the user chooses to modify their content.
 *   <br/>
 *   Length:  EDAM_NOTE_CONTENT_LEN_MIN - EDAM_NOTE_CONTENT_LEN_MAX
 *   </dd>
 * 
 * <dt>contentHash</dt>
 *   <dd>The binary MD5 checksum of the UTF-8 encoded content
 *   body. This will always be set by the server, but clients may choose to omit
 *   this when they submit a note with content.
 *   <br/>
 *   Length:  EDAM_HASH_LEN (exactly)
 *   </dd>
 * 
 * <dt>contentLength</dt>
 *   <dd>The number of Unicode characters in the content of
 *   the note.  This will always be set by the service, but clients may choose
 *   to omit this value when they submit a Note.
 *   </dd>
 * 
 * <dt>created</dt>
 *   <dd>The date and time when the note was created in one of the
 *   clients.  In most cases, this will match the user's sense of when
 *   the note was created, and ordering between notes will be based on
 *   ordering of this field.  However, this is not a "reliable" timestamp
 *   if a client has an incorrect clock, so it cannot provide a true absolute
 *   ordering between notes.  Notes created directly through the service
 *   (e.g. via the web GUI) will have an absolutely ordered "created" value.
 *   </dd>
 * 
 * <dt>updated</dt>
 *   <dd>The date and time when the note was last modified in one of
 *   the clients.  In most cases, this will match the user's sense of when
 *   the note was modified, but this field may not be absolutely reliable
 *   due to the possibility of client clock errors.
 *   </dd>
 * 
 * <dt>deleted</dt>
 *   <dd>If present, the note is considered "deleted", and this
 *   stores the date and time when the note was deleted by one of the clients.
 *   In most cases, this will match the user's sense of when the note was
 *   deleted, but this field may be unreliable due to the possibility of
 *   client clock errors.
 *   </dd>
 * 
 * <dt>active</dt>
 *   <dd>If the note is available for normal actions and viewing,
 *   this flag will be set to true.
 *   </dd>
 * 
 * <dt>updateSequenceNum</dt>
 *   <dd>A number identifying the last transaction to
 *   modify the state of this note (including changes to the note's attributes
 *   or resources).  The USN values are sequential within an account,
 *   and can be used to compare the order of modifications within the service.
 *   </dd>
 * 
 * <dt>notebookGuid</dt>
 *   <dd>The unique identifier of the notebook that contains
 *   this note.  If no notebookGuid is provided on a call to createNote(), the
 *   default notebook will be used instead.
 *   <br/>
 *   Length:  EDAM_GUID_LEN_MIN - EDAM_GUID_LEN_MAX
 *   <br/>
 *   Regex:  EDAM_GUID_REGEX
 *   </dd>
 * 
 * <dt>tagGuids</dt>
 *   <dd>A list of the GUID identifiers for tags that are applied to this note.
 *   This may be provided in a call to createNote() to unambiguously declare
 *   the tags that should be assigned to the new note.  Alternately, clients
 *   may pass the names of desired tags via the 'tagNames' field during
 *   note creation.
 *   If the list of tags are omitted on a call to createNote(), then
 *   the server will assume that no changes have been made to the resources.
 *   Maximum:  EDAM_NOTE_TAGS_MAX tags per note
 *   </dd>
 * 
 * <dt>resources</dt>
 *   <dd>The list of resources that are embedded within this note.
 *   If the list of resources are omitted on a call to updateNote(), then
 *   the server will assume that no changes have been made to the resources.
 *   The binary contents of the resources must be provided when the resource
 *   is first sent to the service, but it will be omitted by the service when
 *   the Note is returned in the future.
 *   Maximum:  EDAM_NOTE_RESOURCES_MAX resources per note
 *   </dd>
 * 
 * <dt>attributes</dt>
 *   <dd>A list of the attributes for this note.
 *   If the list of attributes are omitted on a call to updateNote(), then
 *   the server will assume that no changes have been made to the resources.
 *   </dd>
 * 
 * <dt>tagNames</dt>
 *   <dd>May be provided by clients during calls to createNote() as an
 *   alternative to providing the tagGuids of existing tags.  If any tagNames
 *   are provided during createNote(), these will be found, or created if they
 *   don't already exist.  Created tags will have no parent (they will be at
 *   the top level of the tag panel).
 *   </dd>
 * </dl>
 */
public class Note implements TBase<Note._Fields>, java.io.Serializable, Cloneable, Comparable<Note> {
  private static final TStruct STRUCT_DESC = new TStruct("Note");

  private static final TField GUID_FIELD_DESC = new TField("guid", TType.STRING, (short)1);
  private static final TField TITLE_FIELD_DESC = new TField("title", TType.STRING, (short)2);
  private static final TField CONTENT_FIELD_DESC = new TField("content", TType.STRING, (short)3);
  private static final TField CONTENT_HASH_FIELD_DESC = new TField("contentHash", TType.STRING, (short)4);
  private static final TField CONTENT_LENGTH_FIELD_DESC = new TField("contentLength", TType.I32, (short)5);
  private static final TField CREATED_FIELD_DESC = new TField("created", TType.I64, (short)6);
  private static final TField UPDATED_FIELD_DESC = new TField("updated", TType.I64, (short)7);
  private static final TField DELETED_FIELD_DESC = new TField("deleted", TType.I64, (short)8);
  private static final TField ACTIVE_FIELD_DESC = new TField("active", TType.BOOL, (short)9);
  private static final TField UPDATE_SEQUENCE_NUM_FIELD_DESC = new TField("updateSequenceNum", TType.I32, (short)10);
  private static final TField NOTEBOOK_GUID_FIELD_DESC = new TField("notebookGuid", TType.STRING, (short)11);
  private static final TField TAG_GUIDS_FIELD_DESC = new TField("tagGuids", TType.LIST, (short)12);
  private static final TField RESOURCES_FIELD_DESC = new TField("resources", TType.LIST, (short)13);
  private static final TField ATTRIBUTES_FIELD_DESC = new TField("attributes", TType.STRUCT, (short)14);
  private static final TField TAG_NAMES_FIELD_DESC = new TField("tagNames", TType.LIST, (short)15);

  private String guid;
  private String title;
  private String content;
  private byte[] contentHash;
  private int contentLength;
  private long created;
  private long updated;
  private long deleted;
  private boolean active;
  private int updateSequenceNum;
  private String notebookGuid;
  private List<String> tagGuids;
  private List<Resource> resources;
  private NoteAttributes attributes;
  private List<String> tagNames;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    GUID((short)1, "guid"),
    TITLE((short)2, "title"),
    CONTENT((short)3, "content"),
    CONTENT_HASH((short)4, "contentHash"),
    CONTENT_LENGTH((short)5, "contentLength"),
    CREATED((short)6, "created"),
    UPDATED((short)7, "updated"),
    DELETED((short)8, "deleted"),
    ACTIVE((short)9, "active"),
    UPDATE_SEQUENCE_NUM((short)10, "updateSequenceNum"),
    NOTEBOOK_GUID((short)11, "notebookGuid"),
    TAG_GUIDS((short)12, "tagGuids"),
    RESOURCES((short)13, "resources"),
    ATTRIBUTES((short)14, "attributes"),
    TAG_NAMES((short)15, "tagNames");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __CONTENTLENGTH_ISSET_ID = 0;
  private static final int __CREATED_ISSET_ID = 1;
  private static final int __UPDATED_ISSET_ID = 2;
  private static final int __DELETED_ISSET_ID = 3;
  private static final int __ACTIVE_ISSET_ID = 4;
  private static final int __UPDATESEQUENCENUM_ISSET_ID = 5;
  private BitSet __isset_bit_vector = new BitSet(6);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.GUID, new FieldMetaData("guid", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.TITLE, new FieldMetaData("title", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.CONTENT, new FieldMetaData("content", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.CONTENT_HASH, new FieldMetaData("contentHash", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.CONTENT_LENGTH, new FieldMetaData("contentLength", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.CREATED, new FieldMetaData("created", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.UPDATED, new FieldMetaData("updated", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.DELETED, new FieldMetaData("deleted", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.ACTIVE, new FieldMetaData("active", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.BOOL)));
    put(_Fields.UPDATE_SEQUENCE_NUM, new FieldMetaData("updateSequenceNum", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I32)));
    put(_Fields.NOTEBOOK_GUID, new FieldMetaData("notebookGuid", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.TAG_GUIDS, new FieldMetaData("tagGuids", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
    put(_Fields.RESOURCES, new FieldMetaData("resources", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new StructMetaData(TType.STRUCT, Resource.class))));
    put(_Fields.ATTRIBUTES, new FieldMetaData("attributes", TFieldRequirementType.OPTIONAL, 
        new StructMetaData(TType.STRUCT, NoteAttributes.class)));
    put(_Fields.TAG_NAMES, new FieldMetaData("tagNames", TFieldRequirementType.OPTIONAL, 
        new ListMetaData(TType.LIST, 
            new FieldValueMetaData(TType.STRING))));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(Note.class, metaDataMap);
  }

  public Note() {
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public Note(Note other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    if (other.isSetGuid()) {
      this.guid = other.guid;
    }
    if (other.isSetTitle()) {
      this.title = other.title;
    }
    if (other.isSetContent()) {
      this.content = other.content;
    }
    if (other.isSetContentHash()) {
      this.contentHash = new byte[other.contentHash.length];
      System.arraycopy(other.contentHash, 0, contentHash, 0, other.contentHash.length);
    }
    this.contentLength = other.contentLength;
    this.created = other.created;
    this.updated = other.updated;
    this.deleted = other.deleted;
    this.active = other.active;
    this.updateSequenceNum = other.updateSequenceNum;
    if (other.isSetNotebookGuid()) {
      this.notebookGuid = other.notebookGuid;
    }
    if (other.isSetTagGuids()) {
      List<String> __this__tagGuids = new ArrayList<String>();
      for (String other_element : other.tagGuids) {
        __this__tagGuids.add(other_element);
      }
      this.tagGuids = __this__tagGuids;
    }
    if (other.isSetResources()) {
      List<Resource> __this__resources = new ArrayList<Resource>();
      for (Resource other_element : other.resources) {
        __this__resources.add(new Resource(other_element));
      }
      this.resources = __this__resources;
    }
    if (other.isSetAttributes()) {
      this.attributes = new NoteAttributes(other.attributes);
    }
    if (other.isSetTagNames()) {
      List<String> __this__tagNames = new ArrayList<String>();
      for (String other_element : other.tagNames) {
        __this__tagNames.add(other_element);
      }
      this.tagNames = __this__tagNames;
    }
  }

  public Note deepCopy() {
    return new Note(this);
  }

  @Deprecated
  public Note clone() {
    return new Note(this);
  }

  public String getGuid() {
    return this.guid;
  }

  public void setGuid(String guid) {
    this.guid = guid;
  }

  public void unsetGuid() {
    this.guid = null;
  }

  /** Returns true if field guid is set (has been asigned a value) and false otherwise */
  public boolean isSetGuid() {
    return this.guid != null;
  }

  public void setGuidIsSet(boolean value) {
    if (!value) {
      this.guid = null;
    }
  }

  public String getTitle() {
    return this.title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public void unsetTitle() {
    this.title = null;
  }

  /** Returns true if field title is set (has been asigned a value) and false otherwise */
  public boolean isSetTitle() {
    return this.title != null;
  }

  public void setTitleIsSet(boolean value) {
    if (!value) {
      this.title = null;
    }
  }

  public String getContent() {
    return this.content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public void unsetContent() {
    this.content = null;
  }

  /** Returns true if field content is set (has been asigned a value) and false otherwise */
  public boolean isSetContent() {
    return this.content != null;
  }

  public void setContentIsSet(boolean value) {
    if (!value) {
      this.content = null;
    }
  }

  public byte[] getContentHash() {
    return this.contentHash;
  }

  public void setContentHash(byte[] contentHash) {
    this.contentHash = contentHash;
  }

  public void unsetContentHash() {
    this.contentHash = null;
  }

  /** Returns true if field contentHash is set (has been asigned a value) and false otherwise */
  public boolean isSetContentHash() {
    return this.contentHash != null;
  }

  public void setContentHashIsSet(boolean value) {
    if (!value) {
      this.contentHash = null;
    }
  }

  public int getContentLength() {
    return this.contentLength;
  }

  public void setContentLength(int contentLength) {
    this.contentLength = contentLength;
    setContentLengthIsSet(true);
  }

  public void unsetContentLength() {
    __isset_bit_vector.clear(__CONTENTLENGTH_ISSET_ID);
  }

  /** Returns true if field contentLength is set (has been asigned a value) and false otherwise */
  public boolean isSetContentLength() {
    return __isset_bit_vector.get(__CONTENTLENGTH_ISSET_ID);
  }

  public void setContentLengthIsSet(boolean value) {
    __isset_bit_vector.set(__CONTENTLENGTH_ISSET_ID, value);
  }

  public long getCreated() {
    return this.created;
  }

  public void setCreated(long created) {
    this.created = created;
    setCreatedIsSet(true);
  }

  public void unsetCreated() {
    __isset_bit_vector.clear(__CREATED_ISSET_ID);
  }

  /** Returns true if field created is set (has been asigned a value) and false otherwise */
  public boolean isSetCreated() {
    return __isset_bit_vector.get(__CREATED_ISSET_ID);
  }

  public void setCreatedIsSet(boolean value) {
    __isset_bit_vector.set(__CREATED_ISSET_ID, value);
  }

  public long getUpdated() {
    return this.updated;
  }

  public void setUpdated(long updated) {
    this.updated = updated;
    setUpdatedIsSet(true);
  }

  public void unsetUpdated() {
    __isset_bit_vector.clear(__UPDATED_ISSET_ID);
  }

  /** Returns true if field updated is set (has been asigned a value) and false otherwise */
  public boolean isSetUpdated() {
    return __isset_bit_vector.get(__UPDATED_ISSET_ID);
  }

  public void setUpdatedIsSet(boolean value) {
    __isset_bit_vector.set(__UPDATED_ISSET_ID, value);
  }

  public long getDeleted() {
    return this.deleted;
  }

  public void setDeleted(long deleted) {
    this.deleted = deleted;
    setDeletedIsSet(true);
  }

  public void unsetDeleted() {
    __isset_bit_vector.clear(__DELETED_ISSET_ID);
  }

  /** Returns true if field deleted is set (has been asigned a value) and false otherwise */
  public boolean isSetDeleted() {
    return __isset_bit_vector.get(__DELETED_ISSET_ID);
  }

  public void setDeletedIsSet(boolean value) {
    __isset_bit_vector.set(__DELETED_ISSET_ID, value);
  }

  public boolean isActive() {
    return this.active;
  }

  public void setActive(boolean active) {
    this.active = active;
    setActiveIsSet(true);
  }

  public void unsetActive() {
    __isset_bit_vector.clear(__ACTIVE_ISSET_ID);
  }

  /** Returns true if field active is set (has been asigned a value) and false otherwise */
  public boolean isSetActive() {
    return __isset_bit_vector.get(__ACTIVE_ISSET_ID);
  }

  public void setActiveIsSet(boolean value) {
    __isset_bit_vector.set(__ACTIVE_ISSET_ID, value);
  }

  public int getUpdateSequenceNum() {
    return this.updateSequenceNum;
  }

  public void setUpdateSequenceNum(int updateSequenceNum) {
    this.updateSequenceNum = updateSequenceNum;
    setUpdateSequenceNumIsSet(true);
  }

  public void unsetUpdateSequenceNum() {
    __isset_bit_vector.clear(__UPDATESEQUENCENUM_ISSET_ID);
  }

  /** Returns true if field updateSequenceNum is set (has been asigned a value) and false otherwise */
  public boolean isSetUpdateSequenceNum() {
    return __isset_bit_vector.get(__UPDATESEQUENCENUM_ISSET_ID);
  }

  public void setUpdateSequenceNumIsSet(boolean value) {
    __isset_bit_vector.set(__UPDATESEQUENCENUM_ISSET_ID, value);
  }

  public String getNotebookGuid() {
    return this.notebookGuid;
  }

  public void setNotebookGuid(String notebookGuid) {
    this.notebookGuid = notebookGuid;
  }

  public void unsetNotebookGuid() {
    this.notebookGuid = null;
  }

  /** Returns true if field notebookGuid is set (has been asigned a value) and false otherwise */
  public boolean isSetNotebookGuid() {
    return this.notebookGuid != null;
  }

  public void setNotebookGuidIsSet(boolean value) {
    if (!value) {
      this.notebookGuid = null;
    }
  }

  public int getTagGuidsSize() {
    return (this.tagGuids == null) ? 0 : this.tagGuids.size();
  }

  public java.util.Iterator<String> getTagGuidsIterator() {
    return (this.tagGuids == null) ? null : this.tagGuids.iterator();
  }

  public void addToTagGuids(String elem) {
    if (this.tagGuids == null) {
      this.tagGuids = new ArrayList<String>();
    }
    this.tagGuids.add(elem);
  }

  public List<String> getTagGuids() {
    return this.tagGuids;
  }

  public void setTagGuids(List<String> tagGuids) {
    this.tagGuids = tagGuids;
  }

  public void unsetTagGuids() {
    this.tagGuids = null;
  }

  /** Returns true if field tagGuids is set (has been asigned a value) and false otherwise */
  public boolean isSetTagGuids() {
    return this.tagGuids != null;
  }

  public void setTagGuidsIsSet(boolean value) {
    if (!value) {
      this.tagGuids = null;
    }
  }

  public int getResourcesSize() {
    return (this.resources == null) ? 0 : this.resources.size();
  }

  public java.util.Iterator<Resource> getResourcesIterator() {
    return (this.resources == null) ? null : this.resources.iterator();
  }

  public void addToResources(Resource elem) {
    if (this.resources == null) {
      this.resources = new ArrayList<Resource>();
    }
    this.resources.add(elem);
  }

  public List<Resource> getResources() {
    return this.resources;
  }

  public void setResources(List<Resource> resources) {
    this.resources = resources;
  }

  public void unsetResources() {
    this.resources = null;
  }

  /** Returns true if field resources is set (has been asigned a value) and false otherwise */
  public boolean isSetResources() {
    return this.resources != null;
  }

  public void setResourcesIsSet(boolean value) {
    if (!value) {
      this.resources = null;
    }
  }

  public NoteAttributes getAttributes() {
    return this.attributes;
  }

  public void setAttributes(NoteAttributes attributes) {
    this.attributes = attributes;
  }

  public void unsetAttributes() {
    this.attributes = null;
  }

  /** Returns true if field attributes is set (has been asigned a value) and false otherwise */
  public boolean isSetAttributes() {
    return this.attributes != null;
  }

  public void setAttributesIsSet(boolean value) {
    if (!value) {
      this.attributes = null;
    }
  }

  public int getTagNamesSize() {
    return (this.tagNames == null) ? 0 : this.tagNames.size();
  }

  public java.util.Iterator<String> getTagNamesIterator() {
    return (this.tagNames == null) ? null : this.tagNames.iterator();
  }

  public void addToTagNames(String elem) {
    if (this.tagNames == null) {
      this.tagNames = new ArrayList<String>();
    }
    this.tagNames.add(elem);
  }

  public List<String> getTagNames() {
    return this.tagNames;
  }

  public void setTagNames(List<String> tagNames) {
    this.tagNames = tagNames;
  }

  public void unsetTagNames() {
    this.tagNames = null;
  }

  /** Returns true if field tagNames is set (has been asigned a value) and false otherwise */
  public boolean isSetTagNames() {
    return this.tagNames != null;
  }

  public void setTagNamesIsSet(boolean value) {
    if (!value) {
      this.tagNames = null;
    }
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case GUID:
      if (value == null) {
        unsetGuid();
      } else {
        setGuid((String)value);
      }
      break;

    case TITLE:
      if (value == null) {
        unsetTitle();
      } else {
        setTitle((String)value);
      }
      break;

    case CONTENT:
      if (value == null) {
        unsetContent();
      } else {
        setContent((String)value);
      }
      break;

    case CONTENT_HASH:
      if (value == null) {
        unsetContentHash();
      } else {
        setContentHash((byte[])value);
      }
      break;

    case CONTENT_LENGTH:
      if (value == null) {
        unsetContentLength();
      } else {
        setContentLength((Integer)value);
      }
      break;

    case CREATED:
      if (value == null) {
        unsetCreated();
      } else {
        setCreated((Long)value);
      }
      break;

    case UPDATED:
      if (value == null) {
        unsetUpdated();
      } else {
        setUpdated((Long)value);
      }
      break;

    case DELETED:
      if (value == null) {
        unsetDeleted();
      } else {
        setDeleted((Long)value);
      }
      break;

    case ACTIVE:
      if (value == null) {
        unsetActive();
      } else {
        setActive((Boolean)value);
      }
      break;

    case UPDATE_SEQUENCE_NUM:
      if (value == null) {
        unsetUpdateSequenceNum();
      } else {
        setUpdateSequenceNum((Integer)value);
      }
      break;

    case NOTEBOOK_GUID:
      if (value == null) {
        unsetNotebookGuid();
      } else {
        setNotebookGuid((String)value);
      }
      break;

    case TAG_GUIDS:
      if (value == null) {
        unsetTagGuids();
      } else {
        setTagGuids((List<String>)value);
      }
      break;

    case RESOURCES:
      if (value == null) {
        unsetResources();
      } else {
        setResources((List<Resource>)value);
      }
      break;

    case ATTRIBUTES:
      if (value == null) {
        unsetAttributes();
      } else {
        setAttributes((NoteAttributes)value);
      }
      break;

    case TAG_NAMES:
      if (value == null) {
        unsetTagNames();
      } else {
        setTagNames((List<String>)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case GUID:
      return getGuid();

    case TITLE:
      return getTitle();

    case CONTENT:
      return getContent();

    case CONTENT_HASH:
      return getContentHash();

    case CONTENT_LENGTH:
      return new Integer(getContentLength());

    case CREATED:
      return new Long(getCreated());

    case UPDATED:
      return new Long(getUpdated());

    case DELETED:
      return new Long(getDeleted());

    case ACTIVE:
      return new Boolean(isActive());

    case UPDATE_SEQUENCE_NUM:
      return new Integer(getUpdateSequenceNum());

    case NOTEBOOK_GUID:
      return getNotebookGuid();

    case TAG_GUIDS:
      return getTagGuids();

    case RESOURCES:
      return getResources();

    case ATTRIBUTES:
      return getAttributes();

    case TAG_NAMES:
      return getTagNames();

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case GUID:
      return isSetGuid();
    case TITLE:
      return isSetTitle();
    case CONTENT:
      return isSetContent();
    case CONTENT_HASH:
      return isSetContentHash();
    case CONTENT_LENGTH:
      return isSetContentLength();
    case CREATED:
      return isSetCreated();
    case UPDATED:
      return isSetUpdated();
    case DELETED:
      return isSetDeleted();
    case ACTIVE:
      return isSetActive();
    case UPDATE_SEQUENCE_NUM:
      return isSetUpdateSequenceNum();
    case NOTEBOOK_GUID:
      return isSetNotebookGuid();
    case TAG_GUIDS:
      return isSetTagGuids();
    case RESOURCES:
      return isSetResources();
    case ATTRIBUTES:
      return isSetAttributes();
    case TAG_NAMES:
      return isSetTagNames();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof Note)
      return this.equals((Note)that);
    return false;
  }

  public boolean equals(Note that) {
    if (that == null)
      return false;

    boolean this_present_guid = true && this.isSetGuid();
    boolean that_present_guid = true && that.isSetGuid();
    if (this_present_guid || that_present_guid) {
      if (!(this_present_guid && that_present_guid))
        return false;
      if (!this.guid.equals(that.guid))
        return false;
    }

    boolean this_present_title = true && this.isSetTitle();
    boolean that_present_title = true && that.isSetTitle();
    if (this_present_title || that_present_title) {
      if (!(this_present_title && that_present_title))
        return false;
      if (!this.title.equals(that.title))
        return false;
    }

    boolean this_present_content = true && this.isSetContent();
    boolean that_present_content = true && that.isSetContent();
    if (this_present_content || that_present_content) {
      if (!(this_present_content && that_present_content))
        return false;
      if (!this.content.equals(that.content))
        return false;
    }

    boolean this_present_contentHash = true && this.isSetContentHash();
    boolean that_present_contentHash = true && that.isSetContentHash();
    if (this_present_contentHash || that_present_contentHash) {
      if (!(this_present_contentHash && that_present_contentHash))
        return false;
      if (!java.util.Arrays.equals(this.contentHash, that.contentHash))
        return false;
    }

    boolean this_present_contentLength = true && this.isSetContentLength();
    boolean that_present_contentLength = true && that.isSetContentLength();
    if (this_present_contentLength || that_present_contentLength) {
      if (!(this_present_contentLength && that_present_contentLength))
        return false;
      if (this.contentLength != that.contentLength)
        return false;
    }

    boolean this_present_created = true && this.isSetCreated();
    boolean that_present_created = true && that.isSetCreated();
    if (this_present_created || that_present_created) {
      if (!(this_present_created && that_present_created))
        return false;
      if (this.created != that.created)
        return false;
    }

    boolean this_present_updated = true && this.isSetUpdated();
    boolean that_present_updated = true && that.isSetUpdated();
    if (this_present_updated || that_present_updated) {
      if (!(this_present_updated && that_present_updated))
        return false;
      if (this.updated != that.updated)
        return false;
    }

    boolean this_present_deleted = true && this.isSetDeleted();
    boolean that_present_deleted = true && that.isSetDeleted();
    if (this_present_deleted || that_present_deleted) {
      if (!(this_present_deleted && that_present_deleted))
        return false;
      if (this.deleted != that.deleted)
        return false;
    }

    boolean this_present_active = true && this.isSetActive();
    boolean that_present_active = true && that.isSetActive();
    if (this_present_active || that_present_active) {
      if (!(this_present_active && that_present_active))
        return false;
      if (this.active != that.active)
        return false;
    }

    boolean this_present_updateSequenceNum = true && this.isSetUpdateSequenceNum();
    boolean that_present_updateSequenceNum = true && that.isSetUpdateSequenceNum();
    if (this_present_updateSequenceNum || that_present_updateSequenceNum) {
      if (!(this_present_updateSequenceNum && that_present_updateSequenceNum))
        return false;
      if (this.updateSequenceNum != that.updateSequenceNum)
        return false;
    }

    boolean this_present_notebookGuid = true && this.isSetNotebookGuid();
    boolean that_present_notebookGuid = true && that.isSetNotebookGuid();
    if (this_present_notebookGuid || that_present_notebookGuid) {
      if (!(this_present_notebookGuid && that_present_notebookGuid))
        return false;
      if (!this.notebookGuid.equals(that.notebookGuid))
        return false;
    }

    boolean this_present_tagGuids = true && this.isSetTagGuids();
    boolean that_present_tagGuids = true && that.isSetTagGuids();
    if (this_present_tagGuids || that_present_tagGuids) {
      if (!(this_present_tagGuids && that_present_tagGuids))
        return false;
      if (!this.tagGuids.equals(that.tagGuids))
        return false;
    }

    boolean this_present_resources = true && this.isSetResources();
    boolean that_present_resources = true && that.isSetResources();
    if (this_present_resources || that_present_resources) {
      if (!(this_present_resources && that_present_resources))
        return false;
      if (!this.resources.equals(that.resources))
        return false;
    }

    boolean this_present_attributes = true && this.isSetAttributes();
    boolean that_present_attributes = true && that.isSetAttributes();
    if (this_present_attributes || that_present_attributes) {
      if (!(this_present_attributes && that_present_attributes))
        return false;
      if (!this.attributes.equals(that.attributes))
        return false;
    }

    boolean this_present_tagNames = true && this.isSetTagNames();
    boolean that_present_tagNames = true && that.isSetTagNames();
    if (this_present_tagNames || that_present_tagNames) {
      if (!(this_present_tagNames && that_present_tagNames))
        return false;
      if (!this.tagNames.equals(that.tagNames))
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(Note other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    Note typedOther = (Note)other;

    lastComparison = Boolean.valueOf(isSetGuid()).compareTo(isSetGuid());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(guid, typedOther.guid);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTitle()).compareTo(isSetTitle());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(title, typedOther.title);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetContent()).compareTo(isSetContent());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(content, typedOther.content);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetContentHash()).compareTo(isSetContentHash());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(contentHash, typedOther.contentHash);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetContentLength()).compareTo(isSetContentLength());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(contentLength, typedOther.contentLength);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetCreated()).compareTo(isSetCreated());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(created, typedOther.created);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUpdated()).compareTo(isSetUpdated());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(updated, typedOther.updated);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetDeleted()).compareTo(isSetDeleted());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(deleted, typedOther.deleted);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetActive()).compareTo(isSetActive());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(active, typedOther.active);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUpdateSequenceNum()).compareTo(isSetUpdateSequenceNum());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(updateSequenceNum, typedOther.updateSequenceNum);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetNotebookGuid()).compareTo(isSetNotebookGuid());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(notebookGuid, typedOther.notebookGuid);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTagGuids()).compareTo(isSetTagGuids());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(tagGuids, typedOther.tagGuids);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetResources()).compareTo(isSetResources());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(resources, typedOther.resources);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetAttributes()).compareTo(isSetAttributes());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(attributes, typedOther.attributes);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetTagNames()).compareTo(isSetTagNames());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(tagNames, typedOther.tagNames);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case GUID:
            if (field.type == TType.STRING) {
              this.guid = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TITLE:
            if (field.type == TType.STRING) {
              this.title = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CONTENT:
            if (field.type == TType.STRING) {
              this.content = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CONTENT_HASH:
            if (field.type == TType.STRING) {
              this.contentHash = iprot.readBinary();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CONTENT_LENGTH:
            if (field.type == TType.I32) {
              this.contentLength = iprot.readI32();
              setContentLengthIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case CREATED:
            if (field.type == TType.I64) {
              this.created = iprot.readI64();
              setCreatedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPDATED:
            if (field.type == TType.I64) {
              this.updated = iprot.readI64();
              setUpdatedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case DELETED:
            if (field.type == TType.I64) {
              this.deleted = iprot.readI64();
              setDeletedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ACTIVE:
            if (field.type == TType.BOOL) {
              this.active = iprot.readBool();
              setActiveIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPDATE_SEQUENCE_NUM:
            if (field.type == TType.I32) {
              this.updateSequenceNum = iprot.readI32();
              setUpdateSequenceNumIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case NOTEBOOK_GUID:
            if (field.type == TType.STRING) {
              this.notebookGuid = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TAG_GUIDS:
            if (field.type == TType.LIST) {
              {
                TList _list8 = iprot.readListBegin();
                this.tagGuids = new ArrayList<String>(_list8.size);
                for (int _i9 = 0; _i9 < _list8.size; ++_i9)
                {
                  String _elem10;
                  _elem10 = iprot.readString();
                  this.tagGuids.add(_elem10);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case RESOURCES:
            if (field.type == TType.LIST) {
              {
                TList _list11 = iprot.readListBegin();
                this.resources = new ArrayList<Resource>(_list11.size);
                for (int _i12 = 0; _i12 < _list11.size; ++_i12)
                {
                  Resource _elem13;
                  _elem13 = new Resource();
                  _elem13.read(iprot);
                  this.resources.add(_elem13);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case ATTRIBUTES:
            if (field.type == TType.STRUCT) {
              this.attributes = new NoteAttributes();
              this.attributes.read(iprot);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case TAG_NAMES:
            if (field.type == TType.LIST) {
              {
                TList _list14 = iprot.readListBegin();
                this.tagNames = new ArrayList<String>(_list14.size);
                for (int _i15 = 0; _i15 < _list14.size; ++_i15)
                {
                  String _elem16;
                  _elem16 = iprot.readString();
                  this.tagNames.add(_elem16);
                }
                iprot.readListEnd();
              }
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (this.guid != null) {
      if (isSetGuid()) {
        oprot.writeFieldBegin(GUID_FIELD_DESC);
        oprot.writeString(this.guid);
        oprot.writeFieldEnd();
      }
    }
    if (this.title != null) {
      if (isSetTitle()) {
        oprot.writeFieldBegin(TITLE_FIELD_DESC);
        oprot.writeString(this.title);
        oprot.writeFieldEnd();
      }
    }
    if (this.content != null) {
      if (isSetContent()) {
        oprot.writeFieldBegin(CONTENT_FIELD_DESC);
        oprot.writeString(this.content);
        oprot.writeFieldEnd();
      }
    }
    if (this.contentHash != null) {
      if (isSetContentHash()) {
        oprot.writeFieldBegin(CONTENT_HASH_FIELD_DESC);
        oprot.writeBinary(this.contentHash);
        oprot.writeFieldEnd();
      }
    }
    if (isSetContentLength()) {
      oprot.writeFieldBegin(CONTENT_LENGTH_FIELD_DESC);
      oprot.writeI32(this.contentLength);
      oprot.writeFieldEnd();
    }
    if (isSetCreated()) {
      oprot.writeFieldBegin(CREATED_FIELD_DESC);
      oprot.writeI64(this.created);
      oprot.writeFieldEnd();
    }
    if (isSetUpdated()) {
      oprot.writeFieldBegin(UPDATED_FIELD_DESC);
      oprot.writeI64(this.updated);
      oprot.writeFieldEnd();
    }
    if (isSetDeleted()) {
      oprot.writeFieldBegin(DELETED_FIELD_DESC);
      oprot.writeI64(this.deleted);
      oprot.writeFieldEnd();
    }
    if (isSetActive()) {
      oprot.writeFieldBegin(ACTIVE_FIELD_DESC);
      oprot.writeBool(this.active);
      oprot.writeFieldEnd();
    }
    if (isSetUpdateSequenceNum()) {
      oprot.writeFieldBegin(UPDATE_SEQUENCE_NUM_FIELD_DESC);
      oprot.writeI32(this.updateSequenceNum);
      oprot.writeFieldEnd();
    }
    if (this.notebookGuid != null) {
      if (isSetNotebookGuid()) {
        oprot.writeFieldBegin(NOTEBOOK_GUID_FIELD_DESC);
        oprot.writeString(this.notebookGuid);
        oprot.writeFieldEnd();
      }
    }
    if (this.tagGuids != null) {
      if (isSetTagGuids()) {
        oprot.writeFieldBegin(TAG_GUIDS_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.tagGuids.size()));
          for (String _iter17 : this.tagGuids)
          {
            oprot.writeString(_iter17);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.resources != null) {
      if (isSetResources()) {
        oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.resources.size()));
          for (Resource _iter18 : this.resources)
          {
            _iter18.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    if (this.attributes != null) {
      if (isSetAttributes()) {
        oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
        this.attributes.write(oprot);
        oprot.writeFieldEnd();
      }
    }
    if (this.tagNames != null) {
      if (isSetTagNames()) {
        oprot.writeFieldBegin(TAG_NAMES_FIELD_DESC);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.tagNames.size()));
          for (String _iter19 : this.tagNames)
          {
            oprot.writeString(_iter19);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("Note(");
    boolean first = true;

    if (isSetGuid()) {
      sb.append("guid:");
      if (this.guid == null) {
        sb.append("null");
      } else {
        sb.append(this.guid);
      }
      first = false;
    }
    if (isSetTitle()) {
      if (!first) sb.append(", ");
      sb.append("title:");
      if (this.title == null) {
        sb.append("null");
      } else {
        sb.append(this.title);
      }
      first = false;
    }
    if (isSetContent()) {
      if (!first) sb.append(", ");
      sb.append("content:");
      if (this.content == null) {
        sb.append("null");
      } else {
        sb.append(this.content);
      }
      first = false;
    }
    if (isSetContentHash()) {
      if (!first) sb.append(", ");
      sb.append("contentHash:");
      if (this.contentHash == null) {
        sb.append("null");
      } else {
          int __contentHash_size = Math.min(this.contentHash.length, 128);
          for (int i = 0; i < __contentHash_size; i++) {
            if (i != 0) sb.append(" ");
            sb.append(Integer.toHexString(this.contentHash[i]).length() > 1 ? Integer.toHexString(this.contentHash[i]).substring(Integer.toHexString(this.contentHash[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.contentHash[i]).toUpperCase());
          }
          if (this.contentHash.length > 128) sb.append(" ...");
      }
      first = false;
    }
    if (isSetContentLength()) {
      if (!first) sb.append(", ");
      sb.append("contentLength:");
      sb.append(this.contentLength);
      first = false;
    }
    if (isSetCreated()) {
      if (!first) sb.append(", ");
      sb.append("created:");
      sb.append(this.created);
      first = false;
    }
    if (isSetUpdated()) {
      if (!first) sb.append(", ");
      sb.append("updated:");
      sb.append(this.updated);
      first = false;
    }
    if (isSetDeleted()) {
      if (!first) sb.append(", ");
      sb.append("deleted:");
      sb.append(this.deleted);
      first = false;
    }
    if (isSetActive()) {
      if (!first) sb.append(", ");
      sb.append("active:");
      sb.append(this.active);
      first = false;
    }
    if (isSetUpdateSequenceNum()) {
      if (!first) sb.append(", ");
      sb.append("updateSequenceNum:");
      sb.append(this.updateSequenceNum);
      first = false;
    }
    if (isSetNotebookGuid()) {
      if (!first) sb.append(", ");
      sb.append("notebookGuid:");
      if (this.notebookGuid == null) {
        sb.append("null");
      } else {
        sb.append(this.notebookGuid);
      }
      first = false;
    }
    if (isSetTagGuids()) {
      if (!first) sb.append(", ");
      sb.append("tagGuids:");
      if (this.tagGuids == null) {
        sb.append("null");
      } else {
        sb.append(this.tagGuids);
      }
      first = false;
    }
    if (isSetResources()) {
      if (!first) sb.append(", ");
      sb.append("resources:");
      if (this.resources == null) {
        sb.append("null");
      } else {
        sb.append(this.resources);
      }
      first = false;
    }
    if (isSetAttributes()) {
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
    }
    if (isSetTagNames()) {
      if (!first) sb.append(", ");
      sb.append("tagNames:");
      if (this.tagNames == null) {
        sb.append("null");
      } else {
        sb.append(this.tagNames);
      }
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }

}

