package com.evernote.edam.util;

/**
 * Minimal BitSet implementation to support Evernote's EDAM protocol.
 * Not a general replacement for java.util.BitMap, but this version will
 * work for our classes, and will be serializable over Google Web Toolkit.
 */
public class BitSet implements java.io.Serializable {

  private long word;
  
  public BitSet() {
  }
  
  public BitSet(int size) {
    if (size > 63) {
      throw new RuntimeException("BitSet limited to 64 bits");
    }
  }

  public void clear() {
    word = 0;
  }
  
  public void or(BitSet other) {
    word |= other.word;
  }
  
  public void clear(int index) {
    word &= ~(1L << index);
  }
  
  public boolean get(int index) {
    return ((word >> index) & 1) == 1;
  }
  
  public void set(int index, boolean value) {
    if (value) {
      word |= (1L << index);
    } else {
      clear(index);
    }
  }
  
}
