/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.Package;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.ZipPackage;
import org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;

public class ZipPackagePart
extends PackagePart {
    private ZipEntry zipEntry;

    public ZipPackagePart(Package container, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(container, partName, contentType);
    }

    public ZipPackagePart(Package container, ZipEntry zipEntry, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(container, partName, contentType);
        this.zipEntry = zipEntry;
    }

    public ZipEntry getZipArchive() {
        return this.zipEntry;
    }

    protected InputStream getInputStreamImpl() throws IOException {
        return ((ZipPackage)this.container).getZipArchive().getInputStream(this.zipEntry);
    }

    protected OutputStream getOutputStreamImpl() {
        return null;
    }

    public boolean save(OutputStream os) throws OpenXML4JException {
        return new ZipPartMarshaller().marshall(this, os);
    }

    public boolean load(InputStream ios) throws InvalidFormatException {
        throw new InvalidOperationException("Method not implemented !");
    }

    public void close() {
        throw new InvalidOperationException("Method not implemented !");
    }

    public void flush() {
        throw new InvalidOperationException("Method not implemented !");
    }
}

