/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.extractor;

import java.io.IOException;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.Package;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;

public class XSLFPowerPointExtractor
extends POIXMLTextExtractor {
    private XMLSlideShow slideshow;
    private boolean slidesByDefault = true;
    private boolean notesByDefault = false;

    public XSLFPowerPointExtractor(XMLSlideShow slideshow) {
        super(slideshow._getXSLFSlideShow());
        this.slideshow = slideshow;
    }

    public XSLFPowerPointExtractor(XSLFSlideShow slideshow) throws XmlException, IOException {
        this(new XMLSlideShow(slideshow));
    }

    public XSLFPowerPointExtractor(Package container) throws XmlException, OpenXML4JException, IOException {
        this(new XSLFSlideShow(container));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  HXFPowerPointExtractor <filename.pptx>");
            System.exit(1);
        }
        XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(new XSLFSlideShow(args[0]));
        System.out.println(extractor.getText());
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
    }

    public String getText() {
        return this.getText(this.slidesByDefault, this.notesByDefault);
    }

    public String getText(boolean slideText, boolean notesText) {
        StringBuffer text = new StringBuffer();
        XSLFSlide[] slides = this.slideshow.getSlides();
        for (int i = 0; i < slides.length; ++i) {
            CTSlide rawSlide = slides[i]._getCTSlide();
            CTSlideIdListEntry slideId = slides[i]._getCTSlideId();
            try {
                CTNotesSlide notes = this.slideshow._getXSLFSlideShow().getNotes(slideId);
                CTCommentList comments = this.slideshow._getXSLFSlideShow().getSlideComments(slideId);
                if (slideText) {
                    this.extractText(rawSlide.getCSld().getSpTree(), text);
                    if (comments != null) {
                        for (CTComment comment : comments.getCmArray()) {
                            text.append(comment.getText() + "\n");
                        }
                    }
                }
                if (!notesText || notes == null) continue;
                this.extractText(notes.getCSld().getSpTree(), text);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return text.toString();
    }

    private void extractText(CTGroupShape gs, StringBuffer text) {
        CTShape[] shapes = gs.getSpArray();
        for (int i = 0; i < shapes.length; ++i) {
            CTTextBody textBody = shapes[i].getTxBody();
            if (textBody == null) continue;
            CTTextParagraph[] paras = textBody.getPArray();
            for (int j = 0; j < paras.length; ++j) {
                CTRegularTextRun[] textRuns = paras[j].getRArray();
                for (int k = 0; k < textRuns.length; ++k) {
                    text.append(textRuns[k].getT());
                }
                text.append("\n");
            }
        }
    }
}

