/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvenFooter;
import org.apache.poi.xssf.usermodel.XSSFEvenHeader;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFFirstFooter;
import org.apache.poi.xssf.usermodel.XSSFFirstHeader;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFOddFooter;
import org.apache.poi.xssf.usermodel.XSSFOddHeader;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetData;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static POILogger logger = POILogFactory.getLogger(XSSFSheet.class);
    private static float DEFAULT_COLUMN_WIDTH = 9.140625f;
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private TreeMap<Integer, Row> rows;
    private List<XSSFHyperlink> hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map<Integer, XSSFCell> sharedFormulas;

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    @Override
    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(InputStream is) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse((InputStream)is).getWorksheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (!(p instanceof CommentsTable)) continue;
            this.sheetComments = (CommentsTable)p;
        }
        this.initHyperlinks();
    }

    @Override
    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
    }

    private void initRows(CTWorksheet worksheet) {
        this.rows = new TreeMap();
        this.sharedFormulas = new HashMap<Integer, XSSFCell>();
        for (CTRow row : worksheet.getSheetData().getRowArray()) {
            XSSFRow r = new XSSFRow(row, this);
            this.rows.put(r.getRowNum(), r);
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            for (CTHyperlink hyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                PackageRelationship hyperRel = null;
                if (hyperlink.getId() != null) {
                    hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet worksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr ctFormat = worksheet.addNewSheetFormatPr();
        ctFormat.setDefaultRowHeight(15.0);
        CTSheetView ctView = worksheet.addNewSheetViews().addNewSheetView();
        ctView.setWorkbookViewId(0L);
        worksheet.addNewDimension().setRef("A1");
        worksheet.addNewSheetData();
        CTPageMargins ctMargins = worksheet.addNewPageMargins();
        ctMargins.setBottom(0.75);
        ctMargins.setFooter(0.3);
        ctMargins.setHeader(0.3);
        ctMargins.setLeft(0.7);
        ctMargins.setRight(0.7);
        ctMargins.setTop(0.75);
        return worksheet;
    }

    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    public String getSheetName() {
        return this.sheet.getName();
    }

    public int addMergedRegion(CellRangeAddress cra) {
        CTMergeCells ctMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(cra.formatAsString());
        return ctMergeCells.sizeOfMergeCellArray();
    }

    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = ColumnHelper.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            this.columnHelper.setColBestFit(column, true);
            this.columnHelper.setCustomWidth(column, true);
            this.columnHelper.setColWidth(column, width);
        }
    }

    public XSSFDrawing createDrawingPatriarch() {
        XSSFDrawing drawing = null;
        CTDrawing ctDrawing = this.worksheet.getDrawing();
        if (ctDrawing == null) {
            int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
            drawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
            String relId = drawing.getPackageRelationship().getId();
            ctDrawing = this.worksheet.addNewDrawing();
            ctDrawing.setId(relId);
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFDrawing)) continue;
                XSSFDrawing dr = (XSSFDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(7, (Object)("Can't find drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships"));
            }
        }
        return drawing;
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        CTPane pane = this.getPane();
        if (colSplit > 0) {
            pane.setXSplit((double)colSplit);
        }
        if (rowSplit > 0) {
            pane.setYSplit((double)rowSplit);
        }
        pane.setState(STPaneState.FROZEN);
        if (rowSplit == 0) {
            pane.setTopLeftCell(new CellReference(0, topRow).formatAsString());
            pane.setActivePane(STPane.TOP_RIGHT);
        } else if (colSplit == 0) {
            pane.setTopLeftCell(new CellReference(rowSplit, 0).formatAsString());
            pane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            pane.setTopLeftCell(new CellReference(leftmostColumn, topRow).formatAsString());
            pane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        CTSheetView ctView = this.getDefaultSheetView();
        ctView.setSelectionArray(null);
        CTSelection sel = ctView.addNewSelection();
        sel.setPane(pane.getActivePane());
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    public XSSFComment createComment() {
        if (this.sheetComments == null) {
            this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
        }
        return this.sheetComments.addComment();
    }

    public XSSFRow createRow(int rownum) {
        CTRow ctRow = CTRow.Factory.newInstance();
        XSSFRow r = new XSSFRow(ctRow, this);
        r.setRowNum(rownum);
        this.rows.put(r.getRowNum(), r);
        return r;
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.createFreezePane(xSplitPos, ySplitPos, leftmostColumn, topRow);
        this.getPane().setActivePane(STPane.Enum.forInt((int)activePane));
    }

    public XSSFComment getCellComment(int row, int column) {
        if (this.sheetComments == null) {
            return null;
        }
        return this.sheetComments.findCellComment(row, column);
    }

    public XSSFHyperlink getHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        for (XSSFHyperlink hyperlink : this.hyperlinks) {
            if (!hyperlink.getCellRef().equals(ref)) continue;
            return hyperlink;
        }
        return null;
    }

    public int[] getColumnBreaks() {
        if (!this.worksheet.isSetColBreaks() || this.worksheet.getColBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getColBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId();
        }
        return breaks;
    }

    private CTPageBreak getSheetTypeColumnBreaks() {
        if (this.worksheet.getColBreaks() == null) {
            this.worksheet.setColBreaks(CTPageBreak.Factory.newInstance());
        }
        return this.worksheet.getColBreaks();
    }

    public int getColumnWidth(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        double width = col == null || !col.isSetWidth() ? (double)DEFAULT_COLUMN_WIDTH : col.getWidth();
        return (int)(width * 256.0);
    }

    public int getDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 8 : (int)pr.getBaseColWidth();
    }

    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return (float)(pr == null ? 0.0 : pr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    public CellStyle getColumnStyle(int column) {
        return null;
    }

    public boolean getDisplayGuts() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : sheetPr.getOutlinePr();
        return outlinePr.getShowOutlineSymbols();
    }

    public void setDisplayGuts(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? sheetPr.addNewOutlinePr() : sheetPr.getOutlinePr();
        outlinePr.setShowOutlineSymbols(value);
    }

    public int getFirstRowNum() {
        return this.rows.size() == 0 ? -1 : this.rows.firstKey();
    }

    public boolean getFitToPage() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    public Footer getFooter() {
        return this.getOddFooter();
    }

    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        return new XSSFOddFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getEvenFooter() {
        return new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getFirstFooter() {
        return new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
    }

    public Header getOddHeader() {
        return new XSSFOddHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getEvenHeader() {
        return new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getFirstHeader() {
        return new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
    }

    public boolean getHorizontallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHorizontalCentered();
    }

    public int getLastRowNum() {
        return this.rows.size() == 0 ? -1 : this.rows.lastKey();
    }

    public short getLeftCol() {
        String cellRef = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return cellReference.getCol();
    }

    public double getMargin(short margin) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins pageMargins = this.worksheet.getPageMargins();
        switch (margin) {
            case 0: {
                return pageMargins.getLeft();
            }
            case 1: {
                return pageMargins.getRight();
            }
            case 2: {
                return pageMargins.getTop();
            }
            case 3: {
                return pageMargins.getBottom();
            }
            case 4: {
                return pageMargins.getHeader();
            }
            case 5: {
                return pageMargins.getFooter();
            }
        }
        throw new POIXMLException("Unknown margin constant:  " + margin);
    }

    public void setMargin(short margin, double size) {
        CTPageMargins pageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (margin) {
            case 0: {
                pageMargins.setLeft(size);
            }
            case 1: {
                pageMargins.setRight(size);
            }
            case 2: {
                pageMargins.setTop(size);
            }
            case 3: {
                pageMargins.setBottom(size);
            }
            case 4: {
                pageMargins.setHeader(size);
            }
            case 5: {
                pageMargins.setFooter(size);
            }
        }
    }

    public CellRangeAddress getMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        if (ctMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell ctMergeCell = ctMergeCells.getMergeCellArray(index);
        String ref = ctMergeCell.getRef();
        CellReference cell1 = new CellReference(ref.substring(0, ref.indexOf(":")));
        CellReference cell2 = new CellReference(ref.substring(ref.indexOf(":") + 1));
        return new CellRangeAddress(cell1.getRow(), cell2.getRow(), (int)cell1.getCol(), (int)cell2.getCol());
    }

    public int getNumMergedRegions() {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        return ctMergeCells == null ? 0 : ctMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    public PaneInformation getPaneInformation() {
        CTPane pane = this.getPane();
        CellReference cellRef = pane.isSetTopLeftCell() ? new CellReference(pane.getTopLeftCell()) : null;
        return new PaneInformation((short)pane.getXSplit(), (short)pane.getYSplit(), (short)(cellRef == null ? 0 : cellRef.getRow()), cellRef == null ? (short)0 : cellRef.getCol(), (byte)pane.getActivePane().intValue(), pane.getState() == STPaneState.FROZEN);
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public XSSFPrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    public boolean getProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getSheet();
    }

    public XSSFRow getRow(int rownum) {
        return (XSSFRow)this.rows.get(rownum);
    }

    public int[] getRowBreaks() {
        if (!this.worksheet.isSetRowBreaks() || this.worksheet.getRowBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getRowBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId();
        }
        return breaks;
    }

    public boolean getRowSumsBelow() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : null;
        return outlinePr == null || outlinePr.getSummaryBelow();
    }

    public void setRowSumsBelow(boolean value) {
        this.ensureOutlinePr().setSummaryBelow(value);
    }

    public boolean getRowSumsRight() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return outlinePr.getSummaryRight();
    }

    public void setRowSumsRight(boolean value) {
        this.ensureOutlinePr().setSummaryRight(value);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr sheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : sheetPr.addNewOutlinePr();
    }

    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    public short getTopRow() {
        String cellRef = this.getSheetTypeSheetView().getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return (short)cellReference.getRow();
    }

    public boolean getVerticallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getVerticalCentered();
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this.groupColumn1Based(fromColumn + 1, toColumn + 1);
    }

    private void groupColumn1Based(int fromColumn, int toColumn) {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol ctCol = CTCol.Factory.newInstance();
        ctCol.setMin((long)fromColumn);
        ctCol.setMax((long)toColumn);
        this.columnHelper.addCleanColIntoCols(ctCols, ctCol);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn1Based(index, false);
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel + 1));
            index = (int)col.getMax();
        }
        this.worksheet.setColsArray(0, ctCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void groupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) {
                xrow = this.createRow(i);
            }
            CTRow ctrow = xrow.getCTRow();
            short outlineLevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlineLevel + 1));
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        short outlineLevel = 0;
        for (Row r : this.rows.values()) {
            XSSFRow xrow = (XSSFRow)r;
            outlineLevel = xrow.getCTRow().getOutlineLevel() > outlineLevel ? xrow.getCTRow().getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    private short getMaxOutlineLevelCols() {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol[] colArray = ctCols.getColArray();
        short outlineLevel = 0;
        for (CTCol col : colArray) {
            outlineLevel = col.getOutlineLevel() > outlineLevel ? col.getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    public boolean isColumnBroken(short column) {
        int[] colBreaks = this.getColumnBreaks();
        for (int i = 0; i < colBreaks.length; ++i) {
            if (colBreaks[i] != column) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnHidden(int columnIndex) {
        return this.columnHelper.getColumn(columnIndex, false).getHidden();
    }

    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    public void setDisplayGridlines(boolean show) {
        this.getSheetTypeSheetView().setShowGridLines(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.getSheetTypeSheetView().setShowRowColHeaders(show);
    }

    public boolean isPrintGridlines() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getGridLines();
    }

    public void setPrintGridlines(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setGridLines(value);
    }

    public boolean isRowBroken(int row) {
        int[] rowBreaks = this.getRowBreaks();
        for (int i = 0; i < rowBreaks.length; ++i) {
            if (rowBreaks[i] != row) continue;
            return true;
        }
        return false;
    }

    public void setRowBreak(int row) {
        CTPageBreak pgBreak;
        CTPageBreak cTPageBreak = pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        if (!this.isRowBroken(row)) {
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)row);
        }
    }

    public void removeColumnBreak(short column) {
        CTBreak[] brkArray = this.getSheetTypeColumnBreaks().getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)column) continue;
            this.getSheetTypeColumnBreaks().removeBrk(i);
        }
    }

    public void removeMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        CTMergeCell[] mergeCellsArray = new CTMergeCell[ctMergeCells.sizeOfMergeCellArray() - 1];
        for (int i = 0; i < ctMergeCells.sizeOfMergeCellArray(); ++i) {
            if (i < index) {
                mergeCellsArray[i] = ctMergeCells.getMergeCellArray(i);
                continue;
            }
            if (i <= index) continue;
            mergeCellsArray[i - 1] = ctMergeCells.getMergeCellArray(i);
        }
        ctMergeCells.setMergeCellArray(mergeCellsArray);
    }

    public void removeRow(Row row) {
        this.rows.remove(row.getRowNum());
    }

    public void removeRowBreak(int row) {
        CTPageBreak pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)row) continue;
            pgBreak.removeBrk(i);
        }
    }

    public Iterator<Row> rowIterator() {
        return this.rows.values().iterator();
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    public boolean getAutobreaks() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getAutoPageBreaks();
    }

    public void setAutobreaks(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
        psSetup.setAutoPageBreaks(value);
    }

    public void setColumnBreak(short column) {
        if (!this.isColumnBroken(column)) {
            CTBreak brk = this.getSheetTypeColumnBreaks().addNewBrk();
            brk.setId((long)column);
        }
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.columnHelper.setColHidden(columnIndex, hidden);
    }

    public void setColumnWidth(int columnIndex, int width) {
        if (width > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(columnIndex, (double)width / 256.0);
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.columnHelper.setColDefaultStyle((long)column, style);
    }

    public void setDefaultColumnWidth(int width) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth((long)width);
    }

    public void setDefaultRowHeight(short height) {
        this.getSheetTypeSheetFormatPr().setDefaultRowHeight((double)height / 20.0);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this.getSheetTypeSheetFormatPr().setDefaultRowHeight((double)height);
    }

    public void setDisplayFormulas(boolean show) {
        this.getSheetTypeSheetView().setShowFormulas(show);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    public void setFitToPage(boolean b) {
        this.getSheetTypePageSetUpPr().setFitToPage(b);
    }

    public void setHorizontallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHorizontalCentered(value);
    }

    public void setVerticallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setVerticalCentered(value);
    }

    public void setZoom(int numerator, int denominator) {
        int zoom = 100 * numerator / denominator;
        this.setZoom(zoom);
    }

    public void setZoom(int scale) {
        if (scale < 10 || scale > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale((long)scale);
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            XSSFRow row = (XSSFRow)it.next();
            if (!copyRowHeight) {
                row.setHeight((short)-1);
            }
            if (resetOriginalRowHeight && this.getDefaultRowHeight() >= 0) {
                row.setHeight(this.getDefaultRowHeight());
            }
            if (this.removeRow(startRow, endRow, n, row.getRowNum())) {
                it.remove();
                continue;
            }
            if (row.getRowNum() < startRow || row.getRowNum() > endRow) continue;
            row.shift(n);
        }
        TreeMap<Integer, Row> map = new TreeMap<Integer, Row>();
        Iterator<Row> i$ = this.iterator();
        while (i$.hasNext()) {
            Row r = i$.next();
            map.put(r.getRowNum(), r);
        }
        this.rows = map;
    }

    public void showInPane(short toprow, short leftcol) {
        CellReference cellReference = new CellReference((int)toprow, leftcol);
        String cellRef = cellReference.formatAsString();
        this.getSheetTypeSheetView().setTopLeftCell(cellRef);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        CTCols cols = this.worksheet.getColsArray(0);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn(index, false);
            if (col == null) continue;
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel - 1));
            index = (int)col.getMax();
            if (col.getOutlineLevel() > 0) continue;
            int colIndex = this.columnHelper.getIndexOfColumn(cols, col);
            this.worksheet.getColsArray(0).removeCol(colIndex);
        }
        this.worksheet.setColsArray(0, cols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void ungroupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) continue;
            CTRow ctrow = xrow.getCTRow();
            short outlinelevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlinelevel - 1));
            if (ctrow.getOutlineLevel() != 0 || xrow.getFirstCellNum() != -1) continue;
            this.removeRow(xrow);
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short maxLevelRow = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(maxLevelRow);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short maxLevelCol = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(maxLevelCol);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    public boolean isSelected() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getTabSelected();
    }

    public void setSelected(boolean value) {
        CTSheetViews views = this.getSheetTypeSheetViews();
        for (CTSheetView view : views.getSheetViewArray()) {
            view.setTabSelected(value);
        }
    }

    public void setCellComment(String cellRef, XSSFComment comment) {
        CellReference cellReference = new CellReference(cellRef);
        comment.setRow(cellReference.getRow());
        comment.setColumn(cellReference.getCol());
    }

    protected void setCellHyperlink(XSSFHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String cellRef) {
        CTSelection ctsel = this.getSheetTypeSelection();
        ctsel.setActiveCell(cellRef);
        ctsel.setSqref(Arrays.asList(cellRef));
    }

    public boolean hasComments() {
        if (this.sheetComments == null) {
            return false;
        }
        return this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        if (this.sheetComments == null) {
            return 0;
        }
        return this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        CTSheetViews views = this.getSheetTypeSheetViews();
        if (views == null || views.getSheetViewArray() == null || views.getSheetViewArray().length <= 0) {
            return null;
        }
        return views.getSheetViewArray(views.getSheetViewArray().length - 1);
    }

    protected CommentsTable getCommentsTable() {
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        return sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
    }

    private boolean removeRow(int startRow, int endRow, int n, int rownum) {
        if (rownum >= startRow + n && rownum <= endRow + n) {
            if (n > 0 && rownum > endRow) {
                return true;
            }
            if (n < 0 && rownum < startRow) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    XSSFCell getSharedFormulaCell(int sid) {
        return this.sharedFormulas.get(sid);
    }

    void onReadCell(XSSFCell cell) {
        CTCell ct = cell.getCTCell();
        CTCellFormula f = ct.getF();
        if (f != null && f.getT() == STCellFormulaType.SHARED && f.isSetRef() && f.getStringValue() != null) {
            this.sharedFormulas.put((int)f.getSi(), cell);
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.write(out);
        out.close();
    }

    protected void write(OutputStream out) throws IOException {
        CTCols col;
        CTCol[] cols;
        if (this.worksheet.getColsArray().length == 1 && (cols = (col = this.worksheet.getColsArray(0)).getColArray()).length == 0) {
            this.worksheet.setColsArray(null);
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            CTHyperlink[] ctHls = new CTHyperlink[this.hyperlinks.size()];
            for (int i = 0; i < ctHls.length; ++i) {
                XSSFHyperlink hyperlink = this.hyperlinks.get(i);
                hyperlink.generateRelationIfNeeded(this.getPackagePart());
                ctHls[i] = hyperlink.getCTHyperlink();
            }
            this.worksheet.getHyperlinks().setHyperlinkArray(ctHls);
        }
        CTSheetData sheetData = this.worksheet.getSheetData();
        ArrayList<CTRow> rArray = new ArrayList<CTRow>(this.rows.size());
        for (Row row : this.rows.values()) {
            XSSFRow r = (XSSFRow)row;
            r.onDocumentWrite();
            rArray.add(r.getCTRow());
        }
        sheetData.setRowArray(rArray.toArray(new CTRow[rArray.size()]));
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        this.worksheet.save(out, xmlOptions);
    }
}

